/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.projection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.Assign;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.Choice;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Conditional;
import org.pi4soa.cdl.ExceptionHandler;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.Finalize;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.NoAction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Parallel;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.Perform;
import org.pi4soa.cdl.Sequence;
import org.pi4soa.cdl.SilentAction;
import org.pi4soa.cdl.When;
import org.pi4soa.cdl.While;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceFactory;
import org.pi4soa.common.resource.ArtifactManager;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.BehaviorFactory;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageActivity;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.NameSpace;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.PartDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.TokenLocator;
import org.pi4soa.service.behavior.projection.CDL2ChoreoToBehaviorProjector;
import org.pi4soa.service.behavior.projection.DefaultServiceTypeResolver;
import org.pi4soa.service.behavior.projection.ServiceTypeResolver;
import org.pi4soa.service.util.BehaviorTypeUtil;

public class CDL2ToBehaviorProjector
implements CDLVisitor {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.projection");
    private static final String SERVICE_ENDPOINT_NS_PREFIX = "sens";
    private ServiceDescription m_serviceDescription = null;
    private ParticipantType m_participantType = null;
    private ArtifactManager m_artifacts = null;
    private ServiceTypeResolver m_resolver = new DefaultServiceTypeResolver();
    private Vector m_choreoProjectorStack = new Vector();
    private Vector m_createdProjectors = new Vector();

    public CDL2ToBehaviorProjector(ParticipantType participantType) {
        this.m_participantType = participantType;
    }

    public CDL2ToBehaviorProjector(ParticipantType participantType, ArtifactManager artifacts) {
        this.m_participantType = participantType;
        this.m_artifacts = artifacts;
    }

    protected void initialize() {
        this.m_serviceDescription = BehaviorFactory.eINSTANCE.createServiceDescription();
    }

    public void setServiceTypeResolver(ServiceTypeResolver resolver) {
        this.m_resolver = resolver;
    }

    public ServiceDescription getServiceDescription() throws ServiceException {
        if (this.m_serviceDescription != null) {
            this.m_serviceDescription.initialize();
        }
        return this.m_serviceDescription;
    }

    public void assign(Assign assign) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.assign(assign);
        }
    }

    public void choiceStart(Choice choice) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.choiceStart(choice);
        }
    }

    public void choiceEnd(Choice choice) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.choiceEnd(choice);
        }
    }

    public void choreographyStart(Choreography choreography) {
        Vector newlist = new Vector();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create choreography projectors for: " + choreography.getFullyQualifiedName());
        }
        if (this.getChoreoProjectors().size() > 0) {
            for (CDL2ChoreoToBehaviorProjector parentProjector : this.getChoreoProjectors()) {
                this.createCDL2ChoreoProjectors(choreography, parentProjector.getParticipant(), parentProjector.getBehaviorDescription(), newlist);
            }
        } else if (choreography.getParent() instanceof Package) {
            this.createCDL2ChoreoProjectors(choreography, null, null, newlist);
        }
        this.pushChoreoProjectors(newlist);
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.choreographyStart(choreography);
        }
    }

    protected void createCDL2ChoreoProjectors(Choreography choreography, Participant parentPart, BehaviorDescription parentBehaviorDescription, List newlist) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create choreography projector: choreo=" + choreography.getFullyQualifiedName() + " parent participant=" + parentPart);
        }
        if (choreography.getParticipantDefinitions().size() > 0) {
            int i = 0;
            while (i < choreography.getParticipantDefinitions().size()) {
                Participant part = (Participant)choreography.getParticipantDefinitions().get(i);
                if (this.m_participantType != null && this.m_participantType.getRoleTypes().containsAll((Collection)part.getRoleTypes()) && this.shouldCreateProjector(choreography, part)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Create choreography projector: for participant instance " + part);
                    }
                    CDL2ChoreoToBehaviorProjector projector = new CDL2ChoreoToBehaviorProjector(this.m_participantType, part, this.m_serviceDescription, parentBehaviorDescription, this.m_resolver);
                    newlist.add(projector);
                }
                ++i;
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Create choreography projector: singleton for sub-choreography");
            }
            CDL2ChoreoToBehaviorProjector projector = new CDL2ChoreoToBehaviorProjector(this.m_participantType, null, this.m_serviceDescription, parentBehaviorDescription, this.m_resolver);
            newlist.add(projector);
        }
    }

    protected boolean shouldCreateProjector(Choreography choreography, Participant part) {
        boolean ret = false;
        if (part.getFree() != Boolean.TRUE) {
            String name = String.valueOf(choreography.getFullyQualifiedName()) + ":" + part.getName();
            if (!this.m_createdProjectors.contains(name)) {
                ret = true;
                this.m_createdProjectors.add(name);
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public void choreographyEnd(Choreography choreography) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.choreographyEnd(choreography);
        }
        this.popChoreoProjectors();
    }

    public void conditionalStart(Conditional conditional) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.conditionalStart(conditional);
        }
    }

    public void conditionalEnd(Conditional conditional) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.conditionalEnd(conditional);
        }
    }

    public void exceptionHandlerStart(ExceptionHandler handler) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.exceptionHandlerStart(handler);
        }
    }

    public void exceptionHandlerEnd(ExceptionHandler handler) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.exceptionHandlerEnd(handler);
        }
    }

    public void exceptionWorkUnitStart(ExceptionWorkUnit workunit) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.exceptionWorkUnitStart(workunit);
        }
    }

    public void exceptionWorkUnitEnd(ExceptionWorkUnit workunit) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.exceptionWorkUnitEnd(workunit);
        }
    }

    public void finalizerStart(FinalizerHandler finalizer) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.finalizerStart(finalizer);
        }
    }

    public void finalizerEnd(FinalizerHandler finalizer) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.finalizerEnd(finalizer);
        }
    }

    public void finalize(Finalize finalize) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.finalize(finalize);
        }
    }

    public void interaction(Interaction interaction) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.interaction(interaction);
        }
    }

    public void noAction(NoAction noAction) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.noAction(noAction);
        }
    }

    public void packageStart(Package pack) {
        this.initialize();
        if (this.m_participantType != null) {
            String serviceName = this.convertQName((CDLType)this.m_participantType, this.m_participantType.getName());
            this.m_serviceDescription.setName(serviceName);
            this.m_serviceDescription.setVersion(pack.getVersion());
            this.m_serviceDescription.setStateless(this.m_participantType.getStateless());
            if (NamesUtil.isSet((String)pack.getTargetNamespace())) {
                NameSpace tns = BehaviorFactory.eINSTANCE.createNameSpace();
                tns.setPrefix(SERVICE_ENDPOINT_NS_PREFIX);
                tns.setURI(pack.getTargetNamespace());
                this.m_serviceDescription.getNameSpaces().add((Object)tns);
            }
            for (org.pi4soa.cdl.NameSpace cdlns : pack.getTypeDefinitions().getNameSpaces()) {
                NameSpace ns = BehaviorFactory.eINSTANCE.createNameSpace();
                ns.setPrefix(cdlns.getPrefix());
                ns.setURI(cdlns.getURI());
                this.m_serviceDescription.getNameSpaces().add((Object)ns);
            }
            for (org.pi4soa.cdl.InformationType cdlInfoType : pack.getTypeDefinitions().getInformationTypes()) {
                InformationType infoType = BehaviorFactory.eINSTANCE.createInformationType();
                infoType.setName(cdlInfoType.getName());
                infoType.setDescription(cdlInfoType.getDescription());
                if (NamesUtil.isSet((String)cdlInfoType.getTypeName())) {
                    String type = cdlInfoType.getTypeName();
                    infoType.setType(type);
                }
                if (NamesUtil.isSet((String)cdlInfoType.getElementName())) {
                    String elem = cdlInfoType.getElementName();
                    infoType.setElement(elem);
                }
                this.m_serviceDescription.getInformationTypes().add((Object)infoType);
                for (org.pi4soa.cdl.TokenLocator cdlLocator : pack.getTypeDefinitions().getTokenLocators()) {
                    if (cdlLocator.getInformationType() != cdlInfoType) continue;
                    TokenLocator tl = BehaviorFactory.eINSTANCE.createTokenLocator();
                    tl.setDescription(cdlLocator.getDescription());
                    tl.setName(cdlLocator.getToken().getName());
                    tl.setPart(cdlLocator.getPart());
                    tl.setQuery(cdlLocator.getQuery());
                    tl.setType(cdlLocator.getToken().getInformationType().getTypeName());
                    tl.setElement(cdlLocator.getToken().getInformationType().getElementName());
                    infoType.getTokenLocators().add((Object)tl);
                }
            }
        }
    }

    public void packageEnd(Package pack) {
        Object list = this.m_serviceDescription.getServiceTypes();
        int i = list.size() - 1;
        while (i >= 0) {
            ServiceType stype = (ServiceType)list.get(i);
            if (stype.getOperationDefinitions().size() == 0) {
                list.remove(i);
            }
            --i;
        }
        this.completeInterfaceDefinitions(pack);
        if (this.m_serviceDescription.getBehaviorDescriptions().size() > 1) {
            list = this.m_serviceDescription.getBehaviorDescriptions();
            i = list.size() - 1;
            while (i >= 0) {
                MessageActivity[] mas;
                BehaviorDescription bd = (BehaviorDescription)list.get(i);
                if (bd.getRoot() != Boolean.TRUE && bd.getPerformingActivities().size() == 0 && ((mas = bd.getInitialMessageActivities()) == null || mas.length == 0)) {
                    list.remove(i);
                }
                --i;
            }
        }
    }

    protected void completeInterfaceDefinitions(Package pack) {
        if (this.m_artifacts != null && this.m_serviceDescription != null) {
            for (ServiceType st : this.m_serviceDescription.getServiceTypes()) {
                String intfName;
                String intfNamespace = NameSpaceUtil.getNamespace((String)st.getName());
                InterfaceDefinition id = InterfaceFactory.getInterfaceDefinition((Package)pack, (ArtifactManager)this.m_artifacts, (String)intfNamespace, (String)(intfName = NameSpaceUtil.getLocalPart((String)st.getName())));
                if (id != null) {
                    this.completeServiceType(st, id);
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("No interface definition found for service type '" + st.getName() + "'");
            }
        }
    }

    protected void completeServiceType(ServiceType st, InterfaceDefinition id) {
        for (OperationDefinition op : st.getOperationDefinitions()) {
            List opdefs;
            String reqType = null;
            String reqNS = null;
            MessageDefinition mdef = null;
            mdef = op.getRequest();
            if (mdef != null) {
                if (NamesUtil.isSet((String)mdef.getInformationType().getType())) {
                    reqNS = BehaviorTypeUtil.getNamespace(mdef.getInformationType().getType(), mdef);
                    reqType = XMLUtils.getLocalname((String)mdef.getInformationType().getType());
                } else if (NamesUtil.isSet((String)mdef.getInformationType().getElement())) {
                    reqNS = BehaviorTypeUtil.getNamespace(mdef.getInformationType().getElement(), mdef);
                    reqType = XMLUtils.getLocalname((String)mdef.getInformationType().getElement());
                }
            }
            if ((opdefs = id.getOperations(op.getName(), reqNS, reqType, null, null)).size() == 1) {
                this.completeOperationDefinition(op, (org.pi4soa.cdl.interfaces.OperationDefinition)opdefs.get(0));
                continue;
            }
            if (opdefs.size() > 1) {
                logger.warning("Multiple operation definitions found for '" + op.getName() + "' and request type '" + NameSpaceUtil.getFullyQualifiedName((String)reqNS, (String)reqType) + "'");
                continue;
            }
            logger.severe("Could not find operation '" + op.getName() + "' on service type '" + st.getName() + "'");
        }
    }

    protected void completeOperationDefinition(OperationDefinition op, org.pi4soa.cdl.interfaces.OperationDefinition opdef) {
        org.pi4soa.cdl.interfaces.MessageDefinition mesgdef;
        MessageDefinition mesg2 = op.getRequest();
        if (mesg2 != null) {
            mesgdef = opdef.getMessage(null, null, 0);
            if (mesgdef != null) {
                this.completeMessageDefinition(mesg2, mesgdef);
            } else {
                logger.severe("Could not find message for request on operation '" + op.getName() + "'");
            }
        }
        if ((mesg2 = op.getResponse()) != null) {
            mesgdef = opdef.getMessage(null, null, 1);
            if (mesgdef != null) {
                this.completeMessageDefinition(mesg2, mesgdef);
            } else {
                logger.severe("Could not find message for response on operation '" + op.getName() + "'");
            }
        }
        for (MessageDefinition mesg2 : op.getFaults()) {
            String faultName;
            String faultNamespace = NameSpaceUtil.getNamespace((String)mesg2.getName());
            org.pi4soa.cdl.interfaces.MessageDefinition mesgdef2 = opdef.getMessage(faultNamespace, faultName = NameSpaceUtil.getLocalPart((String)mesg2.getName()), 3);
            if (mesgdef2 != null) {
                this.completeMessageDefinition(mesg2, mesgdef2);
                continue;
            }
            logger.severe("Could not find message for fault '" + mesg2.getName() + "' on operation '" + op.getName() + "'");
        }
    }

    protected void completeMessageDefinition(MessageDefinition mesg, org.pi4soa.cdl.interfaces.MessageDefinition mesgdef) {
        if (mesg.getInformationType() == null) {
            String prefix;
            String mesgtype = null;
            String mesgelem = null;
            if (mesgdef.getType() != null) {
                prefix = mesg.getServiceDescription().getNameSpacePrefixForURI(mesgdef.getTypeNamespace());
                mesgtype = String.valueOf(prefix) + ":" + mesgdef.getType();
            }
            if (mesgdef.getElement() != null) {
                prefix = mesg.getServiceDescription().getNameSpacePrefixForURI(mesgdef.getElementNamespace());
                mesgelem = String.valueOf(prefix) + ":" + mesgdef.getElement();
            }
            InformationType infoType = null;
            Iterator iter = mesg.getServiceDescription().getInformationTypes().iterator();
            while (infoType == null && iter.hasNext()) {
                InformationType itype = (InformationType)iter.next();
                if (mesgtype != null && itype.getType().equals(mesgtype)) {
                    infoType = itype;
                    continue;
                }
                if (mesgelem == null || !itype.getElement().equals(mesgelem)) continue;
                infoType = itype;
            }
            if (infoType != null) {
                mesg.setInformationType(infoType);
            } else {
                logger.severe("Failed to complete information type for message definition: " + mesgdef);
            }
        }
        int i = 0;
        while (mesgdef.getPartDefinitions() != null && i < mesgdef.getPartDefinitions().length) {
            org.pi4soa.cdl.interfaces.PartDefinition partdef = mesgdef.getPartDefinitions()[i];
            PartDefinition part = mesg.getPartDefinition(partdef.getName());
            if (part == null) {
                part = BehaviorFactory.eINSTANCE.createPartDefinition();
                part.setName(partdef.getName());
                mesg.getPartDefinitions().add((Object)part);
            }
            if (part.getInformationType() == null) {
                String prefix;
                String mesgtype = null;
                String mesgelem = null;
                if (mesgdef.getType() != null) {
                    prefix = mesg.getServiceDescription().getNameSpacePrefixForURI(partdef.getTypeNamespace());
                    mesgtype = String.valueOf(prefix) + ":" + partdef.getType();
                }
                if (mesgdef.getElement() != null) {
                    prefix = mesg.getServiceDescription().getNameSpacePrefixForURI(partdef.getElementNamespace());
                    mesgelem = String.valueOf(prefix) + ":" + partdef.getElement();
                }
                InformationType infoType = null;
                Iterator iter = mesg.getServiceDescription().getInformationTypes().iterator();
                while (infoType == null && iter.hasNext()) {
                    InformationType itype = (InformationType)iter.next();
                    if (mesgtype != null && itype.getType().equals(mesgtype)) {
                        infoType = itype;
                        continue;
                    }
                    if (mesgelem == null || !itype.getElement().equals(mesgelem)) continue;
                    infoType = itype;
                }
                if (infoType != null) {
                    part.setInformationType(infoType);
                } else {
                    logger.severe("Failed to complete information type for part definition: " + partdef);
                }
            }
            ++i;
        }
    }

    public void parallelStart(Parallel parallel) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.parallelStart(parallel);
        }
    }

    public void parallelEnd(Parallel parallel) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.parallelEnd(parallel);
        }
    }

    public void perform(Perform perform) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.perform(perform);
        }
    }

    public void sequenceStart(Sequence sequence) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.sequenceStart(sequence);
        }
    }

    public void sequenceEnd(Sequence sequence) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.sequenceEnd(sequence);
        }
    }

    public void silentAction(SilentAction silentAction) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.silentAction(silentAction);
        }
    }

    public void whenStart(When when) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.whenStart(when);
        }
    }

    public void whenEnd(When when) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.whenEnd(when);
        }
    }

    public void whileStart(While whileElem) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.whileStart(whileElem);
        }
    }

    public void whileEnd(While whileElem) {
        for (CDL2ChoreoToBehaviorProjector projector : this.getChoreoProjectors()) {
            projector.whileEnd(whileElem);
        }
    }

    protected String convertQName(CDLType cdlType, String qname) {
        String ret = qname;
        if (XMLUtils.getPrefix((String)qname) == null) {
            ret = "sens:" + qname;
        }
        return ret;
    }

    protected List getChoreoProjectors() {
        List ret = null;
        ret = this.m_choreoProjectorStack.size() == 0 ? new Vector() : (List)this.m_choreoProjectorStack.get(0);
        return ret;
    }

    protected void pushChoreoProjectors(List choreoProjectorList) {
        this.m_choreoProjectorStack.insertElementAt(choreoProjectorList, 0);
    }

    protected List popChoreoProjectors() {
        List ret = null;
        if (this.m_choreoProjectorStack.size() > 0) {
            ret = (List)this.m_choreoProjectorStack.remove(0);
        }
        return ret;
    }
}

