/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.projection;

import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.behavior.projection.ServiceTypeResolver;

public class DefaultServiceTypeResolver
implements ServiceTypeResolver {
    public String resolve(Variable channelVariable) {
        String ret = null;
        if (channelVariable != null && channelVariable.getType() instanceof ChannelType) {
            ChannelType type = (ChannelType)channelVariable.getType();
            Behavior behavior = type.getBehavior();
            if (behavior == null && type.getRoleType() != null && type.getRoleType().getBehaviors().size() == 1) {
                behavior = (Behavior)type.getRoleType().getBehaviors().get(0);
            }
            if (behavior != null) {
                String qname = behavior.getInterface();
                if (!NamesUtil.isSet((String)qname)) {
                    qname = type.getRoleType().getName();
                    if (type.getRoleType().getBehaviors().size() > 1) {
                        qname = String.valueOf(qname) + (type.getRoleType().getBehaviors().indexOf((Object)behavior) + 1);
                    }
                }
                String namespace = CDLTypeUtil.getNamespace((String)qname, (CDLType)channelVariable, (boolean)true);
                String localpart = XMLUtils.getLocalname((String)qname);
                ret = NameSpaceUtil.getFullyQualifiedName((String)namespace, (String)localpart);
            }
            if (ret == null) {
                ret = "unknown";
            }
        }
        return ret;
    }
}

