/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.internal.InternalSession;

public class DateTimeFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.xpath");
    private SimpleDateFormat m_dateFormatter = new SimpleDateFormat(this.getFormatPattern());

    public DateTimeFunction(String name) {
        super(name);
    }

    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        String ret = null;
        InternalSession session = this.getInternalSession(context);
        if (session != null && this.validateParameters(parameters)) {
            Date datetime = null;
            if (session.getConfiguration().getTimeoutManager() != null) {
                datetime = session.getConfiguration().getTimeoutManager().getCurrentDateTime();
            } else {
                logger.info("Using real time as timeout manager not available");
                datetime = new Date();
            }
            if (datetime != null) {
                ret = this.m_dateFormatter.format(datetime);
            }
        }
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && parameters.length == 1) {
            ret = true;
        }
        return ret;
    }

    protected String getFormatPattern() {
        return null;
    }
}

