/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.SessionStatus;
import org.pi4soa.service.session.internal.InternalSession;

public class GetChoreographyStatusFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.xpath");
    private static final String FUNCTION_NAME = "getChoreographyStatus";

    public GetChoreographyStatusFunction() {
        super(FUNCTION_NAME);
    }

    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        String ret = null;
        InternalSession session = this.getInternalSession(context);
        if (session != null && this.validateParameters(parameters)) {
            try {
                List<Object> statuses = null;
                int status = 0;
                if (parameters.length == 1) {
                    statuses = session.getSessionStatuses((String)parameters[0]);
                } else {
                    statuses = new Vector<SessionStatus>();
                    statuses.add(session.getSessionStatus((String)parameters[0], (String)parameters[1]));
                }
                if (statuses != null) {
                    if (statuses.size() == 1) {
                        status = ((SessionStatus)statuses.get(0)).getStatus();
                    } else if (statuses.size() > 1) {
                        status = 5;
                    }
                }
                switch (status) {
                    case 0: {
                        ret = "instance-unknown";
                        break;
                    }
                    case 1: {
                        ret = "enabled";
                        break;
                    }
                    case 2: {
                        ret = "completed-successfully";
                        break;
                    }
                    case 3: {
                        ret = "completed-unsuccessfully";
                        break;
                    }
                    case 4: {
                        ret = "closed";
                        break;
                    }
                    case 5: {
                        ret = "ambiguous";
                        break;
                    }
                    default: {
                        logger.severe("Unknown session status '" + status + "'");
                        break;
                    }
                }
            }
            catch (XPathException xpe) {
                throw xpe;
            }
            catch (Throwable t) {
                throw new XPathException("Failed to invoke function '" + this.getFunctionName() + "': " + t, t);
            }
        }
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && (parameters.length == 1 || parameters.length == 2)) {
            ret = true;
            int i = 0;
            while (ret && i < parameters.length) {
                if (parameters[i] == null) {
                    if (i == 0) {
                        ret = false;
                    }
                } else if (!(parameters[i] instanceof String)) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }
}

