/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.internal.InternalSession;

public class GetVariableFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.xpath");
    private static final String FUNCTION_NAME = "getVariable";

    public GetVariableFunction() {
        super(FUNCTION_NAME);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        Object ret = null;
        InternalSession session = this.getInternalSession(context);
        if (session == null || !this.validateParameters(parameters)) return ret;
        try {
            void var7_10;
            Serializable serializable = session.getVariable((String)parameters[0]);
            if (serializable instanceof Map) {
                Map mesg = (Map)((Object)serializable);
                if (NamesUtil.isSet((String)((String)parameters[1]))) {
                    if (!mesg.containsKey(parameters[1])) throw new UnresolvedConstraintException(String.valueOf((String)parameters[0]) + "[" + parameters[1] + "]");
                    Object v = mesg.get(parameters[1]);
                } else if (NamesUtil.isSet((String)((String)parameters[2]))) {
                    if (mesg.size() != 1) throw new XPathException("Attempt to perform 'getVariable' with XPath expression '" + parameters[2] + "' on multipart variable '" + parameters[0] + "' without specifying the part name");
                    Object v = mesg.values().iterator().next();
                }
            }
            ret = var7_10 != null && NamesUtil.isSet((String)((String)parameters[2])) ? evaluator.evaluate((Object)var7_10, parameters[2].toString(), pres) : var7_10;
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Throwable throwable) {
            throw new XPathException("Failed to invoke function '" + this.getFunctionName() + "': " + throwable, throwable);
        }
        if (!logger.isLoggable(Level.FINEST)) return ret;
        logger.finest("GetVariable '" + parameters[0] + "'=" + ret);
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && (parameters.length == 3 || parameters.length == 4)) {
            ret = true;
            int i = 0;
            while (ret && i < parameters.length) {
                if (parameters[i] == null) {
                    if (i == 0) {
                        ret = false;
                    }
                } else if (!(parameters[i] instanceof String)) {
                    ret = false;
                }
                ++i;
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Validate parameters = " + ret);
        }
        return ret;
    }
}

