/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import java.util.List;
import java.util.Vector;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.SessionStatus;
import org.pi4soa.service.session.internal.InternalSession;

public class HasChoreographyCompletedFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static final String FUNCTION_NAME = "hasChoreographyCompleted";

    public HasChoreographyCompletedFunction() {
        super(FUNCTION_NAME);
    }

    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        Boolean ret = Boolean.FALSE;
        InternalSession session = this.getInternalSession(context);
        if (session != null && this.validateParameters(parameters)) {
            try {
                List<Object> statuses = null;
                if (parameters.length == 1) {
                    statuses = session.getSessionStatuses((String)parameters[0]);
                } else {
                    statuses = new Vector<SessionStatus>();
                    statuses.add(session.getSessionStatus((String)parameters[0], (String)parameters[1]));
                }
                if (statuses != null && statuses.size() > 0) {
                    ret = Boolean.TRUE;
                    int i = 0;
                    while (ret == Boolean.TRUE && i < statuses.size()) {
                        if (((SessionStatus)statuses.get(i)).getStatus() != 2 && ((SessionStatus)statuses.get(i)).getStatus() != 3 && ((SessionStatus)statuses.get(i)).getStatus() != 4) {
                            ret = Boolean.FALSE;
                        }
                        ++i;
                    }
                }
            }
            catch (XPathException xpe) {
                throw xpe;
            }
            catch (Throwable t) {
                throw new XPathException("Failed to invoke function '" + this.getFunctionName() + "': " + t, t);
            }
        }
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && (parameters.length == 1 || parameters.length == 2)) {
            ret = true;
            int i = 0;
            while (ret && i < parameters.length) {
                if (parameters[i] == null) {
                    if (i == 0) {
                        ret = false;
                    }
                } else if (!(parameters[i] instanceof String)) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }
}

