/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import org.pi4soa.common.util.TimeUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.internal.InternalSession;

public class HasDurationPassedFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static final String FUNCTION_NAME = "hasDurationPassed";

    public HasDurationPassedFunction() {
        super(FUNCTION_NAME);
    }

    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        Boolean ret = Boolean.FALSE;
        InternalSession session = this.getInternalSession(context);
        if (session != null && this.validateParameters(parameters)) {
            if (session.getConfiguration().getTimeoutManager() == null) {
                throw new XPathException("Timeout manager is not available");
            }
            if (this.isBlockingActivity(context)) {
                ActivityType activityType = this.getActivityType(context);
                long timeout = 0L;
                try {
                    timeout = TimeUtil.getDuration((String)((String)parameters[0]));
                }
                catch (IllegalArgumentException iae) {
                    throw new XPathException("Invalid duration: " + iae.getMessage());
                }
                if (activityType == null || activityType.getEndpointDescriptionURI() == null) {
                    throw new XPathException("Unable to identify activity type for timeout");
                }
                if (!session.pendingTimeout(activityType.getEndpointDescriptionURI(), (String)parameters[0])) {
                    try {
                        session.getConfiguration().getTimeoutManager().register(session.getPrimaryIdentities(), session.getId(), activityType.getEndpointDescriptionURI(), (String)parameters[0], timeout);
                    }
                    catch (Exception e) {
                        throw new XPathException("Failed to register timeout: " + e, (Throwable)e);
                    }
                } else if (session.hasTimedOut(activityType.getEndpointDescriptionURI(), (String)parameters[0])) {
                    ret = Boolean.TRUE;
                }
            }
        }
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && (parameters.length == 1 || parameters.length == 2)) {
            ret = true;
            int i = 0;
            while (ret && i < parameters.length) {
                if (parameters[i] == null) {
                    if (i == 0) {
                        ret = false;
                    }
                } else if (!(parameters[i] instanceof String)) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }
}

