/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.behavior.xpath;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathException;
import org.pi4soa.common.xpath.XPathFunction;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.behavior.xpath.DefaultBehaviorXPathFunction;
import org.pi4soa.service.session.internal.InternalSession;

public class IsVariableAvailableFunction
extends DefaultBehaviorXPathFunction
implements XPathFunction {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.behavior.xpath");
    private static final String FUNCTION_NAME = "isVariableAvailable";

    public IsVariableAvailableFunction() {
        super(FUNCTION_NAME);
    }

    public Object invoke(Object context, Object[] parameters, XMLPrefixResolver pres, XPathEvaluator evaluator) throws XPathException {
        Boolean ret = Boolean.FALSE;
        InternalSession session = this.getInternalSession(context);
        if (session != null && this.validateParameters(parameters)) {
            try {
                session.getVariable((String)parameters[0]);
                ret = Boolean.TRUE;
            }
            catch (LockedInformationException lockedInformationException) {
                ret = Boolean.TRUE;
            }
            catch (UnresolvedConstraintException unresolvedConstraintException) {
                ret = Boolean.FALSE;
            }
            catch (XPathException xpe) {
                throw xpe;
            }
            catch (Throwable t) {
                throw new XPathException("Failed to invoke function '" + this.getFunctionName() + "': " + t, t);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("IsVariableAvailable '" + parameters[0] + "'=" + ret);
            }
        }
        return ret;
    }

    protected boolean validateParameters(Object[] parameters) {
        boolean ret = false;
        if (parameters != null && parameters.length >= 1 && parameters.length <= 2) {
            ret = true;
            int i = 0;
            while (ret && i < parameters.length) {
                if (parameters[i] == null) {
                    if (i == 0) {
                        ret = false;
                    }
                } else if (!(parameters[i] instanceof String)) {
                    ret = false;
                }
                ++i;
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Validate parameters = " + ret);
        }
        return ret;
    }
}

