/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.util.logging.Logger;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.container.MessageDispatcher;
import org.pi4soa.service.container.MessageHandler;
import org.pi4soa.service.container.MessageTransformer;
import org.pi4soa.service.util.OperationMapper;
import org.pi4soa.service.util.OperationMapperFactory;

public abstract class AbstractMessageHandler
implements MessageHandler {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");
    private String m_name = null;
    private MessageDispatcher m_dispatcher = null;
    private boolean m_initialized = false;
    private OperationMapper m_operationMapper = null;
    private MessageTransformer m_inboundMessageTransformer = null;
    private MessageTransformer m_outboundMessageTransformer = null;

    public AbstractMessageHandler() {
    }

    public AbstractMessageHandler(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void initialize() throws ServiceException {
        if (this.m_initialized) {
            throw new ServiceException("Message handler '" + this.getName() + "' has already been initialized");
        }
        this.m_initialized = true;
    }

    protected boolean isInitialized() {
        return this.m_initialized;
    }

    public void setMessageDispatcher(MessageDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
    }

    protected MessageDispatcher getMessageDispatcher() {
        return this.m_dispatcher;
    }

    protected void schedule(Runnable task) {
        new Thread(task).start();
    }

    public boolean supportsEndpointReference(EndpointReference ref) {
        boolean ret = true;
        return ret;
    }

    public void close() throws ServiceException {
    }

    public MessageHandler getMessageHandlerForType(Class cls) {
        AbstractMessageHandler ret = null;
        if (cls != null && cls.isAssignableFrom(cls)) {
            ret = this;
        }
        return ret;
    }

    protected OperationMapper getOperationMapper() {
        if (this.m_operationMapper == null) {
            try {
                this.m_operationMapper = OperationMapperFactory.getOperationMapper();
            }
            catch (Exception e) {
                logger.severe("Failed to initialize operation mapper: " + e);
            }
        }
        return this.m_operationMapper;
    }

    public void setOutboundMessageTransformer(MessageTransformer transformer) {
        this.m_outboundMessageTransformer = transformer;
    }

    protected MessageTransformer getOutboundMessageTransformer() {
        return this.m_outboundMessageTransformer;
    }

    public void setInboundMessageTransformer(MessageTransformer transformer) {
        this.m_inboundMessageTransformer = transformer;
    }

    protected MessageTransformer getInboundMessageTransformer() {
        return this.m_inboundMessageTransformer;
    }
}

