/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.Map;
import org.pi4soa.service.MutableMessage;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.container.MessageTransformer;

public abstract class AbstractMessageTransformer
implements MessageTransformer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(MutableMessage message) throws ServiceException {
        if (message.isMultiPart()) {
            if (!(message.getValue() instanceof Map)) throw new ServiceException("Multi-part message is not a map");
            for (String partName : ((Map)((Object)message.getValue())).keySet()) {
                message.setMultiPartValue(partName, this.transformValue(message.getMultiPartValue(partName)));
            }
            return;
        } else {
            message.setValue(this.transformValue(message.getValue()));
        }
    }

    protected abstract Serializable transformValue(Serializable var1) throws ServiceException;
}

