/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathEvaluatorFactory;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.container.ContainerConfiguration;
import org.pi4soa.service.container.MessageHandler;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.ExtensionResolverFactory;
import org.pi4soa.service.registry.DefaultMutableServiceRegistry;
import org.pi4soa.service.registry.ServiceRegistry;
import org.pi4soa.service.repository.DefaultServiceRepository;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.session.DefaultIdentityManager;
import org.pi4soa.service.session.DefaultSessionManager;
import org.pi4soa.service.session.IdentityManager;
import org.pi4soa.service.session.SessionManager;
import org.pi4soa.service.timer.DefaultTimeoutManager;
import org.pi4soa.service.timer.TimeoutManager;
import org.pi4soa.service.tracker.LoggerServiceTracker;
import org.pi4soa.service.tracker.ServiceTracker;

public class DefaultContainerConfiguration
implements ContainerConfiguration {
    private MessageHandler[] m_clientMessageHandlers = null;
    private MessageHandler[] m_serverMessageHandlers = null;
    private ServiceRegistry m_serviceRegistry = null;
    private ServiceRepository m_serviceRepository = null;
    private TimeoutManager m_timeoutManager = null;
    private ServiceTracker m_serviceTracker = null;
    private SessionManager m_sessionManager = null;
    private IdentityManager m_identityManager = null;
    private XPathEvaluator m_xpathEvaluator = null;
    private ExtensionResolver m_extensionResolver = null;
    private EndpointReference[] m_endpointReferences = null;

    public DefaultContainerConfiguration() {
        this.initialize();
    }

    protected void initialize() {
        this.setServiceRegistry(new DefaultMutableServiceRegistry());
        this.setServiceRepository(new DefaultServiceRepository());
        this.setServiceTracker(new LoggerServiceTracker());
        this.setTimeoutManager(new DefaultTimeoutManager());
        this.setSessionManager(new DefaultSessionManager());
        this.setIdentityManager(new DefaultIdentityManager());
        this.setXPathEvaluator(XPathEvaluatorFactory.getXPathEvaluator());
        this.setExtensionResolver(ExtensionResolverFactory.getExtensionResolver());
    }

    public MessageHandler[] getClientMessageHandlers() {
        return this.m_clientMessageHandlers;
    }

    public MessageHandler getClientMessageHandlers(int pos) {
        return this.m_clientMessageHandlers[pos];
    }

    public MessageHandler getClientMessageHandler(Class cls) {
        MessageHandler ret = null;
        if (this.getClientMessageHandlers() != null) {
            int i = 0;
            while (ret == null && i < this.getClientMessageHandlers().length) {
                if (this.getClientMessageHandlers()[i] != null) {
                    ret = this.getClientMessageHandlers()[i].getMessageHandlerForType(cls);
                }
                ++i;
            }
        }
        return ret;
    }

    public void setClientMessageHandlers(MessageHandler[] handlers) {
        this.m_clientMessageHandlers = handlers;
    }

    public void setClientMessageHandlers(int pos, MessageHandler handler) {
        this.m_clientMessageHandlers[pos] = handler;
    }

    public MessageHandler[] getServerMessageHandlers() {
        return this.m_serverMessageHandlers;
    }

    public MessageHandler getServerMessageHandlers(int pos) {
        return this.m_serverMessageHandlers[pos];
    }

    public MessageHandler getServerMessageHandler(Class cls) {
        MessageHandler ret = null;
        if (this.getServerMessageHandlers() != null) {
            int i = 0;
            while (ret == null && i < this.getServerMessageHandlers().length) {
                if (this.getServerMessageHandlers()[i] != null) {
                    ret = this.getServerMessageHandlers()[i].getMessageHandlerForType(cls);
                }
                ++i;
            }
        }
        return ret;
    }

    public void setServerMessageHandlers(MessageHandler[] handlers) {
        this.m_serverMessageHandlers = handlers;
    }

    public void setServerMessageHandlers(int pos, MessageHandler handler) {
        this.m_serverMessageHandlers[pos] = handler;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry registry) {
        this.m_serviceRegistry = registry;
    }

    public ServiceRepository getServiceRepository() {
        return this.m_serviceRepository;
    }

    public void setServiceRepository(ServiceRepository repository) {
        this.m_serviceRepository = repository;
    }

    public ServiceTracker getServiceTracker() {
        return this.m_serviceTracker;
    }

    public void setServiceTracker(ServiceTracker tracker) {
        this.m_serviceTracker = tracker;
    }

    public TimeoutManager getTimeoutManager() {
        return this.m_timeoutManager;
    }

    public void setTimeoutManager(TimeoutManager manager) {
        this.m_timeoutManager = manager;
    }

    public SessionManager getSessionManager() {
        return this.m_sessionManager;
    }

    public void setSessionManager(SessionManager manager) {
        this.m_sessionManager = manager;
    }

    public IdentityManager getIdentityManager() {
        return this.m_identityManager;
    }

    public void setIdentityManager(IdentityManager manager) {
        this.m_identityManager = manager;
    }

    public XPathEvaluator getXPathEvaluator() {
        return this.m_xpathEvaluator;
    }

    public void setXPathEvaluator(XPathEvaluator evaluator) {
        this.m_xpathEvaluator = evaluator;
    }

    public ExtensionResolver getExtensionResolver() {
        return this.m_extensionResolver;
    }

    public void setExtensionResolver(ExtensionResolver resolver) {
        this.m_extensionResolver = resolver;
    }

    public EndpointReference[] getEndpointReferences() {
        return this.m_endpointReferences;
    }

    public void setEndpointReferences(EndpointReference[] refs) {
        this.m_endpointReferences = refs;
    }
}

