/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Message;
import org.pi4soa.service.container.AbstractMessageHandler;

public abstract class MessageHandlerInvocation
implements Runnable {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");
    private AbstractMessageHandler m_messageProvider = null;
    private Message m_request = null;
    private boolean m_responseExpected = false;

    public MessageHandlerInvocation(AbstractMessageHandler amp, Message request, boolean responseExpected) {
        this.m_messageProvider = amp;
        this.m_request = request;
        this.m_responseExpected = responseExpected;
    }

    public void run() {
        Message resp = this.invoke(this.m_request);
        if (this.m_responseExpected && resp != null) {
            try {
                this.m_messageProvider.getMessageDispatcher().dispatch(resp);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to dispatch response", e);
            }
        }
    }

    public abstract Message invoke(Message var1);

    public Message createResponse(Serializable value, String faultName, String type) {
        Message ret = null;
        if (this.m_request != null && this.m_messageProvider != null && this.m_messageProvider.getMessageDispatcher() != null) {
            ret = this.m_messageProvider.getMessageDispatcher().createResponse(this.m_request.getOperationName(), faultName, type, this.m_request.getServiceType(), this.m_request.getServiceEndpoint(), value, this.m_request.getSessionIdentity(), this.m_request.getChannelIdentity());
        }
        return ret;
    }

    public boolean isResponseExpected() {
        return this.m_responseExpected;
    }
}

