/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.FaultMessage;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.container.ContainerConfiguration;
import org.pi4soa.service.container.ServiceBeanServerHandler;
import org.pi4soa.service.container.ServiceContainer;
import org.pi4soa.service.container.ServiceContainerFactory;
import org.pi4soa.service.container.XMLContainerConfiguration;

public class ServiceBean {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");
    private ServiceDescription m_serviceDescription = null;
    private String m_serviceType = null;
    private ContainerConfiguration m_containerConfiguration = null;
    private ServiceBeanServerHandler m_serviceBeanServerHandler = null;
    private Hashtable m_responses = new Hashtable();
    private static Hashtable m_serverMessageHandlers = new Hashtable();
    private static Hashtable m_serverMessageHandlersCounter = new Hashtable();
    private static Hashtable m_containers = new Hashtable();
    private Integer m_key = new Integer(m_currentKey++);
    private static int m_currentKey = 0;

    public void setServiceDescription(ServiceDescription sdesc) {
        this.m_serviceDescription = sdesc;
    }

    public ServiceDescription getServiceDescription() {
        return this.m_serviceDescription;
    }

    public void setServiceType(String serviceType) {
        this.m_serviceType = serviceType;
    }

    public String getServiceType() {
        return this.m_serviceType;
    }

    public void setContainerConfiguration(ContainerConfiguration config) {
        this.m_containerConfiguration = config;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.m_containerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContainer getServiceContainer(String sdescName) throws ServiceException {
        ServiceContainer ret = null;
        if (sdescName == null) {
            throw new ServiceException("Service description name needs to be specified");
        }
        Hashtable hashtable = m_serverMessageHandlers;
        synchronized (hashtable) {
            ret = (ServiceContainer)m_containers.get(sdescName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable invoke(String operation, Serializable value) throws OutOfSequenceMessageException, UnexpectedMessageException, FaultMessage, ServiceException {
        Serializable ret = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this + ": Invoking operation '" + operation + "' on service bean: value=" + value);
        }
        if (this.getServiceType() == null) {
            throw new ServiceException("Service type has not been specified");
        }
        ServiceBeanServerHandler handler = this.getServerMessageHandler();
        if (handler == null) {
            throw new ServiceException("Unable to get service container");
        }
        String responseKey = Thread.currentThread().toString();
        Hashtable hashtable = this.m_responses;
        synchronized (hashtable) {
            boolean responseExpected = handler.handleRequest(this.getServiceType(), operation, value, this, (Serializable)((Object)responseKey));
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Is response expected? " + responseExpected);
            }
            if (responseExpected) {
                while (ret == null) {
                    Serializable resp = (Serializable)this.m_responses.remove(responseKey);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this + ": Response=" + resp);
                    }
                    if (resp instanceof ServiceException) {
                        throw (ServiceException)resp;
                    }
                    if (resp instanceof Message) {
                        if (NamesUtil.isSet((String)((Message)((Object)resp)).getFaultName())) {
                            throw new FaultMessage(((Message)((Object)resp)).getFaultName(), ((Message)((Object)resp)).getValue());
                        }
                        ret = ((Message)((Object)resp)).getValue();
                    } else if (resp != null) {
                        logger.severe("Unknown response: " + resp);
                    }
                    if (ret != null) continue;
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(this + ": Wait for response");
                        }
                        this.m_responses.wait();
                    }
                    catch (Exception e) {
                        logger.severe("Failed to wait for response: " + e);
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this + ": Invoking operation '" + operation + "' on service bean: ret=" + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ServiceException {
        ServiceDescription sdesc = this.getServiceDescription();
        logger.info("Closing service bean '" + this + "' for service description=" + sdesc);
        if (sdesc != null) {
            Hashtable hashtable = m_serverMessageHandlers;
            synchronized (hashtable) {
                Integer counter = (Integer)m_serverMessageHandlersCounter.get(sdesc.getName());
                if (counter == null) {
                    logger.severe("Server handler counter for '" + sdesc.getName() + "' could not be found");
                } else if (counter > 1) {
                    Integer newval = new Integer(counter - 1);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Counter for handler decremented: " + newval);
                    }
                    m_serverMessageHandlersCounter.put(sdesc.getName(), newval);
                } else {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Remove server handler for '" + sdesc.getName() + "'");
                    }
                    m_serverMessageHandlersCounter.remove(sdesc.getName());
                    m_serverMessageHandlers.remove(sdesc.getName());
                    ServiceContainer container = (ServiceContainer)m_containers.remove(sdesc.getName());
                    if (container == null) {
                        logger.severe("Failed to retrieve container for '" + sdesc.getName() + "' to be closed");
                    } else {
                        container.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse(Message message, Channel channel, OperationDefinition opdef, Serializable responseKey) throws ServiceException {
        Hashtable hashtable = this.m_responses;
        synchronized (hashtable) {
            this.m_responses.put(responseKey, message);
            this.m_responses.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ServiceBeanServerHandler getServerMessageHandler() throws ServiceException {
        if (this.m_serviceBeanServerHandler == null) {
            ServiceDescription sdesc = this.getServiceDescription();
            if (sdesc == null) {
                throw new ServiceException("Service description has not been specified");
            }
            Hashtable hashtable = m_serverMessageHandlers;
            synchronized (hashtable) {
                this.m_serviceBeanServerHandler = (ServiceBeanServerHandler)m_serverMessageHandlers.get(sdesc.getName());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Checked handler cache: " + this.m_serviceBeanServerHandler);
                }
                if (this.m_serviceBeanServerHandler == null) {
                    ContainerConfiguration config = this.m_containerConfiguration;
                    if (config == null) {
                        config = new XMLContainerConfiguration();
                    }
                    ServiceContainer container = ServiceContainerFactory.getServiceContainer(config);
                    this.m_serviceBeanServerHandler = new ServiceBeanServerHandler();
                    container.registerServerMessageHandler(this.m_serviceBeanServerHandler);
                    this.m_serviceBeanServerHandler.registerServiceBean(this);
                    logger.info("Registering service description '" + sdesc.getName() + "' with service repository");
                    container.getConfiguration().getServiceRepository().addServiceDescription(sdesc);
                    m_containers.put(sdesc.getName(), container);
                    m_serverMessageHandlers.put(sdesc.getName(), this.m_serviceBeanServerHandler);
                    m_serverMessageHandlersCounter.put(sdesc.getName(), new Integer(1));
                } else {
                    Integer counter = (Integer)m_serverMessageHandlersCounter.get(sdesc.getName());
                    if (counter == null) {
                        logger.severe("Server handler counter for '" + sdesc.getName() + "' could not be found");
                    } else {
                        Integer newval = new Integer(counter + 1);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Counter for handler incremented: " + newval);
                        }
                        m_serverMessageHandlersCounter.put(sdesc.getName(), newval);
                    }
                }
            }
        }
        return this.m_serviceBeanServerHandler;
    }

    protected Serializable getKey() {
        return this.m_key;
    }

    public void setServiceBeanServerHandler(ServiceBeanServerHandler handler) {
        this.m_serviceBeanServerHandler = handler;
    }
}

