/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Channel;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.container.AbstractMessageHandler;
import org.pi4soa.service.container.ServiceBean;

public class ServiceBeanServerHandler
extends AbstractMessageHandler {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");
    public static final String SERVICE_BEAN_KEY = "ServiceBeanKey";
    public static final String SERVICE_BEAN_RESPONSE_KEY = "ServiceBeanResponseKey";
    public static final String SERVICE_BEAN_SERVER_HANDLER = "ServiceBean-Server";
    private Hashtable m_serviceBeans = new Hashtable();

    public void registerServiceBean(ServiceBean sbean) {
        this.m_serviceBeans.put(sbean.getKey(), sbean);
    }

    public void unregisterServiceBean(ServiceBean sbean) {
        this.m_serviceBeans.remove(sbean.getKey());
    }

    protected ServiceBean getServiceBean(Object key) {
        ServiceBean ret = (ServiceBean)this.m_serviceBeans.get(key);
        return ret;
    }

    public String getName() {
        return SERVICE_BEAN_SERVER_HANDLER;
    }

    public void process(Message message, Channel channel, OperationDefinition opdef) throws ServiceException {
        ServiceBean serviceBean = this.getServiceBean(channel.getProperty(SERVICE_BEAN_KEY));
        Serializable responseKey = channel.getProperty(SERVICE_BEAN_RESPONSE_KEY);
        if (serviceBean != null) {
            serviceBean.handleResponse(message, channel, opdef, responseKey);
        }
    }

    public void acknowledge(Message message, Channel channel) throws ServiceException {
        channel.setProperty(SERVICE_BEAN_KEY, message.getProperty(SERVICE_BEAN_KEY));
        channel.setProperty(SERVICE_BEAN_RESPONSE_KEY, message.getProperty(SERVICE_BEAN_RESPONSE_KEY));
    }

    public boolean handleRequest(String serviceType, String opName, Serializable value, ServiceBean serviceBean, Serializable responseKey) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        boolean ret = false;
        if (this.getMessageDispatcher() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Handle request: serviceType=" + serviceType + " opName=" + opName + " value=" + value);
            }
            Message mesg = this.getMessageDispatcher().createRequest(opName, null, serviceType, null, value);
            Serializable key = serviceBean.getKey();
            mesg.setProperty(SERVICE_BEAN_KEY, key);
            if (responseKey != null) {
                mesg.setProperty(SERVICE_BEAN_RESPONSE_KEY, responseKey);
            }
            ret = this.getMessageDispatcher().dispatch(mesg);
        }
        return ret;
    }
}

