/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.container.MessageTransformer;
import org.w3c.dom.Node;

public class StringToDOMMessageTransformer
implements MessageTransformer {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable transform(Serializable message) throws ServiceException {
        Serializable ret = message;
        if (message instanceof String) {
            try {
                String value = (String)((Object)message);
                ret = (Serializable)((Object)XMLUtils.getNode((String)value));
                if (!logger.isLoggable(Level.FINER)) return ret;
                logger.finer("Transformed: value=" + value + " to=" + ret);
                return ret;
            }
            catch (Exception e) {
                throw new ServiceException("Failed to transform message: " + e, e);
            }
        } else {
            if (message instanceof Node) return ret;
            logger.severe("Message could not be transformed - was not a string or DOM: " + message);
        }
        return ret;
    }
}

