/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container;

import java.io.Serializable;
import java.util.logging.Logger;
import org.pi4soa.service.Channel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.MutableMessage;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.container.AbstractMessageDispatcher;
import org.pi4soa.service.container.AbstractMessageHandler;
import org.pi4soa.service.container.MessageHandler;
import org.pi4soa.service.container.MessageTransformer;
import org.pi4soa.service.tracker.ServiceTracker;

public class TransformMessageHandler
extends AbstractMessageHandler {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container");
    private MessageHandler m_messageHandler = null;
    private TransformDispatcher m_transformDispatcher = null;
    private MessageTransformer[] m_inboundMessageTransformers = null;
    private MessageTransformer[] m_outboundMessageTransformers = null;

    public String getName() {
        String ret = "";
        if (this.m_messageHandler != null) {
            ret = this.m_messageHandler.getName();
        }
        ret = "Transform[" + ret + "]";
        return ret;
    }

    public void initialize() throws ServiceException {
        super.initialize();
        if (this.m_messageHandler == null) {
            throw new ServiceException("Transform message handler has no associated message handler");
        }
        this.m_transformDispatcher = new TransformDispatcher();
        this.m_messageHandler.setMessageDispatcher(this.m_transformDispatcher);
        this.m_messageHandler.initialize();
    }

    public void process(Message message, Channel channel, OperationDefinition opdef) throws ServiceException {
        if (this.m_messageHandler != null) {
            if (message instanceof MutableMessage) {
                this.transformMessage((MutableMessage)message, this.getOutboundMessageTransformers());
            } else {
                logger.warning("Unable to transform message '" + message + "' as it is not mutable");
            }
            this.m_messageHandler.process(message, channel, opdef);
        }
    }

    public void acknowledge(Message message, Channel channel) throws ServiceException {
        this.m_messageHandler.acknowledge(message, channel);
    }

    public boolean supportsEndpointReference(EndpointReference ref) {
        boolean ret = false;
        if (this.m_messageHandler != null) {
            ret = this.m_messageHandler.supportsEndpointReference(ref);
        }
        return ret;
    }

    public void close() throws ServiceException {
        if (this.m_messageHandler != null) {
            this.m_messageHandler.close();
        }
    }

    public MessageHandler getMessageHandlerForType(Class cls) {
        MessageHandler ret = super.getMessageHandlerForType(cls);
        if (ret != null && this.m_messageHandler != null) {
            ret = this.m_messageHandler.getMessageHandlerForType(cls);
        }
        return ret;
    }

    public void setMessageHandler(MessageHandler handler) {
        this.m_messageHandler = handler;
    }

    public MessageHandler getMessageHandler() {
        return this.m_messageHandler;
    }

    public MessageTransformer[] getInboundMessageTransformers() {
        return this.m_inboundMessageTransformers;
    }

    public void setInboundMessageTransformers(MessageTransformer[] mts) {
        this.m_inboundMessageTransformers = mts;
    }

    public MessageTransformer getInboundMessageTransformers(int index) {
        return this.m_inboundMessageTransformers[index];
    }

    public void setInboundMessageTransformers(int index, MessageTransformer mt) {
        this.m_inboundMessageTransformers[index] = mt;
    }

    public MessageTransformer[] getOutboundMessageTransformers() {
        return this.m_outboundMessageTransformers;
    }

    public void setOutboundMessageTransformers(MessageTransformer[] mts) {
        this.m_outboundMessageTransformers = mts;
    }

    public MessageTransformer getOutboundMessageTransformers(int index) {
        return this.m_outboundMessageTransformers[index];
    }

    public void setOutboundMessageTransformers(int index, MessageTransformer mt) {
        this.m_outboundMessageTransformers[index] = mt;
    }

    protected void transformMessage(MutableMessage message, MessageTransformer[] transformers) throws ServiceException {
        int i = 0;
        while (transformers != null && i < transformers.length) {
            if (transformers[i] != null) {
                message.setValue(transformers[i].transform(message.getValue()));
            }
            ++i;
        }
    }

    public class TransformDispatcher
    extends AbstractMessageDispatcher {
        public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createRequest(opName, faultName, serviceType, serviceEndpoint, value);
            }
            return ret;
        }

        public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createRequest(opName, faultName, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createRequest(opName, faultName, type, serviceType, serviceEndpoint, value);
            }
            return ret;
        }

        public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createRequest(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createResponse(opName, faultName, serviceType, serviceEndpoint, value);
            }
            return ret;
        }

        public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createResponse(opName, faultName, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createResponse(opName, faultName, type, serviceType, serviceEndpoint, value);
            }
            return ret;
        }

        public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().createResponse(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public boolean dispatch(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
            boolean ret = false;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                if (message instanceof MutableMessage) {
                    TransformMessageHandler.this.transformMessage((MutableMessage)message, TransformMessageHandler.this.getInboundMessageTransformers());
                }
                ret = TransformMessageHandler.this.getMessageDispatcher().dispatch(message);
            }
            return ret;
        }

        public ServiceTracker getServiceTracker() {
            ServiceTracker ret = null;
            if (TransformMessageHandler.this.getMessageDispatcher() != null) {
                ret = TransformMessageHandler.this.getMessageDispatcher().getServiceTracker();
            }
            return ret;
        }
    }
}

