/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container.impl;

import java.util.logging.Logger;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.registry.MutableServiceRegistry;
import org.pi4soa.service.repository.ServiceRepositoryListener;

public class MutableServiceRegistryUpdater
implements ServiceRepositoryListener {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container.impl");
    private MutableServiceRegistry m_registry = null;
    private EndpointReference[] m_endpointRefs = null;

    public MutableServiceRegistryUpdater(MutableServiceRegistry registry, EndpointReference[] endpointRefs) {
        this.m_registry = registry;
        this.m_endpointRefs = endpointRefs;
    }

    public void serviceDescriptionAdded(ServiceDescription sdesc) {
        this.serviceDescriptionAdded(sdesc, this.m_endpointRefs);
    }

    public void serviceDescriptionAdded(ServiceDescription sdesc, EndpointReference[] endpointRefs) {
        if (this.m_registry != null && endpointRefs != null && endpointRefs.length > 0) {
            int i = 0;
            while (i < endpointRefs.length) {
                this.m_registry.register(sdesc, endpointRefs[i]);
                ++i;
            }
        }
    }

    public void serviceDescriptionUpdated(ServiceDescription oldsdesc, ServiceDescription newsdesc) {
        logger.severe("Update of service description not currently supported");
    }

    public void serviceDescriptionRemove(ServiceDescription sdesc) {
        if (this.m_registry != null) {
            this.m_registry.unregister(sdesc);
        }
    }
}

