/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.service.Channel;
import org.pi4soa.service.DefaultMessage;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.ServiceInstanceReference;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.container.ContainerConfiguration;
import org.pi4soa.service.container.MessageDispatcher;
import org.pi4soa.service.container.MessageHandler;
import org.pi4soa.service.container.ServiceContainer;
import org.pi4soa.service.container.impl.MutableServiceRegistryUpdater;
import org.pi4soa.service.container.impl.ServiceEndpointImpl;
import org.pi4soa.service.registry.MutableServiceRegistry;
import org.pi4soa.service.session.internal.DefaultSessionConfiguration;
import org.pi4soa.service.session.internal.SessionMessageHandler;
import org.pi4soa.service.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContainerImpl
implements ServiceContainer {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container.impl");
    private ServiceEndpointImpl m_serviceEndpoint = null;
    private ContainerConfiguration m_configuration = null;
    private Hashtable m_clientMessageProviders = new Hashtable();
    private Hashtable m_serverMessageProviders = new Hashtable();
    private MutableServiceRegistryUpdater m_serviceRepositoryUpdater = null;
    private ContainerMessageHandler m_containerMessageHandler = new ContainerMessageHandler();
    private static final String CONTAINER_RESOURCE = "container";
    private static final String SOURCE_PROVIDER = "sourceProvider";
    private static final String TARGET_PROVIDER = "targetProvider";

    public ServiceContainerImpl(ContainerConfiguration config) throws ServiceException {
        this.m_configuration = config;
        this.initializeServiceEndpoint(config);
        this.initializeMessageProviders(config);
    }

    protected DefaultSessionConfiguration getSessionConfiguration(ContainerConfiguration config) {
        DefaultSessionConfiguration ret = new DefaultSessionConfiguration();
        ret.setMessageHandler(this.m_containerMessageHandler);
        ret.setServiceRegistry(config.getServiceRegistry());
        ret.setServiceTracker(config.getServiceTracker());
        ret.setTimeoutManager(config.getTimeoutManager());
        ret.setSessionManager(config.getSessionManager());
        ret.setIdentityManager(config.getIdentityManager());
        ret.setServiceRepository(config.getServiceRepository());
        ret.setXPathEvaluator(config.getXPathEvaluator());
        ret.setExtensionResolver(config.getExtensionResolver());
        ret.setMonitoring(false);
        ret.setEndpointReferences(config.getEndpointReferences());
        return ret;
    }

    protected void initializeServiceEndpoint(ContainerConfiguration config) throws ServiceException {
        if (this.m_configuration.getServiceRegistry() != null) {
            DefaultSessionConfiguration sessionConfig = this.getSessionConfiguration(config);
            this.m_serviceEndpoint = new ServiceEndpointImpl(sessionConfig);
            if (this.m_configuration.getServiceRepository() != null && this.getMutableServiceRegistry() != null) {
                this.m_serviceRepositoryUpdater = new MutableServiceRegistryUpdater(this.getMutableServiceRegistry(), config.getEndpointReferences());
                this.m_configuration.getServiceRepository().addServiceRepositoryListener(this.m_serviceRepositoryUpdater);
                ServiceDescription[] sdescs = this.m_configuration.getServiceRepository().getServiceDescriptions();
                int i = 0;
                while (sdescs != null && i < sdescs.length) {
                    this.m_serviceRepositoryUpdater.serviceDescriptionAdded(sdescs[i], config.getEndpointReferences());
                    ++i;
                }
            }
        }
    }

    protected void initializeMessageProviders(ContainerConfiguration config) throws ServiceException {
        MessageHandler handler;
        int i;
        if (config.getClientMessageHandlers() != null) {
            i = 0;
            while (i < config.getClientMessageHandlers().length) {
                handler = config.getClientMessageHandlers()[i];
                if (handler != null) {
                    this.registerClientMessageHandler(handler);
                }
                ++i;
            }
        }
        if (config.getServerMessageHandlers() != null) {
            i = 0;
            while (i < config.getServerMessageHandlers().length) {
                handler = config.getServerMessageHandlers()[i];
                if (handler != null) {
                    this.registerServerMessageHandler(handler);
                }
                ++i;
            }
        }
    }

    protected MutableServiceRegistry getMutableServiceRegistry() {
        MutableServiceRegistry ret = null;
        if (this.m_configuration.getServiceRegistry() instanceof MutableServiceRegistry) {
            ret = (MutableServiceRegistry)this.m_configuration.getServiceRegistry();
        }
        return ret;
    }

    protected ServiceEndpointImpl getServiceEndpoint() {
        return this.m_serviceEndpoint;
    }

    @Override
    public ContainerConfiguration getConfiguration() {
        return this.m_configuration;
    }

    protected Class loadClass(String clsName) {
        Class<?> ret = null;
        try {
            ret = Class.forName(clsName);
        }
        catch (Exception exception) {
            logger.severe("Failed to load class '" + clsName + "'");
        }
        return ret;
    }

    @Override
    public void registerClientMessageHandler(MessageHandler provider) throws ServiceException {
        logger.info("Register client message handler: " + provider);
        if (this.m_clientMessageProviders.containsKey(provider.getName())) {
            throw new ServiceException("Client message handler already registered for name '" + provider.getName() + "'");
        }
        this.m_clientMessageProviders.put(provider.getName(), provider);
        provider.setMessageDispatcher(new ContainerMessageDispatcher(provider));
        provider.initialize();
    }

    @Override
    public void registerServerMessageHandler(MessageHandler provider) throws ServiceException {
        logger.info("Register server message handler: " + provider);
        if (this.m_serverMessageProviders.containsKey(provider.getName())) {
            throw new ServiceException("Server message handler already registered for name '" + provider.getName() + "'");
        }
        this.m_serverMessageProviders.put(provider.getName(), provider);
        provider.setMessageDispatcher(new ContainerMessageDispatcher(provider));
        provider.initialize();
    }

    @Override
    public void unregisterClientMessageHandler(MessageHandler provider) throws ServiceException {
        logger.info("Unregister client message handler: " + provider);
        this.m_clientMessageProviders.remove(provider.getName());
        provider.setMessageDispatcher(null);
        provider.close();
    }

    @Override
    public void unregisterServerMessageHandler(MessageHandler provider) throws ServiceException {
        logger.info("Unregister server message handler: " + provider);
        this.m_serverMessageProviders.remove(provider.getName());
        provider.setMessageDispatcher(null);
        provider.close();
    }

    protected MessageHandler resolveClientMessageHandler(EndpointReference ref) throws ServiceException {
        MessageHandler ret = null;
        if (this.m_clientMessageProviders.size() == 0) {
            logger.severe(ServiceContainerImpl.getMessage("_NO_CLIENT_MESSAGE_PROVIDER", null));
            throw new ServiceException(ServiceContainerImpl.getMessage("_NO_CLIENT_MESSAGE_PROVIDER", null));
        }
        Enumeration iter = this.m_clientMessageProviders.elements();
        while (ret == null && iter.hasMoreElements()) {
            ret = (MessageHandler)iter.nextElement();
            if (ret.supportsEndpointReference(ref)) continue;
            ret = null;
        }
        return ret;
    }

    public void newServiceInstance(String serviceName, Map vars) throws ServiceException {
        this.newServiceInstance(serviceName, (String)null, vars, (Identity)null);
    }

    public void newServiceInstance(String serviceName, String participant, Map vars) throws ServiceException {
        this.newServiceInstance(serviceName, participant, vars, (Identity)null);
    }

    public void newServiceInstance(String serviceName, Map vars, Identity sessionIdentity) throws ServiceException {
        this.newServiceInstance(serviceName, (String)null, vars, sessionIdentity);
    }

    public void newServiceInstance(String serviceName, String participant, Map vars, Identity sessionIdentity) throws ServiceException {
        logger.info("New service instance: " + serviceName + " sessionIdentity=" + sessionIdentity);
        if (this.getServiceEndpoint() == null) {
            throw new ServiceException(ServiceContainerImpl.getMessage("_SERVICE_ENDPOINT_NOT_INITIALIZED", null));
        }
        this.getServiceEndpoint().newSession(serviceName, participant, vars, sessionIdentity);
    }

    @Override
    public boolean reEvaluate(String serviceName, List<Identity> identities) throws ServiceException {
        return this.m_serviceEndpoint.reEvaluate(serviceName, identities);
    }

    @Override
    public boolean reEvaluate(ServiceInstanceReference reference) throws ServiceException {
        return this.m_serviceEndpoint.reEvaluate(reference);
    }

    protected static String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)CONTAINER_RESOURCE, (String)key, (Object[])params);
    }

    @Override
    public void close() throws ServiceException {
        MessageHandler mh;
        logger.info("Closing service container '" + this + "'");
        if (this.m_serviceEndpoint != null) {
            this.m_serviceEndpoint.close();
        }
        Enumeration iter = this.m_clientMessageProviders.elements();
        while (iter.hasMoreElements()) {
            mh = (MessageHandler)iter.nextElement();
            this.unregisterClientMessageHandler(mh);
        }
        iter = this.m_serverMessageProviders.elements();
        while (iter.hasMoreElements()) {
            mh = (MessageHandler)iter.nextElement();
            this.unregisterServerMessageHandler(mh);
        }
    }

    public class ContainerMessageDispatcher
    implements MessageDispatcher {
        private MessageHandler m_provider = null;

        public ContainerMessageDispatcher(MessageHandler provider) {
            this.m_provider = provider;
        }

        public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            return this.createRequest(opName, faultName, null, serviceType, serviceEndpoint, value, null, null);
        }

        public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            return this.createRequest(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        }

        public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            return this.createRequest(opName, faultName, type, serviceType, serviceEndpoint, value, null, null);
        }

        public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (ServiceContainerImpl.this.getServiceEndpoint() != null) {
                ret = ServiceContainerImpl.this.getServiceEndpoint().createRequest(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            return this.createResponse(opName, faultName, null, serviceType, serviceEndpoint, value, null, null);
        }

        public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            return this.createResponse(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        }

        public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value) {
            return this.createResponse(opName, faultName, type, serviceType, serviceEndpoint, value, null, null);
        }

        public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
            Message ret = null;
            if (ServiceContainerImpl.this.getServiceEndpoint() != null) {
                ret = ServiceContainerImpl.this.getServiceEndpoint().createResponse(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
            }
            return ret;
        }

        public boolean dispatch(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
            boolean ret = false;
            if (ServiceContainerImpl.this.getServiceEndpoint() == null) {
                throw new ServiceException(ServiceContainerImpl.getMessage("_SERVICE_ENDPOINT_NOT_INITIALIZED", null));
            }
            message.setProperty(ServiceContainerImpl.SOURCE_PROVIDER, (Serializable)((Object)this.m_provider.getName()));
            ret = ServiceContainerImpl.this.getServiceEndpoint().handleMessage(message);
            return ret;
        }

        public ServiceTracker getServiceTracker() {
            ServiceTracker ret = null;
            if (ServiceContainerImpl.this.m_configuration != null) {
                ret = ServiceContainerImpl.this.m_configuration.getServiceTracker();
            }
            return ret;
        }
    }

    public class ContainerMessageHandler
    implements SessionMessageHandler {
        public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionIdentity, Identity channelIdentity) {
            DefaultMessage ret = new DefaultMessage(opName, faultName, type, true, serviceType, serviceEndpoint, value, sessionIdentity, channelIdentity);
            return ret;
        }

        public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionIdentity, Identity channelIdentity) {
            DefaultMessage ret = new DefaultMessage(opName, faultName, type, false, serviceType, serviceEndpoint, value, sessionIdentity, channelIdentity);
            return ret;
        }

        public void dispatch(Channel channel, Message message, OperationDefinition opdef) throws ServiceException {
            if (message.isRequest()) {
                MessageHandler mp = null;
                String mpName = (String)((Object)channel.getProperty(ServiceContainerImpl.TARGET_PROVIDER));
                if (mpName == null) {
                    mp = ServiceContainerImpl.this.resolveClientMessageHandler(channel.getServiceReference());
                    if (mp != null) {
                        channel.setProperty(ServiceContainerImpl.TARGET_PROVIDER, (Serializable)((Object)mp.getName()));
                    }
                } else {
                    mp = (MessageHandler)ServiceContainerImpl.this.m_clientMessageProviders.get(mpName);
                }
                mp.process(message, channel, opdef);
            } else {
                String mpName = null;
                mpName = channel == null ? (String)((Object)message.getProperty(ServiceContainerImpl.SOURCE_PROVIDER)) : (String)((Object)channel.getProperty(ServiceContainerImpl.SOURCE_PROVIDER));
                MessageHandler mp = null;
                if (mpName != null) {
                    mp = (MessageHandler)ServiceContainerImpl.this.m_serverMessageProviders.get(mpName);
                }
                if (mp == null) {
                    logger.severe(ServiceContainerImpl.getMessage("_UNKNOWN_SOURCE_MESSAGE_PROVIDER", new String[]{mpName}));
                    throw new ServiceException(ServiceContainerImpl.getMessage("_UNKNOWN_SOURCE_MESSAGE_PROVIDER", new String[]{mpName}));
                }
                mp.process(message, channel, opdef);
            }
        }

        public void acknowledge(Channel channel, Message message) throws ServiceException {
            if (message.isRequest()) {
                channel.setProperty(ServiceContainerImpl.SOURCE_PROVIDER, message.getProperty(ServiceContainerImpl.SOURCE_PROVIDER));
            }
            String mpName = (String)((Object)message.getProperty(ServiceContainerImpl.SOURCE_PROVIDER));
            MessageHandler mp = null;
            if (mpName != null) {
                mp = message.isRequest() ? (MessageHandler)ServiceContainerImpl.this.m_serverMessageProviders.get(mpName) : (MessageHandler)ServiceContainerImpl.this.m_clientMessageProviders.get(mpName);
            }
            if (mp == null) {
                logger.severe(ServiceContainerImpl.getMessage("_UNKNOWN_SOURCE_MESSAGE_PROVIDER", new String[]{mpName}));
                throw new ServiceException(ServiceContainerImpl.getMessage("_UNKNOWN_SOURCE_MESSAGE_PROVIDER", new String[]{mpName}));
            }
            mp.acknowledge(message, channel);
        }
    }
}

