/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.container.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.ServiceInstanceReference;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.ExtensionResolverFactory;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.impl.MessageImpl;
import org.pi4soa.service.session.impl.SessionProcessor;
import org.pi4soa.service.session.internal.DefaultServiceInstanceReference;
import org.pi4soa.service.session.internal.DefaultSessionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.ServiceInstantiationEvent;
import org.pi4soa.service.session.internal.SessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointImpl
extends SessionProcessor {
    private ExtensionResolver m_extensionResolver = null;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.container.impl");
    private static final String CONTAINER_RESOURCE = "container";

    public ServiceEndpointImpl(SessionConfiguration config) throws ServiceException {
        super(config);
        this.m_extensionResolver = config.getExtensionResolver();
        if (this.m_extensionResolver == null) {
            logger.severe("Extension resolver not available, so using default implementation");
            this.m_extensionResolver = ExtensionResolverFactory.getExtensionResolver();
            this.getConfiguration().setExtensionResolver(this.m_extensionResolver);
        }
    }

    public synchronized void newSession(String serviceName, String participant, Map vars, Identity sessionIdentity) throws ServiceException {
        ServiceDescription sdesc = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("New session: service=" + serviceName + " participant=" + participant);
        }
        if ((sdesc = this.getConfiguration().getServiceRepository().getServiceDescription(serviceName, null)) == null) {
            throw new ServiceException("Service description '" + serviceName + "' not found in service repository");
        }
        if (!sdesc.canBeInitiated()) {
            throw new ServiceException(ServiceEndpointImpl.getMessage("_SERVICE_DESCRIPTION_CANNOT_BE_INITIATED", new Object[]{sdesc.getName()}));
        }
        if (!this.getConfiguration().getServiceRepository().contains(sdesc)) {
            throw new ServiceException(ServiceEndpointImpl.getMessage("_SERVICE_DESCRIPTION_NOT_REGISTERED", new Object[]{sdesc.getName()}));
        }
        InternalSession session = null;
        Session sess = null;
        if (sessionIdentity != null) {
            Vector<Identity> ids = new Vector<Identity>();
            ids.add(sessionIdentity);
            sess = this.findSession(sdesc, ids);
        }
        if (sess == null) {
            sess = this.createSession(sdesc, sessionIdentity, null);
        }
        if (sess instanceof InternalSession) {
            session = (InternalSession)sess;
            this.getConfiguration().getSessionManager().processingStarted(session);
        } else {
            logger.severe("Session returned from SessionManager.processingStarted was not an InternalSession: " + sess);
        }
        try {
            session.process(new ServiceInstantiationEvent(participant, vars));
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingCompleted(session);
            }
        }
        catch (OutOfSequenceMessageException oose) {
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingFailed(session);
            }
            logger.severe("Out of sequence message exception should not be generated when creating a new session");
            throw new ServiceException("Failed to initialize new session due to 'out of sequence message': " + oose, oose);
        }
        catch (ServiceException se) {
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingFailed(session);
            }
            throw se;
        }
        if (session.isCompleted()) {
            this.removeSession(session);
        }
    }

    public boolean handleMessage(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        MessageImpl mesg = ServiceEndpointImpl.getMessageImpl(message);
        if (mesg == null) {
            throw new ServiceException(ServiceEndpointImpl.getMessage("_INVALID_MESSAGE", null));
        }
        this.process(mesg);
        return mesg.isResponseExpected();
    }

    public boolean reEvaluate(String serviceName, List<Identity> identities) throws ServiceException {
        ServiceDescription sdesc = null;
        sdesc = this.getConfiguration().getServiceRepository().getServiceDescription(serviceName, null);
        if (sdesc == null) {
            throw new ServiceException("Service description '" + serviceName + "' not found in service repository");
        }
        return this.reEvaluateSession(sdesc, identities, null);
    }

    public boolean reEvaluate(ServiceInstanceReference reference) throws ServiceException {
        boolean ret = false;
        if (!(reference instanceof DefaultServiceInstanceReference)) {
            throw new ServiceException("Invalid service instance reference");
        }
        DefaultSessionEvent evt = new DefaultSessionEvent(((DefaultServiceInstanceReference)reference).getSessionId());
        Set<Identity> ids = ((DefaultServiceInstanceReference)reference).getIdentities();
        ServiceDescription sdesc = ((DefaultServiceInstanceReference)reference).getServiceDescription();
        ret = this.reEvaluateSession(sdesc, ids, evt);
        return ret;
    }

    protected boolean reEvaluateSession(ServiceDescription sdesc, Collection<Identity> identities, ServiceEvent event) throws ServiceException {
        boolean ret = false;
        Session session = this.getConfiguration().getSessionManager().getSession(sdesc, identities);
        if (session != null) {
            ret = true;
            try {
                this.processEvent(event, session, sdesc);
            }
            catch (OutOfSequenceMessageException outOfSequenceMessageException) {
                logger.warning("OutOfSequenceMessageException occurred when re-evaluating the session");
            }
        }
        return ret;
    }

    protected static String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)CONTAINER_RESOURCE, (String)key, (Object[])params);
    }

    @Override
    public void close() throws ServiceException {
        super.close();
    }
}

