/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.correlator.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.Message;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.correlator.impl.CorrelationNotifier;
import org.pi4soa.service.correlator.impl.CorrelationSessionImpl;
import org.pi4soa.service.correlator.impl.CorrelationSessionManager;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.tracker.ServiceTracker;

public class CorrelatingServiceTracker
implements ServiceTracker {
    private static final String UNEXPECTED_MESSAGE_EXCEPTION = "UnexpectedMessageException";
    private static final String UNHANDLED_EXCEPTION = "Unhandled exception: ";
    private static final String CORRELATER_REPORTED = "[Correlater reported] ";
    private static Logger logger = Logger.getLogger("org.pi4soa.service.correlator.impl");
    private CorrelationSessionManager m_sessionManager = null;
    private CorrelationNotifier m_notifier = null;

    public CorrelatingServiceTracker(CorrelationSessionManager mgr, CorrelationNotifier notifier) {
        this.m_sessionManager = mgr;
        this.m_notifier = notifier;
    }

    public void initialize() {
    }

    public void serviceStarted(ServiceDescription service, Session session) {
    }

    public void serviceFinished(ServiceDescription service, Session session) {
    }

    public void subSessionStarted(Session parent, Session session) {
    }

    public void subSessionFinished(Session parent, Session session) {
    }

    public void sentMessage(Send activity, Session session, Channel channel, Message mesg) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, mesg);
        if (corrSession != null) {
            CDLType cdlType = CDLTypeUtil.getCDLType((CDLType)corrSession.getChoreographyDescription(), (String)activity.getGlobalDescriptionURI());
            if (cdlType == null) {
                logger.severe("Failed to locate CDL type associated with behavior activity '" + activity + "' in choreography '" + corrSession.getChoreographyDescription() + "'");
            } else if (cdlType instanceof ExchangeDetails) {
                corrSession.exchangeInitiated((ExchangeDetails)cdlType, channel);
                this.m_notifier.exchangeInitiated((ExchangeDetails)cdlType, channel, mesg, corrSession, session.getId().getServiceDescriptionName());
            } else {
                logger.severe("CDL type '" + cdlType + "', associated with behavior activity '" + activity + "' is not an ExchangeDetails type");
            }
        }
    }

    public void sentMessage(MessageDefinition defn, Message mesg) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(null, mesg);
        if (corrSession != null) {
            this.m_notifier.exchangeInitiated(null, null, mesg, corrSession, defn.getServiceDescription().getName());
        }
    }

    public void receivedMessage(Receive activity, Session session, Channel channel, Message mesg) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, mesg);
        if (corrSession != null) {
            CDLType cdlType = CDLTypeUtil.getCDLType((CDLType)corrSession.getChoreographyDescription(), (String)activity.getGlobalDescriptionURI());
            if (cdlType == null) {
                logger.severe("Failed to locate CDL type associated with behavior activity '" + activity + "' in choreography '" + corrSession.getChoreographyDescription() + "'");
            } else if (cdlType instanceof ExchangeDetails) {
                corrSession.exchangeCompleted((ExchangeDetails)cdlType, channel);
                this.m_notifier.exchangeCompleted((ExchangeDetails)cdlType, channel, mesg, corrSession, session.getId().getServiceDescriptionName());
            } else {
                logger.severe("CDL type '" + cdlType + "', associated with behavior activity '" + activity + "' is not an ExchangeDetails type");
            }
        }
    }

    public void receivedMessage(MessageDefinition defn, Message mesg) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(null, mesg);
        if (corrSession != null) {
            this.m_notifier.exchangeCompleted(null, null, mesg, corrSession, defn.getServiceDescription().getName());
        }
    }

    public void unexpectedMessage(Session session, Message mesg, String reason) {
    }

    public void unexpectedMessage(ServiceDescription sdesc, Session session, Message mesg, String reason) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, null);
        if (corrSession != null) {
            this.m_notifier.error(CORRELATER_REPORTED + mesg, UNEXPECTED_MESSAGE_EXCEPTION, corrSession, session.getId().getServiceDescriptionName());
        }
    }

    public void unhandledException(Session session, String excType) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, null);
        if (corrSession != null) {
            this.m_notifier.error("[Correlater reported] Unhandled exception: " + excType, excType, corrSession, session.getId().getServiceDescriptionName());
        }
    }

    public void information(Session session, String details) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, null);
        if (corrSession != null) {
            this.m_notifier.information(CORRELATER_REPORTED + details, corrSession, session.getId().getServiceDescriptionName());
        }
    }

    public void warning(Session session, String details, Throwable exc) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, null);
        if (corrSession != null) {
            this.m_notifier.warning(CORRELATER_REPORTED + details, exc.toString(), corrSession, session.getId().getServiceDescriptionName());
        }
    }

    public void error(Session session, String details, Throwable exc) {
        CorrelationSessionImpl corrSession = this.getCorrelationSession(session, null);
        if (corrSession != null) {
            this.m_notifier.error(CORRELATER_REPORTED + details, exc.toString(), corrSession, session.getId().getServiceDescriptionName());
        }
    }

    public void close() {
    }

    protected Session getTopLevelSession(Session subsession) {
        Session ret = subsession;
        while (ret instanceof InternalSession && ((InternalSession)ret).getParent() != null) {
            ret = ((InternalSession)ret).getParent();
        }
        return ret;
    }

    protected CorrelationSessionImpl getCorrelationSession(Session session, Message mesg) {
        CorrelationSessionImpl ret = null;
        if (session != null) {
            Session topLevelSession = this.getTopLevelSession(session);
            if (topLevelSession != null) {
                ret = this.m_sessionManager.getCorrelationSessionImpl(topLevelSession, mesg);
            } else {
                logger.warning("Failed to find top level session for '" + session + "'");
            }
            if (ret == null) {
                logger.severe("Failed to locate correlation session for service session '" + topLevelSession + "'");
            }
        } else if (mesg != null) {
            ret = this.m_sessionManager.getCorrelationSessionImpl(mesg.getMessageIdentities());
            if (ret == null) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (mesg.getMessageIdentities() != null && i < mesg.getMessageIdentities().size()) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(mesg.getMessageIdentities().get(i).getId());
                    ++i;
                }
                logger.severe("Failed to locate correlation session for stateless service with identities '" + buf.toString() + "'");
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found correlation session '" + ret + "' for stateless service");
            }
        }
        return ret;
    }
}

