/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.correlator.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Package;
import org.pi4soa.service.Channel;
import org.pi4soa.service.Identity;
import org.pi4soa.service.correlator.CorrelationSession;
import org.pi4soa.service.session.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSessionImpl
implements CorrelationSession {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.correlator.impl");
    private Package m_choreographyDescription = null;
    private Vector m_serviceSessions = new Vector();
    private Vector m_initiated = new Vector();
    private Vector m_completed = new Vector();
    private List<Identity> m_pastIdentities = new Vector<Identity>();

    public CorrelationSessionImpl(Package cdl) {
        this.m_choreographyDescription = cdl;
    }

    @Override
    public Package getChoreographyDescription() {
        return this.m_choreographyDescription;
    }

    public void associateServiceSession(Session session) {
        logger.fine("Associate service session '" + session + "'");
        this.m_serviceSessions.add(session);
    }

    public void disassociateServiceSession(Session session) {
        logger.fine("Disassociate service session name '" + session + "'");
        this.m_serviceSessions.remove(session);
        Set<Identity> ids = session.getPrimaryIdentities();
        for (Identity cur : ids) {
            if (this.m_pastIdentities.contains(cur)) continue;
            logger.info("Correlation session '" + this + "' - adding identity to past list: " + cur);
            this.m_pastIdentities.add(cur);
        }
    }

    public void disassociateServiceSession(String serviceName) {
        logger.fine("Disassociate service session name '" + serviceName + "'");
        int i = this.m_serviceSessions.size() - 1;
        while (i >= 0) {
            Session session = (Session)this.m_serviceSessions.get(i);
            if (session.getId().getServiceDescriptionName().equals(serviceName)) {
                this.disassociateServiceSession(session);
            }
            --i;
        }
    }

    public int getNumberOfServiceSessions() {
        return this.m_serviceSessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeInitiated(ExchangeDetails exchange, Channel channel) {
        Vector vector = this.m_initiated;
        synchronized (vector) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Exchange initiated=" + exchange + " on channel=" + channel);
            }
            this.m_initiated.add(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeCompleted(ExchangeDetails exchange, Channel channel) {
        Vector vector = this.m_initiated;
        synchronized (vector) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Exchange completed=" + exchange + " on channel=" + channel);
            }
            if (this.m_initiated.contains(exchange)) {
                this.m_completed.add(exchange);
                this.m_initiated.remove(exchange);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("NOTE: Completed exchange=" + exchange + " has not been initiated");
            }
        }
    }

    @Override
    public List<Identity> getIdentities() {
        Vector<Identity> ret = new Vector<Identity>();
        int i = 0;
        while (i < this.m_pastIdentities.size()) {
            Identity pastId = this.m_pastIdentities.get(i);
            if (!ret.contains(pastId)) {
                ret.add(pastId);
            }
            ++i;
        }
        i = 0;
        while (i < this.m_serviceSessions.size()) {
            Session session = (Session)this.m_serviceSessions.get(i);
            Set<Identity> ids = session.getPrimaryIdentities();
            for (Identity cur : ids) {
                if (ret.contains(cur)) continue;
                ret.add(cur);
            }
            if (session.getSessionIdentity() != null && !ret.contains(session.getSessionIdentity())) {
                ret.add(session.getSessionIdentity());
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isIdentifiedBy(Collection<Identity> ids) {
        boolean ret = false;
        if (ids != null) {
            Iterator<Identity> iter = ids.iterator();
            while (!ret && iter.hasNext()) {
                Identity cur = iter.next();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Is identified by=" + cur);
                }
                int i = 0;
                while (!ret && i < this.m_serviceSessions.size()) {
                    Session session = (Session)this.m_serviceSessions.get(i);
                    ret = session.isIdentifiedBy(cur);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Checked id=" + cur + " against session=" + session + " = " + ret);
                    }
                    ++i;
                }
                i = 0;
                while (!ret && i < this.m_pastIdentities.size()) {
                    Identity pastId = this.m_pastIdentities.get(i);
                    ret = pastId.equals(cur);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Checked against past id=" + pastId + " = " + ret);
                    }
                    ++i;
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Is correlation session (" + this + ") identified by " + ids + " = " + ret);
        }
        return ret;
    }
}

