/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.correlator.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.Package;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.correlator.impl.CorrelationNotifier;
import org.pi4soa.service.correlator.impl.CorrelationSessionImpl;
import org.pi4soa.service.session.DefaultSessionManager;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSessionManager
extends DefaultSessionManager {
    private Vector m_correlationSessions = new Vector();
    private Hashtable m_serviceChoreographies = new Hashtable();
    private Vector m_pendingIdentification = new Vector();
    private Vector m_pendingCloseSessions = new Vector();
    private CorrelationNotifier m_notifier = null;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.correlator.impl");

    public CorrelationSessionManager(CorrelationNotifier notifier) {
        this.m_notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(Session session) throws SessionManagerException {
        super.addSession(session);
        Vector vector = this.m_correlationSessions;
        synchronized (vector) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding session '" + session + "' to pending identification list");
            }
            this.m_pendingIdentification.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorrelationSessionImpl getCorrelationSessionImpl(Session session, Message mesg) {
        CorrelationSessionImpl corrSess = null;
        Vector vector = this.m_correlationSessions;
        synchronized (vector) {
            boolean pendingStarted = false;
            Set<Identity> primIds = session.getPrimaryIdentities();
            corrSess = this.getCorrelationSessionImpl(primIds);
            if (corrSess == null && mesg != null) {
                corrSess = this.getCorrelationSessionImpl(mesg.getMessageIdentities());
            }
            if (corrSess == null) {
                if (primIds == null || primIds.size() == 0) {
                    logger.severe("Correlation session is going to be created with no primary ids available");
                } else {
                    String str = "Primary ids: ";
                    Iterator<Identity> iter = primIds.iterator();
                    while (iter.hasNext()) {
                        str = String.valueOf(str) + iter.next().getId();
                    }
                    logger.info(str);
                }
                Package cdlpack = this.getChoreographyForService(session.getId().getServiceDescriptionName());
                if (cdlpack == null) {
                    logger.severe("Unable to find choreography for service '" + session.getId().getServiceDescriptionName());
                } else {
                    corrSess = new CorrelationSessionImpl(cdlpack);
                    this.m_correlationSessions.add(corrSess);
                    pendingStarted = true;
                    logger.info("New correlation session=" + corrSess);
                }
            } else if (corrSess.getNumberOfServiceSessions() == 0 && this.m_pendingCloseSessions.remove(corrSess)) {
                logger.fine("Removed correlation session from pending close list: " + corrSess);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Check if session '" + session + "' is pending identification: " + this.m_pendingIdentification.contains(session));
            }
            if (corrSess != null && this.m_pendingIdentification.contains(session)) {
                corrSess.associateServiceSession(session);
                logger.info("Associating service session '" + session + "' with correlation session '" + corrSess + "'");
                this.m_pendingIdentification.remove(session);
            }
            if (pendingStarted) {
                this.m_notifier.sessionStarted(corrSess);
            }
        }
        return corrSess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(Session session) throws SessionManagerException {
        Vector vector = this.m_correlationSessions;
        synchronized (vector) {
            CorrelationSessionImpl corrSess = this.getCorrelationSessionImpl(session.getPrimaryIdentities());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Remove session '" + session + "': correlation session=" + corrSess);
            }
            if (corrSess != null) {
                corrSess.disassociateServiceSession(session);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Removing session '" + session + "' from pending identification list");
                }
                this.m_pendingIdentification.remove(session);
                if (corrSess.getNumberOfServiceSessions() == 0) {
                    this.pendingClose(corrSess);
                }
            }
        }
        super.removeSession(session);
    }

    public void pendingClose(CorrelationSessionImpl cs) {
        logger.info("Moving correlation session to pending close list: " + cs);
        this.m_pendingCloseSessions.add(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorrelationSessionImpl getCorrelationSessionImpl(Collection<Identity> ids) {
        CorrelationSessionImpl ret = null;
        Vector vector = this.m_correlationSessions;
        synchronized (vector) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Number of sessions=" + this.m_correlationSessions.size());
            }
            Vector<CorrelationSessionImpl> sessions = new Vector<CorrelationSessionImpl>();
            int i = 0;
            while (i < this.m_correlationSessions.size()) {
                CorrelationSessionImpl cs = (CorrelationSessionImpl)this.m_correlationSessions.get(i);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Checking correlation session=" + cs);
                }
                if (cs.isIdentifiedBy(ids)) {
                    sessions.add(cs);
                }
                ++i;
            }
            if (sessions.size() > 1) {
                logger.severe("MULTIPLE CORRELATION SESSIONS DETECTED - currently not handled");
            } else if (sessions.size() == 1) {
                ret = (CorrelationSessionImpl)sessions.get(0);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Returning correlation session=" + ret);
        }
        return ret;
    }

    public List getCorrelationSessions() {
        return this.m_correlationSessions;
    }

    public void registerServiceChoreography(String serviceName, Package cdlpack) {
        this.m_serviceChoreographies.put(serviceName, cdlpack);
    }

    public void unregisterServiceChoreography(String serviceName, Package cdlpack) {
        this.m_serviceChoreographies.remove(serviceName);
    }

    public Package getChoreographyForService(String serviceName) {
        return (Package)this.m_serviceChoreographies.get(serviceName);
    }
}

