/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.correlator.impl;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.service.Identity;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.projection.BehaviorProjection;
import org.pi4soa.service.correlator.CorrelationSession;
import org.pi4soa.service.correlator.ServiceCorrelator;
import org.pi4soa.service.correlator.ServiceCorrelatorListener;
import org.pi4soa.service.correlator.impl.CorrelatingServiceTracker;
import org.pi4soa.service.correlator.impl.CorrelationNotifier;
import org.pi4soa.service.correlator.impl.CorrelationSessionImpl;
import org.pi4soa.service.correlator.impl.CorrelationSessionManager;
import org.pi4soa.service.monitor.DefaultMonitorConfiguration;
import org.pi4soa.service.monitor.ServiceMonitor;
import org.pi4soa.service.monitor.ServiceMonitorFactory;
import org.pi4soa.service.tracker.TrackerEvent;
import org.pi4soa.service.tracker.TrackerRecord;
import org.pi4soa.service.util.ServiceDescriptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCorrelatorImpl
implements ServiceCorrelator {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.correlator.impl");
    private Hashtable m_choreographyDescriptions = new Hashtable();
    private Hashtable m_serviceMonitors = new Hashtable();
    private CorrelatingServiceTracker m_correlatingServiceTracker = null;
    private CorrelationSessionManager m_sessionManager = null;
    private CorrelationNotifier m_notifier = null;

    public ServiceCorrelatorImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.m_notifier = new CorrelationNotifier();
        this.m_sessionManager = new CorrelationSessionManager(this.m_notifier);
        this.m_correlatingServiceTracker = new CorrelatingServiceTracker(this.m_sessionManager, this.m_notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Package cdl) throws ServiceException {
        Hashtable hashtable = this.m_choreographyDescriptions;
        synchronized (hashtable) {
            if (this.m_choreographyDescriptions.containsKey(cdl)) {
                throw new ServiceException("Choreography description already registered");
            }
            Vector<ServiceDescription> sds = new Vector<ServiceDescription>();
            EList participants = cdl.getTypeDefinitions().getParticipantTypes();
            for (ParticipantType partType : participants) {
                ServiceDescription sd = BehaviorProjection.projectServiceDescription(cdl, partType, null);
                DefaultMonitorConfiguration config = new DefaultMonitorConfiguration();
                config.setServiceTracker(this.m_correlatingServiceTracker);
                config.setSessionManager(this.m_sessionManager);
                ServiceMonitor serviceMonitor = ServiceMonitorFactory.getServiceMonitor(config);
                serviceMonitor.getConfiguration().getServiceRepository().addServiceDescription(sd);
                logger.info("Registering service monitor for '" + sd.getFullyQualifiedName() + "'");
                this.m_serviceMonitors.put(sd.getFullyQualifiedName(), serviceMonitor);
                sds.add(sd);
                this.m_sessionManager.registerServiceChoreography(sd.getFullyQualifiedName(), cdl);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ServiceDescriptionManager.save(sd, baos);
                    logger.info(baos.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.m_choreographyDescriptions.put(cdl, sds);
        }
        this.m_notifier.choreographyDescriptionRegistered(cdl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Package cdl) throws ServiceException {
        boolean unregistered = false;
        Hashtable hashtable = this.m_choreographyDescriptions;
        synchronized (hashtable) {
            if (this.m_choreographyDescriptions.containsKey(cdl)) {
                Vector sds = (Vector)this.m_choreographyDescriptions.get(cdl);
                int i = 0;
                while (i < sds.size()) {
                    ServiceDescription sd = (ServiceDescription)sds.get(i);
                    ServiceMonitor serviceMonitor = (ServiceMonitor)this.m_serviceMonitors.get(sd.getFullyQualifiedName());
                    serviceMonitor.getConfiguration().getServiceRepository().removeServiceDescription(sd);
                    this.m_serviceMonitors.remove(sd.getFullyQualifiedName());
                    this.m_sessionManager.unregisterServiceChoreography(sd.getFullyQualifiedName(), cdl);
                    ++i;
                }
                this.m_choreographyDescriptions.remove(cdl);
                unregistered = true;
            }
        }
        if (unregistered) {
            this.m_notifier.choreographyDescriptionRegistered(cdl);
        }
    }

    @Override
    public Package[] getChoreographyDescriptions() {
        Package[] ret = new Package[this.m_choreographyDescriptions.size()];
        Enumeration iter = this.m_choreographyDescriptions.elements();
        int index = 0;
        while (iter.hasMoreElements()) {
            ret[index++] = (Package)iter.nextElement();
        }
        return ret;
    }

    @Override
    public CorrelationSession[] getCorrelationSessions(Package cdl) {
        Object[] ret = null;
        Vector<CorrelationSession> tmp = new Vector<CorrelationSession>();
        List list = this.m_sessionManager.getCorrelationSessions();
        int i = 0;
        while (i < list.size()) {
            CorrelationSession sess = (CorrelationSession)list.get(i);
            if (sess.getChoreographyDescription() == cdl) {
                tmp.add(sess);
            }
            ++i;
        }
        ret = new CorrelationSession[tmp.size()];
        tmp.copyInto(ret);
        return ret;
    }

    @Override
    public CorrelationSession getCorrelationSession(Package cdl, List<Identity> ids) throws ServiceException {
        CorrelationSession ret = null;
        CorrelationSession[] sessions = this.getCorrelationSessions(cdl);
        int i = 0;
        while (sessions != null && i < sessions.length) {
            if (sessions[i].isIdentifiedBy(ids)) {
                if (ret == null) {
                    ret = sessions[i];
                } else {
                    throw new ServiceException("Multiple correlation sessions with same identity");
                }
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void addServiceCorrelatorListener(ServiceCorrelatorListener l) {
        this.m_notifier.addServiceCorrelatorListener(l);
    }

    @Override
    public void removeServiceCorrelatorListener(ServiceCorrelatorListener l) {
        this.m_notifier.removeServiceCorrelatorListener(l);
    }

    @Override
    public void handleTrackerRecord(TrackerRecord record) {
        if (record != null && record.getTrackerEvents() != null) {
            ServiceMonitor serviceMonitor = null;
            logger.info("Handle correlation record: " + record.toXML());
            if (NamesUtil.isSet((String)record.getServiceDescriptionName())) {
                serviceMonitor = (ServiceMonitor)this.m_serviceMonitors.get(record.getServiceDescriptionName());
                if (serviceMonitor == null) {
                    logger.info("Could not find Service Monitor for '" + record.getServiceDescriptionName() + "'");
                }
            } else {
                logger.info("Tracker record is not associated with a service");
            }
            int i = 0;
            while (serviceMonitor != null && i < record.getTrackerEvents().length) {
                CorrelationSessionImpl cs;
                List<Identity> ids;
                CorrelationSessionImpl cs2;
                List<Identity> ids2;
                TrackerEvent event = record.getTrackerEvents()[i];
                if (event.getEventType() == null) {
                    logger.warning("Tracker event '" + event + "' has no event type");
                } else if (event.getEventType().equals("receivedMessage")) {
                    try {
                        serviceMonitor.messageReceived(event.getMessage());
                    }
                    catch (Exception se) {
                        logger.log(Level.SEVERE, "Failed to handle 'messageReceived' tracker event '" + event.toXML() + "': " + se, se);
                        ids2 = record.getPrimaryIdentities();
                        if ((ids2 == null || ids2.size() == 0) && record.getSessionIdentity() != null) {
                            ids2 = new Vector<Identity>();
                            ids2.add(record.getSessionIdentity());
                        }
                        cs2 = this.m_sessionManager.getCorrelationSessionImpl(ids2);
                        this.m_notifier.error("Correlater detected problem: " + se.getMessage(), event.getException(), cs2, record.getServiceDescriptionName());
                    }
                } else if (event.getEventType().equals("sentMessage")) {
                    try {
                        serviceMonitor.messageSent(event.getMessage());
                    }
                    catch (Exception se) {
                        logger.log(Level.SEVERE, "Failed to handle 'messageSent' tracker event '" + event.toXML() + "': " + se, se);
                        ids2 = record.getPrimaryIdentities();
                        if ((ids2 == null || ids2.size() == 0) && record.getSessionIdentity() != null) {
                            ids2 = new Vector<Identity>();
                            ids2.add(record.getSessionIdentity());
                        }
                        cs2 = this.m_sessionManager.getCorrelationSessionImpl(ids2);
                        this.m_notifier.error("Correlater detected problem: " + se.getMessage(), event.getException(), cs2, record.getServiceDescriptionName());
                    }
                } else if (event.getEventType().equals("unexpectedMessage")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    cs = this.m_sessionManager.getCorrelationSessionImpl(ids);
                    this.m_notifier.unexpectedMessage(event.getMessage(), cs, record.getServiceDescriptionName());
                } else if (event.getEventType().equals("error")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    cs = this.m_sessionManager.getCorrelationSessionImpl(ids);
                    this.m_notifier.error(event.getDetails(), event.getException(), cs, record.getServiceDescriptionName());
                } else if (event.getEventType().equals("warning")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    cs = this.m_sessionManager.getCorrelationSessionImpl(ids);
                    this.m_notifier.warning(event.getDetails(), event.getException(), cs, record.getServiceDescriptionName());
                } else if (event.getEventType().equals("information")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    cs = this.m_sessionManager.getCorrelationSessionImpl(ids);
                    this.m_notifier.information(event.getDetails(), cs, record.getServiceDescriptionName());
                } else if (event.getEventType().equals("unhandledException")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    cs = this.m_sessionManager.getCorrelationSessionImpl(ids);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Report as error: " + event.getDetails() + " with exception " + event.getException());
                    }
                    this.m_notifier.error(event.getDetails(), event.getException(), cs, record.getServiceDescriptionName());
                } else if (event.getEventType().equals("serviceFinished")) {
                    ids = record.getPrimaryIdentities();
                    if ((ids == null || ids.size() == 0) && record.getSessionIdentity() != null) {
                        ids = new Vector<Identity>();
                        ids.add(record.getSessionIdentity());
                    }
                    if ((cs = this.m_sessionManager.getCorrelationSessionImpl(ids)) != null) {
                        cs.disassociateServiceSession(record.getServiceDescriptionName());
                        if (cs.getNumberOfServiceSessions() == 0) {
                            this.m_sessionManager.pendingClose(cs);
                        }
                    }
                } else if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Tracker event type not handled by correlator: " + event.getEventType());
                }
                ++i;
            }
        }
    }

    protected CorrelationSessionManager getCorrelationSessionManager() {
        return this.m_sessionManager;
    }
}

