/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.osgi.framework.BundleContext;
import org.pi4soa.common.eclipse.BundleUtil;
import org.pi4soa.common.model.Model;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.resource.ResourceProperties;
import org.pi4soa.common.resource.eclipse.EclipseResourceProperties;
import org.pi4soa.common.util.EMFUtil;
import org.pi4soa.common.validation.Validator;
import org.pi4soa.service.behavior.BehaviorPackage;
import org.pi4soa.service.behavior.BehaviorType;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.BehaviorPackageImpl;
import org.pi4soa.service.eclipse.ServicePlugin;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.pi4soa.service";
    private static Activator plugin;
    private static Logger logger;
    private static final String SERVICE_PLUGIN_ID = "org.pi4soa.service";

    static {
        logger = Logger.getLogger("org.pi4soa.service.eclipse");
        BundleUtil.registerClasspathEntries((String)"org.pi4soa.service", (boolean)true);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initialize();
    }

    protected void initialize() {
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("behavior");
            ResourceLocator.setResourceBundle((String)"behavior", (ResourceBundle)res);
        }
        catch (Exception exception) {}
        try {
            res = ResourceBundle.getBundle("container");
            ResourceLocator.setResourceBundle((String)"container", (ResourceBundle)res);
        }
        catch (Exception exception) {}
        try {
            res = ResourceBundle.getBundle("endpoint");
            ResourceLocator.setResourceBundle((String)"endpoint", (ResourceBundle)res);
        }
        catch (Exception exception) {}
        try {
            res = ResourceBundle.getBundle("monitor");
            ResourceLocator.setResourceBundle((String)"monitor", (ResourceBundle)res);
        }
        catch (Exception exception) {}
        try {
            res = ResourceBundle.getBundle("session");
            ResourceLocator.setResourceBundle((String)"session", (ResourceBundle)res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IResourceChangeListener rcl = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent evt) {
                try {
                    evt.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            boolean ret = true;
                            IResource res = delta.getResource();
                            if (Activator.this.isChangeRelevant(res, delta)) {
                                Activator.this.validateResource(res);
                            }
                            return ret;
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to process resource change event", e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void validateResource(IResource res) {
        try {
            if (res instanceof IFile) {
                ServiceDescription sd = Activator.getServiceDescription(res);
                SEDLValidation job = new SEDLValidation(sd, res);
                job.setPriority(50);
                job.schedule();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to schedule validation of SEDL model", e);
        }
    }

    public static ServiceDescription getServiceDescription(IResource res) throws IOException, CoreException {
        ServiceDescription ret = null;
        if (res instanceof IFile) {
            InputStream is = ((IFile)res).getContents();
            URI uri = URI.createFileURI((String)((IFile)res).getFullPath().toString());
            BehaviorPackage.eINSTANCE.getServiceDescription();
            BehaviorPackageImpl.init();
            XMIResourceImpl xmi = new XMIResourceImpl();
            xmi.setURI(uri);
            xmi.doLoad(is, xmi.getDefaultLoadOptions());
            EList list = xmi.getContents();
            if (list.get(0) instanceof ServiceDescription) {
                ret = (ServiceDescription)list.get(0);
            }
        }
        return ret;
    }

    protected boolean isChangeRelevant(IResource res, IResourceDelta delta) {
        boolean ret = false;
        if (res != null && res.getFileExtension() != null && res.getFileExtension().equals("sdm") && ((delta.getFlags() & 0x100) != 0 || delta.getKind() == 1)) {
            ret = true;
        }
        return ret;
    }

    public static void logError(String mesg, Throwable t) {
        if (Activator.getDefault() != null) {
            Status status = new Status(4, "org.pi4soa.service", 0, mesg, t);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        logger.severe("LOG ERROR: " + mesg + (t == null ? "" : ": " + t));
    }

    class SEDLValidation
    extends Job {
        private ServiceDescription m_servDesc;
        private IResource m_resource;

        public SEDLValidation(ServiceDescription sd, IResource res) {
            super("SEDLValidation");
            this.m_servDesc = null;
            this.m_resource = null;
            this.m_servDesc = sd;
            this.m_resource = res;
        }

        public IStatus run(IProgressMonitor mon) {
            ModelListener listener = new ModelListener(){

                public synchronized void report(Object src, String mesg, int type) {
                    this.report(src, mesg, type, null);
                }

                public synchronized void report(Object src, String mesg, int type, Properties props) {
                    try {
                        IMarker marker = SEDLValidation.this.m_resource.createMarker("org.eclipse.emf.ecore.diagnostic");
                        marker.setAttribute("message", (Object)mesg);
                        if (type == 2) {
                            marker.setAttribute("severity", 2);
                        } else if (type == 1) {
                            marker.setAttribute("severity", 1);
                        } else if (type == 0) {
                            marker.setAttribute("severity", 0);
                        }
                        if (src instanceof BehaviorType) {
                            String uristring = EMFUtil.getURI((Object)src);
                            marker.setAttribute("uri", (Object)uristring);
                        }
                        if (props != null) {
                            for (String string : props.keySet()) {
                                String value = props.getProperty(string);
                                marker.setAttribute(string, (Object)value);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ServicePlugin.logError("Failed to validate CDL model", e);
                    }
                }
            };
            try {
                this.m_resource.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 2);
                EclipseResourceProperties props = new EclipseResourceProperties(this.m_resource, (IResource)this.m_resource.getProject());
                Validator.validate((Model)this.m_servDesc, (ResourceProperties)props, (ModelListener)listener);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to validate SEDL model", e);
                ServicePlugin.logError("Failed to validate SEDL model", e);
            }
            return Status.OK_STATUS;
        }
    }
}

