/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.extensions;

import java.io.Serializable;
import java.util.Set;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ObservableVariableModificationException;
import org.pi4soa.service.ReadOnlyStateException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.ServiceInstanceReference;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.VariableUnavailableException;
import org.pi4soa.service.extensions.ExtensionContext;
import org.pi4soa.service.session.internal.DefaultServiceInstanceReference;
import org.pi4soa.service.session.internal.InternalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtensionContext
implements ExtensionContext {
    private InternalSession m_session = null;
    private boolean m_readOnly = false;

    public void setSession(InternalSession session) {
        this.m_session = session;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    @Override
    public String getServiceDescriptionName() {
        String ret = null;
        if (this.m_session != null) {
            ret = this.m_session.getId().getServiceDescriptionName();
        }
        return ret;
    }

    @Override
    public String getServiceDescriptionVersion() {
        String ret = null;
        if (this.m_session != null) {
            ret = this.m_session.getId().getServiceDescriptionVersion();
        }
        return ret;
    }

    @Override
    public boolean isVariableAvailable(String name) throws LockedInformationException, ServiceException {
        boolean ret = false;
        try {
            this.getVariable(name);
            ret = true;
        }
        catch (VariableUnavailableException variableUnavailableException) {}
        return ret;
    }

    @Override
    public Serializable getVariable(String name) throws VariableUnavailableException, LockedInformationException, ServiceException {
        Serializable ret = null;
        try {
            ret = this.m_session.getVariable(name);
        }
        catch (UnresolvedConstraintException unresolvedConstraintException) {
            throw new VariableUnavailableException(name);
        }
        return ret;
    }

    @Override
    public void setVariable(String name, Serializable value) throws LockedInformationException, ObservableVariableModificationException, ReadOnlyStateException, ServiceException {
        if (this.m_readOnly) {
            throw new ReadOnlyStateException();
        }
        if (this.m_session.isObservableVariable(name)) {
            throw new ObservableVariableModificationException(name);
        }
        this.m_session.setVariable(name, value);
    }

    @Override
    public Set<String> getVariableNames() throws ServiceException {
        return this.m_session.getVariableNames();
    }

    @Override
    public ServiceInstanceReference getServiceInstanceReference() throws ServiceException {
        DefaultServiceInstanceReference ret = new DefaultServiceInstanceReference(this.m_session.getId(), this.m_session.getServiceDescription(), this.m_session.getPrimaryIdentities());
        return ret;
    }

    @Override
    public void information(String details) {
        if (this.m_session != null && this.m_session.getConfiguration() != null && this.m_session.getConfiguration().getServiceTracker() != null) {
            this.m_session.getConfiguration().getServiceTracker().information(this.m_session, details);
        }
    }

    @Override
    public void warning(String details, Throwable exc) {
        if (this.m_session != null && this.m_session.getConfiguration() != null && this.m_session.getConfiguration().getServiceTracker() != null) {
            this.m_session.getConfiguration().getServiceTracker().warning(this.m_session, details, exc);
        }
    }

    @Override
    public void error(String details, Throwable exc) {
        if (this.m_session != null && this.m_session.getConfiguration() != null && this.m_session.getConfiguration().getServiceTracker() != null) {
            this.m_session.getConfiguration().getServiceTracker().error(this.m_session, details, exc);
        }
    }
}

