/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.extensions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.service.behavior.BehaviorType;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.StructuralType;
import org.pi4soa.service.behavior.Unobservable;
import org.pi4soa.service.behavior.VariableDeclaration;
import org.pi4soa.service.extensions.ActivityExtension;
import org.pi4soa.service.extensions.ChannelCreationExtension;
import org.pi4soa.service.extensions.ExtensionResolver;
import org.pi4soa.service.extensions.PredicateExtension;
import org.pi4soa.service.extensions.ReceiveActivityExtension;
import org.pi4soa.service.extensions.SendActivityExtension;
import org.pi4soa.service.extensions.SilentActivityExtension;
import org.pi4soa.service.extensions.SilentVariableExtension;
import org.pi4soa.service.extensions.SynchronousInvokeExtension;

public class DefaultExtensionResolver
implements ExtensionResolver {
    private static final String[] m_classNameSuffix = new String[]{"Predicate", "Activity", "Send", "Receive", "Variable", "Invoke", "Channel", "ReEvalPredicate"};
    private static final char PACKAGE_SEPARATOR = '.';
    private static Logger logger = Logger.getLogger("org.pi4soa.service.extensions");
    private ClassLoader m_classLoader = null;

    public void setClassLoader(ClassLoader cl) {
        this.m_classLoader = cl;
    }

    public String getServicePackageName(String serviceDescription) {
        String localpart = NameSpaceUtil.getLocalPart((String)serviceDescription);
        String namespace = NameSpaceUtil.getNamespace((String)serviceDescription);
        return String.valueOf(NamesUtil.getJavaPackageFromNameSpace((String)namespace)) + '.' + NamesUtil.getJavaName((String)localpart, (boolean)true);
    }

    public String getExtensionPackageName(String serviceDescription, String behaviorDescription, String behaviorName) {
        String ret = String.valueOf(this.getServicePackageName(serviceDescription)) + '.' + NamesUtil.getJavaName((String)behaviorDescription, (boolean)true);
        return ret;
    }

    public String getExtensionClassName(String serviceDescription, String behaviorDescription, String behaviorName, int extensionType) {
        StringBuffer ret = new StringBuffer();
        boolean capital = true;
        int i = 0;
        while (i < behaviorName.length()) {
            char ch = behaviorName.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                if (Character.isLowerCase(ch) && capital) {
                    ch = Character.toUpperCase(ch);
                }
                ret.append(ch);
                capital = false;
            } else {
                capital = true;
            }
            ++i;
        }
        ret.append(DefaultExtensionResolver.getExtensionSuffix(extensionType));
        return ret.toString();
    }

    public String getExtensionStateClassName(String serviceDescription, String behaviorDescription) {
        String ret = String.valueOf(NamesUtil.getJavaName((String)behaviorDescription, (boolean)false)) + "State";
        return ret;
    }

    public SilentActivityExtension resolveSilentActivityExtension(String serviceDescription, String behaviorDescription, String behaviorName) {
        return (SilentActivityExtension)this.resolveExtension(serviceDescription, behaviorDescription, behaviorName, 1, SilentActivityExtension.class);
    }

    public SilentVariableExtension resolveSilentVariableExtension(String serviceDescription, String behaviorDescription, String variableName) {
        return (SilentVariableExtension)this.resolveExtension(serviceDescription, behaviorDescription, variableName, 4, SilentVariableExtension.class);
    }

    protected ActivityExtension resolveExtension(String serviceDescription, String behaviorDescription, String behaviorName, int extensionType, Class extensionClass) {
        ActivityExtension ret = null;
        String clsName = String.valueOf(this.getExtensionPackageName(serviceDescription, behaviorDescription, behaviorName)) + "." + this.getExtensionClassName(serviceDescription, behaviorDescription, behaviorName, extensionType);
        try {
            Class cls = this.getExtensionClass(clsName);
            if (cls != null) {
                Object obj = cls.newInstance();
                if (extensionClass.isAssignableFrom(obj.getClass())) {
                    ret = (ActivityExtension)obj;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Resolved extension '" + clsName + "' = " + ret);
                    }
                } else {
                    logger.severe("Extension class '" + clsName + "' does not implement appropriate " + "interface '" + extensionClass.getName() + "'");
                }
            } else {
                logger.severe("Extension class '" + clsName + "' could not be found");
            }
        }
        catch (Exception e) {
            logger.severe("Extension class '" + clsName + "' could not be found or instantiated: " + e);
        }
        return ret;
    }

    protected Class getExtensionClass(String clsName) throws ClassNotFoundException {
        if (this.m_classLoader != null) {
            return Class.forName(clsName, true, this.m_classLoader);
        }
        return Class.forName(clsName);
    }

    public SendActivityExtension resolveSendActivityExtension(String serviceDescription, String behaviorDescription, String behaviorName) {
        return (SendActivityExtension)this.resolveExtension(serviceDescription, behaviorDescription, behaviorName, 2, SendActivityExtension.class);
    }

    public ReceiveActivityExtension resolveReceiveActivityExtension(String serviceDescription, String behaviorDescription, String behaviorName) {
        return (ReceiveActivityExtension)this.resolveExtension(serviceDescription, behaviorDescription, behaviorName, 3, ReceiveActivityExtension.class);
    }

    public SynchronousInvokeExtension resolveSynchronousInvokeExtension(String serviceDescription, String serviceType, String operationName) {
        return (SynchronousInvokeExtension)this.resolveExtension(serviceDescription, serviceType, operationName, 5, SynchronousInvokeExtension.class);
    }

    public PredicateExtension resolvePredicateExtension(String serviceDescription, String behaviorDescription, String behaviorName) {
        PredicateExtension ret = null;
        String clsName = String.valueOf(this.getExtensionPackageName(serviceDescription, behaviorDescription, behaviorName)) + "." + this.getExtensionClassName(serviceDescription, behaviorDescription, behaviorName, 0);
        try {
            Class cls = this.getExtensionClass(clsName);
            if (cls != null) {
                Object obj = cls.newInstance();
                if (PredicateExtension.class.isAssignableFrom(obj.getClass())) {
                    ret = (PredicateExtension)obj;
                }
            } else {
                logger.severe("Extension class '" + clsName + "' could not be found");
            }
        }
        catch (Exception e) {
            logger.severe("Extension class '" + clsName + "' could not be found or instantiated: " + e);
        }
        return ret;
    }

    public PredicateExtension resolveReEvaluationPredicateExtension(String serviceDescription, String behaviorDescription, String behaviorName) {
        PredicateExtension ret = null;
        String clsName = String.valueOf(this.getExtensionPackageName(serviceDescription, behaviorDescription, behaviorName)) + "." + this.getExtensionClassName(serviceDescription, behaviorDescription, behaviorName, 7);
        try {
            Class cls = this.getExtensionClass(clsName);
            if (cls != null) {
                Object obj = cls.newInstance();
                if (PredicateExtension.class.isAssignableFrom(obj.getClass())) {
                    ret = (PredicateExtension)obj;
                }
            } else {
                logger.severe("Extension class '" + clsName + "' could not be found");
            }
        }
        catch (Exception e) {
            logger.severe("Extension class '" + clsName + "' could not be found or instantiated: " + e);
        }
        return ret;
    }

    public ChannelCreationExtension resolveChannelCreationExtension(String serviceDescription, String behaviorDescription, String channelName) {
        ChannelCreationExtension ret = null;
        String clsName = String.valueOf(this.getExtensionPackageName(serviceDescription, behaviorDescription, channelName)) + "." + this.getExtensionClassName(serviceDescription, behaviorDescription, channelName, 6);
        try {
            Class cls = this.getExtensionClass(clsName);
            if (cls != null) {
                Object obj = cls.newInstance();
                if (ChannelCreationExtension.class.isAssignableFrom(obj.getClass())) {
                    ret = (ChannelCreationExtension)obj;
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extension class '" + clsName + "' could not be found");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Extension class '" + clsName + "' could not be found");
            }
        }
        catch (Exception e) {
            logger.severe("Extension class '" + clsName + "' could not be found or instantiated: " + e);
        }
        return ret;
    }

    public int[] getExtensionTypes(BehaviorType behaviorType) {
        int[] ret = null;
        if (behaviorType instanceof StructuralType) {
            ret = new int[1];
        } else if (behaviorType instanceof Send) {
            ret = new int[]{2, 6};
        } else if (behaviorType instanceof Receive) {
            ret = new int[]{3};
        } else if (behaviorType instanceof Unobservable) {
            ret = new int[]{1};
        } else if (behaviorType instanceof VariableDeclaration && ((VariableDeclaration)behaviorType).getSilent() == Boolean.TRUE) {
            ret = new int[]{4};
        }
        if (ret == null) {
            ret = new int[]{};
        }
        return ret;
    }

    public static String getExtensionSuffix(int extensionType) {
        return m_classNameSuffix[extensionType];
    }
}

