/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.extensions;

import java.util.logging.Logger;
import org.pi4soa.common.util.PropertyUtil;
import org.pi4soa.service.extensions.DefaultExtensionResolver;
import org.pi4soa.service.extensions.ExtensionResolver;

public class ExtensionResolverFactory {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.extensions");
    public static final String EXTENSION_RESOLVER = "pi4soa.container.extensionResolver.class";
    private static final String DEFAULT_EXTENSION_RESOLVER = DefaultExtensionResolver.class.getName();

    public static ExtensionResolver getExtensionResolver() {
        ExtensionResolver ret = null;
        String clsName = PropertyUtil.getProperty((String)EXTENSION_RESOLVER, (String)System.getProperty(EXTENSION_RESOLVER, DEFAULT_EXTENSION_RESOLVER));
        Class<?> componentClass = null;
        try {
            componentClass = Class.forName(clsName);
        }
        catch (Exception e) {
            logger.severe("Failed to create extension resolver with class '" + clsName + "': " + e);
        }
        if (componentClass != null && ExtensionResolver.class.isAssignableFrom(componentClass)) {
            try {
                ret = (ExtensionResolver)componentClass.newInstance();
            }
            catch (Exception e) {
                logger.severe("Failed to instantiate extension resolver '" + clsName + "': " + e);
            }
        }
        return ret;
    }
}

