/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.monitor.impl;

import java.io.Serializable;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.BehaviorFactory;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.monitor.DefaultMonitorConfiguration;
import org.pi4soa.service.monitor.MonitorConfiguration;
import org.pi4soa.service.monitor.ServiceMonitor;
import org.pi4soa.service.session.impl.MessageImpl;

public class DumbServiceMonitorImpl
implements ServiceMonitor {
    private MonitorConfiguration m_configuration = null;
    private MessageDefinition m_messageDefinition = null;

    public DumbServiceMonitorImpl() throws ServiceException {
        this(new DefaultMonitorConfiguration());
    }

    public DumbServiceMonitorImpl(MonitorConfiguration config) throws ServiceException {
        this.initialize(config);
    }

    protected void initialize(MonitorConfiguration config) {
        this.m_configuration = config;
    }

    public MonitorConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public void messageSent(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        this.getConfiguration().getServiceTracker().sentMessage(this.getMessageDefinition(message), message);
    }

    public void messageReceived(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        this.getConfiguration().getServiceTracker().receivedMessage(this.getMessageDefinition(message), message);
    }

    protected synchronized MessageDefinition getMessageDefinition(Message message) {
        ServiceDescription[] sdescs;
        if (this.m_messageDefinition == null && (sdescs = this.getConfiguration().getServiceRepository().getServiceDescriptions()) != null && sdescs.length == 1) {
            ServiceType stype = BehaviorFactory.eINSTANCE.createServiceType();
            OperationDefinition opdef = BehaviorFactory.eINSTANCE.createOperationDefinition();
            this.m_messageDefinition = BehaviorFactory.eINSTANCE.createMessageDefinition();
            opdef.getMessageDefinitions().add((Object)this.m_messageDefinition);
            stype.getOperationDefinitions().add((Object)opdef);
            sdescs[0].getServiceTypes().add((Object)stype);
        }
        return this.m_messageDefinition;
    }

    public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return this.createRequest(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(opName, faultName, type, true, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return this.createResponse(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(opName, faultName, type, false, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createMessage(String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public void close() throws ServiceException {
    }
}

