/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.monitor.impl;

import java.io.Serializable;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.monitor.DefaultMonitorConfiguration;
import org.pi4soa.service.monitor.MonitorConfiguration;
import org.pi4soa.service.monitor.ServiceMonitor;
import org.pi4soa.service.session.impl.MessageImpl;
import org.pi4soa.service.session.impl.SessionProcessor;
import org.pi4soa.service.session.internal.DefaultSessionConfiguration;

public class ServiceMonitorImpl
implements ServiceMonitor {
    private SessionProcessor m_sessionProcessor = null;
    private MonitorConfiguration m_monitorConfiguration = null;

    public ServiceMonitorImpl() throws ServiceException {
        this(new DefaultMonitorConfiguration());
    }

    public ServiceMonitorImpl(MonitorConfiguration config) throws ServiceException {
        this.initialize(config);
    }

    protected void initialize(MonitorConfiguration config) throws ServiceException {
        DefaultSessionConfiguration sessionConfig = this.getSessionConfiguration(config);
        this.m_monitorConfiguration = config;
        this.m_sessionProcessor = new SessionProcessor(sessionConfig);
    }

    protected DefaultSessionConfiguration getSessionConfiguration(MonitorConfiguration config) {
        DefaultSessionConfiguration ret = new DefaultSessionConfiguration();
        ret.setEvaluateState(config.getEvaluateState());
        ret.setReportUnknownMessages(config.getReportUnknownMessages());
        ret.setShouldVerifyMessageContent(config.getShouldVerifyMessageContent());
        ret.setServiceRepository(config.getServiceRepository());
        ret.setServiceTracker(config.getServiceTracker());
        ret.setTimeoutManager(config.getTimeoutManager());
        ret.setSessionManager(config.getSessionManager());
        ret.setIdentityManager(config.getIdentityManager());
        ret.setXPathEvaluator(config.getXPathEvaluator());
        ret.setMonitoring(true);
        return ret;
    }

    public MonitorConfiguration getConfiguration() {
        return this.m_monitorConfiguration;
    }

    public void messageSent(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        MessageImpl impl = SessionProcessor.getMessageImpl(message);
        if (impl == null) {
            throw new ServiceException(ServiceMonitorImpl.getMessage("_INVALID_MESSAGE", null));
        }
        impl.setOutbound(true);
        this.m_sessionProcessor.process(impl);
    }

    public void messageReceived(Message message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        MessageImpl impl = SessionProcessor.getMessageImpl(message);
        if (impl == null) {
            throw new ServiceException(ServiceMonitorImpl.getMessage("_INVALID_MESSAGE", null));
        }
        impl.setOutbound(false);
        this.m_sessionProcessor.process(impl);
    }

    public Message createRequest(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return this.createRequest(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        Message ret = null;
        if (this.m_sessionProcessor != null) {
            ret = this.m_sessionProcessor.createRequest(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        }
        return ret;
    }

    public Message createResponse(String opName, String faultName, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return this.createResponse(opName, faultName, null, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        Message ret = null;
        if (this.m_sessionProcessor != null) {
            ret = this.m_sessionProcessor.createResponse(opName, faultName, type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        }
        return ret;
    }

    public Message createMessage(String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        Message ret = null;
        if (this.m_sessionProcessor != null) {
            ret = this.m_sessionProcessor.createMessage(type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
        }
        return ret;
    }

    protected static String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)"monitor", (String)key, (Object[])params);
    }

    public void close() throws ServiceException {
        if (this.m_sessionProcessor != null) {
            this.m_sessionProcessor.close();
        }
    }
}

