/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.registry;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.common.xpath.XPathEvaluatorFactory;
import org.pi4soa.service.DefaultEndpointReference;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.WSAEndpointReference;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.registry.MutableServiceRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultMutableServiceRegistry
implements MutableServiceRegistry {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.registry.impl");
    public static final String NAME_ATTR = "name";
    public static final String REGISTRY = "registry";
    public static final String SERVICE_TYPE = "serviceType";
    public static final String URL_ATTR = "url";
    private Properties m_discoveryInformationProperties = new Properties();
    private Hashtable m_discoveryInformationElements = new Hashtable();
    private static final String DISCOVERY_INFORMATION = "pi4soa_service_registry";

    public DefaultMutableServiceRegistry() {
        this.initialize(DISCOVERY_INFORMATION);
    }

    public DefaultMutableServiceRegistry(String filename) {
        this.initialize(filename);
    }

    protected void initialize(String filename) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Initialize registry from filename: " + filename);
        }
        if (filename != null) {
            InputStream is;
            boolean f_found = false;
            try {
                is = this.getInputStream(String.valueOf(filename) + ".properties");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("InputStream: " + is);
                }
                if (is != null) {
                    this.m_discoveryInformationProperties.load(is);
                    f_found = true;
                }
            }
            catch (Exception e) {
                logger.severe("Failed to load discovery information '" + filename + "': " + e);
            }
            try {
                is = this.getInputStream(String.valueOf(filename) + ".xml");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("XML InputStream: " + is);
                }
                if (is != null) {
                    Document doc = XMLUtils.loadDocument((InputStream)is);
                    this.initialize(doc.getDocumentElement());
                    f_found = true;
                }
            }
            catch (Exception e) {
                logger.severe("Failed to load XML discovery information '" + filename + "': " + e);
            }
            if (!f_found) {
                logger.severe("Unable to find discovery information '" + filename + "' (either xml or properties file)");
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Registry initialized");
        }
    }

    public void initialize(Element registry) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Initialize registry from element: " + registry);
        }
        if (registry != null && registry.getNodeName().equals(REGISTRY)) {
            NodeList nl = registry.getChildNodes();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Registry has " + nl.getLength() + " nodes");
            }
            int i = 0;
            while (i < nl.getLength()) {
                Element stype;
                Node n = nl.item(i);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Node: " + n);
                }
                if (n instanceof Element && n.getNodeName().equals(SERVICE_TYPE) && (stype = (Element)n).hasAttribute(NAME_ATTR)) {
                    String name = stype.getAttribute(NAME_ATTR);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Initialize registry element '" + name + "': " + stype);
                    }
                    this.m_discoveryInformationElements.put(name, stype);
                }
                ++i;
            }
        }
    }

    public void initialize() {
    }

    protected InputStream getInputStream(String filename) {
        InputStream ret = null;
        if (this.getClass().getClassLoader() != null && (ret = this.getClass().getClassLoader().getResourceAsStream(filename)) != null && logger.isLoggable(Level.FINE)) {
            logger.fine("Service registry location: " + this.getClass().getClassLoader().getResource(filename));
        }
        if (ret == null && (ret = ClassLoader.getSystemResourceAsStream(filename)) != null && logger.isLoggable(Level.FINE)) {
            logger.fine("Service registry location: " + ClassLoader.getSystemResource(filename));
        }
        return ret;
    }

    public EndpointReference discover(String serviceType, String endpointReferenceType) throws ServiceException {
        return this.discover(serviceType, endpointReferenceType, null);
    }

    public EndpointReference discover(String serviceType, String endpointReferenceType, String query) throws ServiceException {
        EndpointReference ret = null;
        String url = null;
        if (serviceType != null) {
            Element elem = (Element)this.m_discoveryInformationElements.get(serviceType);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Service type element: " + elem);
            }
            if (elem != null) {
                url = this.getServiceEndpointURL(elem, query);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Service type URL: " + url);
            }
            if (url == null) {
                url = this.m_discoveryInformationProperties.getProperty(serviceType);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Service type URL from properties: " + url);
                }
            }
        }
        if (url != null) {
            ret = this.createEndpointReference(url, endpointReferenceType);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Discover for service type '" + serviceType + "', ref type '" + endpointReferenceType + "' and query '" + query + "' is " + ret);
        }
        return ret;
    }

    protected String getServiceEndpointURL(Element elem, String query) {
        String ret = null;
        if (query == null) {
            if (elem.hasAttribute(URL_ATTR)) {
                ret = elem.getAttribute(URL_ATTR);
            }
        } else {
            try {
                XPathEvaluator xpathEval = XPathEvaluatorFactory.getXPathEvaluator();
                Object result = xpathEval.evaluate((Object)elem, query, null);
                ret = xpathEval.asString(result);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Service type URL from query '" + query + "': " + ret);
                }
            }
            catch (Exception e) {
                logger.severe("Failed to evaluate registry query '" + query + "': " + e);
            }
        }
        return ret;
    }

    public EndpointReference createEndpointReference(Object details, String endpointReferenceType) {
        DefaultEndpointReference ret = null;
        if (endpointReferenceType != null && endpointReferenceType.equals(NameSpaceUtil.getFullyQualifiedName((String)"http://www.w3.org/2005/08/addressing", (String)"EndpointReference"))) {
            try {
                ret = new WSAEndpointReference(this.getReferenceString(details));
            }
            catch (ServiceException se) {
                logger.severe("Failed to create WSA endpoint reference: " + se);
            }
        } else {
            ret = new DefaultEndpointReference(this.getReferenceString(details));
        }
        return ret;
    }

    protected String getReferenceString(Object details) {
        String ret = null;
        if (details != null) {
            ret = details.toString();
        }
        return ret;
    }

    public void register(ServiceDescription serviceDescription, EndpointReference endpoint) {
        for (ServiceType stype : serviceDescription.getServiceTypes()) {
            if (stype == null || endpoint == null || !stype.isServiceProvider()) continue;
            this.register(stype.getName(), endpoint);
        }
    }

    public void register(String serviceType, EndpointReference endpoint) {
        if (serviceType != null && endpoint != null) {
            logger.info("Register service type '" + serviceType + "' against endpoint '" + endpoint + "'");
            this.m_discoveryInformationProperties.put(serviceType, endpoint.getEndpointURL());
        }
    }

    public void unregister(ServiceDescription serviceDescription) {
        for (ServiceType stype : serviceDescription.getServiceTypes()) {
            if (stype == null || !stype.isServiceProvider()) continue;
            this.unregister(stype.getName());
        }
    }

    public void unregister(String serviceType) {
        if (serviceType != null) {
            logger.info("Unregister service type '" + serviceType + "'");
            this.m_discoveryInformationProperties.remove(serviceType);
        }
    }

    public void close() {
    }
}

