/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.repository;

import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.repository.ServiceRepositoryListener;

public abstract class AbstractServiceRepository
implements ServiceRepository {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.repository");
    private Vector m_listeners = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceDescription(ServiceDescription sdesc) throws ServiceException {
        ServiceDescription existing = null;
        existing = this.getServiceDescription(sdesc.getFullyQualifiedName(), null);
        if (existing != null) {
            this.removeFromRepository(existing);
        }
        try {
            this.addToRepository(sdesc);
        }
        catch (ServiceException se) {
            logger.severe("Failure when adding service '" + sdesc + "', so reverting service repository: " + se);
            this.rollbackRepository();
            throw se;
        }
        try {
            Vector se = this.m_listeners;
            synchronized (se) {
                for (ServiceRepositoryListener l : this.m_listeners) {
                    if (existing != null) {
                        l.serviceDescriptionUpdated(existing, sdesc);
                        continue;
                    }
                    l.serviceDescriptionAdded(sdesc);
                }
            }
        }
        catch (ServiceException se) {
            logger.severe("Failure when notifying addition of service '" + sdesc + "', so reverting service repository: " + se);
            this.rollbackRepository();
            throw se;
        }
        this.checkPointRepository();
    }

    public ServiceDescription getServiceDescription(String name, String version) {
        ServiceDescription ret = null;
        if (name != null) {
            ServiceDescription[] list = this.getServiceDescriptions();
            int i = 0;
            while (ret == null && list != null && i < list.length) {
                ServiceDescription sd = list[i];
                if (sd.getFullyQualifiedName().equals(name) && (version == null || sd.getVersion() != null && sd.getVersion().equals(version))) {
                    ret = sd;
                }
                ++i;
            }
        }
        return ret;
    }

    protected abstract void addToRepository(ServiceDescription var1) throws ServiceException;

    protected abstract boolean removeFromRepository(ServiceDescription var1);

    protected abstract void checkPointRepository();

    protected abstract void rollbackRepository();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceDescription(ServiceDescription sdesc) throws ServiceException {
        boolean changed = false;
        changed = this.removeFromRepository(sdesc);
        if (changed) {
            this.checkPointRepository();
            Vector vector = this.m_listeners;
            synchronized (vector) {
                for (ServiceRepositoryListener l : this.m_listeners) {
                    l.serviceDescriptionRemove(sdesc);
                }
            }
        }
    }

    public abstract ServiceDescription[] getServiceDescriptions();

    public ServiceDescription[] getServiceDescriptions(String serviceType) {
        Object[] ret = this.getServiceDescriptions();
        if (serviceType != null && serviceType.trim().length() != 0 && ret != null) {
            Vector<ServiceDescription> slist = new Vector<ServiceDescription>();
            int i = 0;
            while (i < ret.length) {
                ServiceDescription sd = ret[i];
                if (sd.isServiceTypeRelevant(serviceType)) {
                    slist.add(sd);
                }
                ++i;
            }
            ret = new ServiceDescription[slist.size()];
            slist.copyInto(ret);
            logger.info("Get service description for service type '" + serviceType + "' returned " + ret.length + " service descriptions");
        }
        return ret;
    }

    public boolean contains(ServiceDescription sdesc) {
        boolean ret = false;
        ServiceDescription[] list = this.getServiceDescriptions();
        int i = 0;
        while (!ret && list != null && i < list.length) {
            ServiceDescription sd = list[i];
            if (sd.getFullyQualifiedName().equals(sdesc.getFullyQualifiedName())) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceRepositoryListener(ServiceRepositoryListener l) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            this.m_listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceRepositoryListener(ServiceRepositoryListener l) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            this.m_listeners.remove(l);
        }
    }
}

