/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Identity;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionManager;
import org.pi4soa.service.session.SessionManagerException;
import org.pi4soa.service.session.SessionManagerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionManager
implements SessionManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session");
    private List<Session> m_pendingAddition = new Vector<Session>();
    private List<Session> m_pendingRemoval = new Vector<Session>();
    private List<SessionManagerListener> m_listeners = new Vector<SessionManagerListener>();
    private boolean m_checkMultipleSessionsForIdentity = true;
    private ServiceRepository m_serviceRepository = null;

    @Override
    public void initialize(ServiceRepository rep) {
        this.m_serviceRepository = rep;
    }

    public ServiceRepository getServiceRepository() {
        return this.m_serviceRepository;
    }

    public void setCheckMultipleSessionsForIdentity(boolean val) {
        this.m_checkMultipleSessionsForIdentity = val;
    }

    public boolean getCheckMultipleSessionsForIdentity() {
        return this.m_checkMultipleSessionsForIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(Session session) throws SessionManagerException {
        List<Object> list;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Add new session: " + session);
        }
        if (session.getSessionIdentity() == null && (session.getPrimaryIdentities() == null || session.getPrimaryIdentities().size() == 0)) {
            list = this.m_pendingAddition;
            synchronized (list) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Add new session to pending addition list");
                }
                this.m_pendingAddition.add(session);
            }
        } else {
            this.storeNewSession(session);
        }
        list = this.m_listeners;
        synchronized (list) {
            for (SessionManagerListener l : this.m_listeners) {
                l.sessionStarted(session);
            }
        }
    }

    protected abstract void storeNewSession(Session var1) throws SessionManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(Session session) throws SessionManagerException {
        List<Object> list;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Remove session: " + session);
        }
        if (this.m_pendingAddition.contains(session)) {
            list = this.m_pendingRemoval;
            synchronized (list) {
                this.m_pendingRemoval.add(session);
            }
            list = this.m_pendingAddition;
            synchronized (list) {
                this.m_pendingAddition.remove(session);
            }
        }
        this.deleteSession(session);
        list = this.m_listeners;
        synchronized (list) {
            for (SessionManagerListener l : this.m_listeners) {
                l.sessionCompleted(session);
            }
        }
    }

    protected abstract void deleteSession(Session var1) throws SessionManagerException;

    @Override
    public Session getSession(ServiceDescription sdesc, Collection<Identity> identities) throws SessionManagerException {
        Iterator<Identity> iter;
        String ids;
        Session ret = null;
        if (logger.isLoggable(Level.FINE)) {
            ids = "";
            if (identities != null) {
                iter = identities.iterator();
                while (iter.hasNext()) {
                    if (ids.length() > 0) {
                        ids = String.valueOf(ids) + ", ";
                    }
                    ids = String.valueOf(ids) + iter.next();
                }
            }
            String descName = "<unspecified>";
            if (sdesc != null) {
                descName = sdesc.getFullyQualifiedName();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Get session for '" + descName + "' and identities '" + ids + "'");
            }
        }
        ret = this.retrieveSession(sdesc, identities);
        if (logger.isLoggable(Level.FINEST)) {
            ids = "";
            if (identities != null) {
                iter = identities.iterator();
                while (iter.hasNext()) {
                    if (ids.length() > 0) {
                        ids = String.valueOf(ids) + ", ";
                    }
                    ids = String.valueOf(ids) + iter.next();
                }
            }
            logger.finest("Get session for " + sdesc + " " + ids + " = " + ret + " pending list=" + this.m_pendingAddition.size());
        }
        return ret;
    }

    protected abstract Session retrieveSession(ServiceDescription var1, Collection<Identity> var2) throws SessionManagerException;

    protected boolean isServiceDescriptionSession(String sdesc, Session sess) {
        boolean ret = false;
        if (sdesc == null) {
            logger.finer("No service description, so returning true");
            ret = true;
        } else if (sess != null) {
            logger.finer("Comparing service description name '" + sdesc + "' against name stored in session id '" + sess.getId().getServiceDescriptionName() + "'");
            if (sess.getId().getServiceDescriptionName() != null && sdesc != null && sess.getId().getServiceDescriptionName().equals(sdesc)) {
                ret = true;
            }
        }
        logger.finer("Returning " + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processingStarted(Session session) throws SessionManagerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Start processing session: " + session);
        }
        List<SessionManagerListener> list = this.m_listeners;
        synchronized (list) {
            for (SessionManagerListener l : this.m_listeners) {
                l.sessionProcessingStarted(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processingCompleted(Session session) throws SessionManagerException {
        boolean pendingAddition = false;
        boolean pendingRemoval = false;
        List<Object> list = this.m_pendingAddition;
        synchronized (list) {
            pendingAddition = this.m_pendingAddition.contains(session);
        }
        list = this.m_pendingRemoval;
        synchronized (list) {
            pendingRemoval = this.m_pendingRemoval.contains(session);
        }
        if (pendingAddition) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Move new session from pending addition list: " + session);
            }
            list = this.m_pendingAddition;
            synchronized (list) {
                this.m_pendingAddition.remove(session);
            }
            this.storeNewSession(session);
        } else if (pendingRemoval) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Session already removed (due to only processing single event): " + session);
            }
            list = this.m_pendingRemoval;
            synchronized (list) {
                this.m_pendingRemoval.remove(session);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Persist session after processing event: " + session);
            }
            this.updateSession(session);
        }
        this.commitSession(session);
        list = this.m_listeners;
        synchronized (list) {
            for (SessionManagerListener l : this.m_listeners) {
                l.sessionProcessingCompleted(session);
            }
        }
    }

    protected abstract void updateSession(Session var1) throws SessionManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processingFailed(Session session) throws SessionManagerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Processing failed for session: " + session);
        }
        this.rollbackSession(session);
        List<SessionManagerListener> list = this.m_listeners;
        synchronized (list) {
            for (SessionManagerListener l : this.m_listeners) {
                l.sessionProcessingFailed(session);
            }
        }
    }

    protected abstract void commitSession(Session var1) throws SessionManagerException;

    protected abstract void rollbackSession(Session var1) throws SessionManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSessionManagerListener(SessionManagerListener l) {
        List<SessionManagerListener> list = this.m_listeners;
        synchronized (list) {
            if (!this.m_listeners.contains(l)) {
                this.m_listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionManagerListener(SessionManagerListener l) {
        List<SessionManagerListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(l);
        }
    }

    @Override
    public void close() throws SessionManagerException {
    }
}

