/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.SerializationUtil;
import org.pi4soa.service.Identity;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.session.AbstractSessionManager;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractSessionManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session");
    private List<Object> m_sessions = new Vector<Object>();
    private boolean m_serialize = false;

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeNewSession(Session session) throws SessionManagerException {
        List<Object> list = this.m_sessions;
        synchronized (list) {
            Object toStore = session;
            if (this.m_serialize) {
                toStore = SerializationUtil.encode((Object)session);
            }
            this.m_sessions.add(toStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteSession(Session session) throws SessionManagerException {
        List<Object> list = this.m_sessions;
        synchronized (list) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Delete session: " + session);
            }
            boolean f_end = false;
            int i = 0;
            while (!f_end && i < this.m_sessions.size()) {
                Object obj = this.m_sessions.get(i);
                Session sess = null;
                sess = obj instanceof byte[] ? (Session)SerializationUtil.decode((byte[])((byte[])obj)) : (Session)obj;
                if (sess.getId().equals(session.getId())) {
                    this.m_sessions.remove(i);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Delete entry: " + i);
                    }
                    f_end = true;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Session retrieveSession(ServiceDescription sdesc, Collection<Identity> identities) throws SessionManagerException {
        Session ret = null;
        boolean f_end = false;
        List<Object> list = this.m_sessions;
        synchronized (list) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Get session key - checking " + this.m_sessions.size() + " sessions");
            }
            int i = 0;
            while (!f_end && i < this.m_sessions.size()) {
                Object obj = this.m_sessions.get(i);
                Session sess = null;
                boolean suitable = false;
                sess = obj instanceof byte[] ? (Session)SerializationUtil.decode((byte[])((byte[])obj)) : (Session)obj;
                if (this.isServiceDescriptionSession(sdesc.getFullyQualifiedName(), sess)) {
                    Iterator<Identity> iter = identities.iterator();
                    while (!suitable && iter.hasNext()) {
                        suitable = sess.isIdentifiedBy(iter.next());
                    }
                }
                if (suitable) {
                    if (ret == null) {
                        ret = sess;
                        if (!this.getCheckMultipleSessionsForIdentity()) {
                            f_end = true;
                        }
                    } else {
                        String desc = "unspecified";
                        String identity = "";
                        Iterator<Identity> iter = identities.iterator();
                        while (iter.hasNext()) {
                            if (identity.length() > 0) {
                                identity = String.valueOf(identity) + ",";
                            }
                            identity = String.valueOf(identity) + iter.next().getId();
                        }
                        desc = sdesc.getFullyQualifiedName();
                        throw new SessionManagerException(ResourceLocator.getMessage((String)"session", (String)"_MULTIPLE_SESSIONS_FOR_IDENTITY", (Object[])new Object[]{desc, identity}));
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSession(Session session) throws SessionManagerException {
        if (this.isSerialize()) {
            this.deleteSession(session);
            byte[] b = SerializationUtil.encode((Object)session);
            List<Object> list = this.m_sessions;
            synchronized (list) {
                this.m_sessions.add(b);
            }
        }
    }

    @Override
    protected void commitSession(Session session) throws SessionManagerException {
    }

    @Override
    protected void rollbackSession(Session session) throws SessionManagerException {
    }

    @Override
    public void close() throws SessionManagerException {
    }

    public void setSerialize(String serialize) {
        logger.info("Setting default session serialization: " + serialize);
        this.m_serialize = serialize != null && serialize.equalsIgnoreCase("true");
    }

    protected boolean isSerialize() {
        return this.m_serialize;
    }

    public int getNumberOfSessions() {
        return this.m_sessions.size();
    }
}

