/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.pi4soa.common.util.SerializationUtil;

public class SessionId
implements Externalizable {
    private static final long serialVersionUID = 7044283280244721048L;
    private static final int SERIALIZATION_VERSION = 1;
    private Long m_internalId;
    private String m_serviceDescription = null;
    private String m_version = null;
    private String m_sessionId = null;
    private String m_serviceInstanceId = null;
    private static final String ID_SEPARATOR = ":";

    public SessionId() {
    }

    public SessionId(SessionId sid) {
        this.m_serviceDescription = sid.m_serviceDescription;
        this.m_version = sid.m_version;
        this.m_sessionId = sid.m_sessionId;
        this.m_serviceInstanceId = sid.m_serviceInstanceId;
    }

    public SessionId(String serviceDescription, String version, String serviceInstanceId) {
        this.m_serviceDescription = serviceDescription;
        this.m_version = version;
        this.m_serviceInstanceId = serviceInstanceId;
        this.m_sessionId = serviceInstanceId;
    }

    public SessionId(SessionId parent, String localId) {
        this.m_serviceDescription = parent.getServiceDescriptionName();
        this.m_version = parent.getServiceDescriptionVersion();
        this.m_serviceInstanceId = parent.getServiceInstanceId();
        this.m_sessionId = String.valueOf(parent.getSessionId()) + ID_SEPARATOR + localId;
    }

    public Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    public SessionId createSubSessionId(String localId) {
        return new SessionId(this, localId);
    }

    public SessionId createSubSessionId(int localId) {
        return new SessionId(this, "" + localId);
    }

    public String getServiceDescriptionName() {
        return this.m_serviceDescription;
    }

    protected void setServiceDescriptionName(String name) {
        this.m_serviceDescription = name;
    }

    public String getServiceDescriptionVersion() {
        return this.m_version;
    }

    protected void setServiceDescriptionVersion(String version) {
        this.m_version = version;
    }

    public String getServiceInstanceId() {
        return this.m_serviceInstanceId;
    }

    protected void setServiceInstanceId(String instanceId) {
        this.m_serviceInstanceId = instanceId;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    protected void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public boolean isChildSession(SessionId id) {
        boolean ret = false;
        if (id.getSessionId().length() > this.m_sessionId.length() && id.getSessionId().startsWith(this.m_sessionId)) {
            ret = true;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        SessionId other;
        boolean ret = false;
        if (obj instanceof SessionId && (other = (SessionId)obj).getServiceInstanceId().equals(this.getServiceInstanceId()) && other.getSessionId().equals(this.getSessionId()) && other.getServiceDescriptionName().equals(this.getServiceDescriptionName())) {
            ret = true;
        }
        return ret;
    }

    public int hashCode() {
        return this.getSessionId().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getServiceDescriptionName()) + "/" + this.getSessionId();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_serviceDescription));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_version));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_sessionId));
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_serviceInstanceId));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_serviceDescription = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_version = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_sessionId = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_serviceInstanceId = SerializationUtil.decodeUTF((String)in.readUTF());
        }
    }
}

