/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.hibernate;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.pi4soa.service.DefaultChannel;
import org.pi4soa.service.Identity;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.session.AbstractSessionManager;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.session.SessionManagerException;
import org.pi4soa.service.session.hibernate.HibernateUtil;
import org.pi4soa.service.session.impl.DescriptionReference;
import org.pi4soa.service.session.impl.PrimaryIdentity;
import org.pi4soa.service.session.impl.Schedule;
import org.pi4soa.service.session.impl.ServiceDescriptionSessionImpl;
import org.pi4soa.service.session.impl.SessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionManager
extends AbstractSessionManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.hibernate");

    @Override
    public void initialize(ServiceRepository rep) {
        super.initialize(rep);
    }

    @Override
    protected void storeNewSession(Session session) throws SessionManagerException {
        try {
            org.hibernate.classic.Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            if (!hibernate.getTransaction().isActive()) {
                hibernate.beginTransaction();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Begin txn: " + hibernate.getTransaction());
                }
            }
            hibernate.save((Object)session);
            if (logger.isLoggable(Level.FINEST) && session instanceof ServiceDescriptionSessionImpl) {
                ServiceDescriptionSessionImpl sess = (ServiceDescriptionSessionImpl)session;
                Iterator<PrimaryIdentity> iter = sess.getPrimaryIds().iterator();
                while (iter.hasNext()) {
                    logger.finest("Saved session with pid=" + iter.next());
                }
            }
        }
        catch (HibernateException he) {
            throw new SessionManagerException("Failed to store new session", he);
        }
    }

    @Override
    protected void deleteSession(Session session) throws SessionManagerException {
        try {
            org.hibernate.classic.Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            hibernate.delete((Object)session);
            if (logger.isLoggable(Level.FINEST)) {
                this.dbDiagnostics();
            }
        }
        catch (HibernateException he) {
            throw new SessionManagerException("Failed to delete session", he);
        }
    }

    @Override
    protected Session retrieveSession(ServiceDescription sdesc, Collection<Identity> identities) throws SessionManagerException {
        ServiceDescriptionSessionImpl ret = null;
        try {
            org.hibernate.classic.Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            if (!hibernate.getTransaction().isActive()) {
                hibernate.beginTransaction();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Begin txn: " + hibernate.getTransaction());
                }
            }
            PrimaryIdentity pid = new PrimaryIdentity(null, sdesc.getFullyQualifiedName(), null);
            Iterator<Identity> iter = identities.iterator();
            while (pid.getSession() == null && iter.hasNext()) {
                pid.setId(iter.next().getId());
                try {
                    hibernate.refresh((Object)pid);
                }
                catch (UnresolvableObjectException unresolvableObjectException) {}
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Retrieve session with pid=" + pid);
            }
            if ((ret = pid.getSession()) != null) {
                hibernate.saveOrUpdate((Object)ret);
            }
        }
        catch (HibernateException he) {
            throw new SessionManagerException("Failed to store new session", he);
        }
        return ret;
    }

    @Override
    protected void updateSession(Session session) throws SessionManagerException {
    }

    @Override
    protected void commitSession(Session session) throws SessionManagerException {
        try {
            org.hibernate.classic.Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Commit session: " + session);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(Thread.currentThread() + ": Commit txn: " + hibernate.getTransaction());
            }
            hibernate.flush();
            hibernate.getTransaction().commit();
        }
        catch (HibernateException he) {
            logger.log(Level.SEVERE, "Failed to commit", he);
            throw new SessionManagerException("Failed to store new session", he);
        }
    }

    @Override
    protected void rollbackSession(Session session) throws SessionManagerException {
        try {
            org.hibernate.classic.Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Rollback session: " + session);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(Thread.currentThread() + ": Rollback txn: " + hibernate.getTransaction());
            }
            hibernate.getTransaction().rollback();
        }
        catch (HibernateException he) {
            throw new SessionManagerException("Failed to store new session", he);
        }
    }

    @Override
    public void close() throws SessionManagerException {
        super.close();
    }

    private void dbDiagnostics() {
        logger.finest(Thread.currentThread() + ": ------------------ Session DB Diagnostics Started ---------------------");
        org.hibernate.classic.Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        this.countEntries((org.hibernate.Session)session, PrimaryIdentity.class);
        this.countEntries((org.hibernate.Session)session, DescriptionReference.class);
        this.countEntries((org.hibernate.Session)session, Schedule.class);
        this.countEntries((org.hibernate.Session)session, SessionId.class);
        this.countEntries((org.hibernate.Session)session, Identity.class);
        this.countEntries((org.hibernate.Session)session, DefaultChannel.class);
        this.countEntries((org.hibernate.Session)session, SessionImpl.class);
        logger.finest(Thread.currentThread() + ": ------------------ Session DB Diagnostics Finished ---------------------");
    }

    private void countEntries(org.hibernate.Session session, Class<?> cls) {
        List<?> list = this.getInstances(session, cls);
        logger.finest("Number of entries of type " + cls.getName() + ": " + list.size());
    }

    private List<?> getInstances(org.hibernate.Session session, Class<?> cls) {
        return session.createQuery("from " + cls.getName()).list();
    }
}

