/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Identity;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.VariableMonitoringException;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.SilentVariableExtension;
import org.pi4soa.service.session.impl.SessionImpl;
import org.pi4soa.service.session.internal.InternalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicSessionImpl
extends SessionImpl
implements Externalizable {
    private static final long serialVersionUID = -2304752824651501245L;
    private static final int SERIALIZATION_VERSION = 1;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");

    public AtomicSessionImpl() {
        super(null, null);
    }

    public AtomicSessionImpl(String name, Serializable id, InternalSession parent) throws ServiceException {
        super(name, id, parent);
    }

    @Override
    public synchronized void setVariable(String variable, Serializable value) throws LockedInformationException, ServiceException {
        if (this.getParent().isLocked(variable)) {
            throw new LockedInformationException(variable);
        }
        if (this.getParent().isSilentVariable(variable)) {
            throw new ServiceException("Cannot set a silent variable '" + variable + "'");
        }
        this.getVariables().put(variable, this.internalValue(value));
    }

    @Override
    public Serializable getVariable(String variable) throws UnresolvedConstraintException, VariableMonitoringException, LockedInformationException, ServiceException {
        Serializable ret = null;
        if (this.getParent().isLocked(variable)) {
            throw new LockedInformationException(variable);
        }
        if (this.getParent().isSilentVariable(variable)) {
            if (this.getConfiguration().isMonitoring()) {
                throw new VariableMonitoringException(variable);
            }
            String sdname = this.getServiceDescription().getFullyQualifiedName();
            String bdname = this.getBehaviorDescriptionFullName();
            SilentVariableExtension extension = this.getConfiguration().getExtensionResolver().resolveSilentVariableExtension(sdname, bdname, variable);
            if (extension == null) {
                throw new ExtensionException("Silent variable extension for variable '" + variable + "' could not be found");
            }
            ret = extension.getValue(this.getExtensionContext());
        } else {
            ret = this.getVariables().containsKey(variable) ? this.externalValue(this.getVariables().get(variable)) : this.getParent().getVariable(variable);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Get variable '" + variable + "' is: " + ret);
        }
        if (ret == null) {
            throw new UnresolvedConstraintException(variable);
        }
        return ret;
    }

    @Override
    public Set<String> getVariableNames() throws ServiceException {
        Set<String> ret = this.getParent().getVariableNames();
        if (this.getVariables().size() > 0) {
            HashSet<String> v = new HashSet<String>();
            if (ret != null) {
                v.addAll(ret);
            }
            for (String name : super.getVariableNames()) {
                if (v.contains(name)) continue;
                v.add(name);
            }
            ret = v;
        }
        return ret;
    }

    @Override
    public boolean isObservableVariable(String variable) {
        boolean ret = false;
        if (this.getParent() != null) {
            ret = this.getParent().isObservableVariable(variable);
        }
        return ret;
    }

    @Override
    public void primaryIdentityAdded(InternalSession session, Identity identity, String serviceType, boolean ignoreDuplicates) throws ServiceException {
        if (this.getParent() != null) {
            ((SessionImpl)this.getParent()).primaryIdentityAdded(session, identity, serviceType, ignoreDuplicates);
        }
    }

    @Override
    protected void primaryIdentityRemoved(InternalSession session, Identity key) {
        if (this.getParent() != null) {
            ((SessionImpl)this.getParent()).primaryIdentityRemoved(session, key);
        }
    }

    @Override
    public Set<Identity> getPrimaryIdentities() {
        Set<Identity> ret = null;
        if (this.getParent() != null) {
            ret = ((SessionImpl)this.getParent()).getPrimaryIdentities();
        }
        return ret;
    }

    @Override
    public void sessionFinished() throws ServiceException {
        if (this.getTerminatingException() == null) {
            for (String var : this.getVariableNames()) {
                try {
                    Serializable val = this.getVariable(var);
                    if (this.getParent() == null) continue;
                    this.getParent().setVariable(var, val);
                }
                catch (Exception exception) {
                    logger.severe(SessionImpl.getMessage("_ATOMIC_VARIABLE_UNRESOLVED", new Object[]{var}));
                }
            }
        }
        super.sessionFinished();
    }

    @Override
    public String toString() {
        return "Atomic" + super.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short version = in.readShort();
    }
}

