/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.SerializationUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.VariableMonitoringException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.session.DefaultSessionStatus;
import org.pi4soa.service.session.SessionStatus;
import org.pi4soa.service.session.impl.ServiceDescriptionSessionImpl;
import org.pi4soa.service.session.impl.SessionImpl;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehavioralSessionImpl
extends SessionImpl
implements SessionStatus,
Externalizable {
    private static final long serialVersionUID = -4827075717299694550L;
    private static final int SERIALIZATION_VERSION = 1;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");
    private String m_behaviorDescriptionFullName = null;
    private boolean m_isolated = false;
    private Map<String, String> m_variableBindings = null;
    private transient Predicate[] m_postConditions = null;
    private transient Predicate[] m_exceptionPropagationConditions = null;

    public BehavioralSessionImpl() {
        super(null, null);
    }

    public BehavioralSessionImpl(BehaviorDescription desc, Serializable id, boolean isolated, Map<String, String> bindings, InternalSession parent) throws ServiceException {
        super(desc.getName(), id, parent);
        this.m_behaviorDescriptionFullName = desc.getFullyQualifiedName();
        this.m_isolated = isolated;
        this.m_variableBindings = bindings;
        this.initBindings();
    }

    @Override
    public String getBehaviorDescriptionFullName() {
        return this.m_behaviorDescriptionFullName;
    }

    public void setBehaviorDescriptionFullName(String name) {
        this.m_behaviorDescriptionFullName = name;
    }

    protected void initBindings() throws ServiceException {
        if (this.m_variableBindings != null && this.getParent() != null) {
            for (String variable : this.m_variableBindings.keySet()) {
                String bound = this.m_variableBindings.get(variable);
                if (!this.isIsolated()) continue;
                try {
                    this.setVariable(bound, this.getParent().getVariable(variable));
                }
                catch (UnresolvedConstraintException unresolvedConstraintException) {
                }
                catch (ServiceException se) {
                    logger.severe("Failed to initialize performed behavioral session with bound variables: " + se);
                    throw se;
                }
                ((SessionImpl)this.getParent()).lockVariable(variable);
            }
        }
    }

    @Override
    protected boolean canDisgardOnTermination() {
        return false;
    }

    public boolean isIsolated() {
        return this.m_isolated;
    }

    public void setIsolated(boolean b) {
        this.m_isolated = b;
    }

    public Map<String, String> getVariableBindings() {
        return this.m_variableBindings;
    }

    public void setVariableBindings(Map<String, String> bindings) {
        this.m_variableBindings = bindings;
    }

    @Override
    public Serializable getVariable(String variable) throws UnresolvedConstraintException, VariableMonitoringException, LockedInformationException, ServiceException {
        Serializable ret = null;
        String varName = null;
        if (this.isIsolated() && !this.isSilentVariable(variable)) {
            ret = super.getVariable(variable);
        } else {
            varName = this.getParentNameForBoundVariable(variable);
            if (varName != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": Redirecting get variable '" + variable + "' request to parent session variable '" + varName + "'");
                }
                ret = this.getParent().getVariable(varName);
            } else {
                ret = super.getVariable(variable);
            }
        }
        return ret;
    }

    @Override
    public Set<String> getVariableNames() throws ServiceException {
        Set<String> ret = super.getVariableNames();
        if (this.m_variableBindings.size() > 0) {
            HashSet<String> v = new HashSet<String>();
            if (ret != null) {
                v.addAll(ret);
            }
            Iterator<String> iter = this.m_variableBindings.keySet().iterator();
            while (iter.hasNext()) {
                String name = this.m_variableBindings.get(iter.next());
                if (v.contains(name)) continue;
                v.add(name);
            }
            ret = v;
        }
        return ret;
    }

    @Override
    public synchronized void setVariable(String variable, Serializable value) throws LockedInformationException, ServiceException {
        String varName = null;
        if (this.isSilentVariable(variable)) {
            throw new ServiceException("Cannot set a silent variable '" + variable + "'");
        }
        if (this.isIsolated()) {
            super.setVariable(variable, value);
        } else {
            varName = this.getParentNameForBoundVariable(variable);
            if (varName != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": Redirecting set variable '" + variable + "' request to parent session variable '" + varName + "'");
                }
                this.getParent().setVariable(varName, value);
                this.checkForCompletion(null);
            } else {
                super.setVariable(variable, value);
            }
        }
    }

    protected String getParentNameForBoundVariable(String variable) {
        String ret = null;
        if (this.m_variableBindings != null && this.m_variableBindings.containsValue(variable)) {
            Iterator<String> iter = this.m_variableBindings.keySet().iterator();
            while (ret == null && iter.hasNext()) {
                String key = iter.next();
                String val = this.m_variableBindings.get(key);
                if (!val.equals(variable)) continue;
                ret = key;
            }
        }
        return ret;
    }

    @Override
    public Channel getChannel(String name, String type, String serviceRefType, String serviceType) {
        Channel ret = null;
        String boundVariable = null;
        boundVariable = this.getParentNameForBoundVariable(name);
        if (boundVariable != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": Redirecting get channel '" + name + "' request to parent channel '" + boundVariable + "'");
            }
            ret = this.getParent().getChannel(boundVariable, type, serviceRefType, serviceType);
        } else {
            ret = super.getChannel(name, type, serviceRefType, serviceType);
        }
        return ret;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() instanceof ServiceDescriptionSessionImpl;
    }

    @Override
    public boolean isBehavioralSession() {
        return true;
    }

    @Override
    protected void addSessionToList(String name, List<InternalSession> list) {
        if (this.getBehaviorDescriptionName().equals(name)) {
            list.add(this);
        }
    }

    @Override
    protected void addSessionStatusToList(String name, List<SessionStatus> list) {
        if (this.getBehaviorDescriptionName().equals(name)) {
            list.add(this);
        }
    }

    @Override
    protected void recordCompletedStatus() {
        if (this.getParent() != null) {
            DefaultSessionStatus status = new DefaultSessionStatus(this.getBehaviorDescriptionName(), this.getBehaviorInstanceId(), this.getStatus());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": Adding session status to parent: " + status);
            }
            this.getParentSession().getCompletedSessionStatus().add(status);
        }
    }

    @Override
    public void sessionFinished() throws ServiceException {
        if (this.isIsolated() && this.getParent() != null && this.m_variableBindings != null) {
            for (String parentName : this.m_variableBindings.keySet()) {
                String var = this.m_variableBindings.get(parentName);
                ((SessionImpl)this.getParent()).unlockVariable(parentName);
                try {
                    Serializable val = this.getVariable(var);
                    this.getParent().setVariable(parentName, val);
                }
                catch (UnresolvedConstraintException unresolvedConstraintException) {
                }
                catch (LockedInformationException lockedInformationException) {
                    logger.severe(SessionImpl.getMessage("_BEHAVIORAL_VARIABLE_LOCK", new Object[]{var}));
                }
            }
        }
        super.sessionFinished();
    }

    @Override
    public void sessionTerminated(ExceptionEvent exception) throws ServiceException {
        if (this.isIsolated() && this.getParent() != null) {
            for (String parentName : this.m_variableBindings.keySet()) {
                ((SessionImpl)this.getParent()).unlockVariable(parentName);
            }
        }
        super.sessionTerminated(exception);
    }

    @Override
    public void setPostConditions(Predicate[] predicates) {
        this.m_postConditions = predicates;
    }

    @Override
    public Predicate[] getPostConditions() {
        return this.m_postConditions;
    }

    @Override
    public void setExceptionPropagationConditions(Predicate[] predicates) {
        this.m_exceptionPropagationConditions = predicates;
    }

    @Override
    public Predicate[] getExceptionPropagationConditions() {
        return this.m_exceptionPropagationConditions;
    }

    @Override
    public String toString() {
        return "Behavioral" + super.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(1);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_behaviorDescriptionFullName));
        out.writeBoolean(this.m_isolated);
        out.writeObject(this.m_variableBindings);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short version = in.readShort();
        if (version == 1) {
            this.m_behaviorDescriptionFullName = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_isolated = in.readBoolean();
            this.m_variableBindings = (Map)in.readObject();
        }
    }
}

