/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ResumableBehaviorElement;
import org.pi4soa.service.session.internal.SessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionReference<E extends BehaviorElement>
implements Serializable {
    private static final long serialVersionUID = 7347629213102599795L;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");
    private Long m_internalId;
    private transient E m_description = null;
    private String m_descriptionId = null;
    private ResumableBehaviorElement m_resumableDescription = null;

    public DescriptionReference() {
    }

    public DescriptionReference(E description) {
        this.m_description = description;
        this.m_descriptionId = description.getId();
        if (description instanceof ResumableBehaviorElement) {
            this.m_resumableDescription = (ResumableBehaviorElement)description;
        }
    }

    public Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    public E getDescription() {
        return this.m_description;
    }

    public String getDescriptionId() {
        return this.m_descriptionId;
    }

    public void setDescriptionId(String id) {
        this.m_descriptionId = id;
    }

    public ResumableBehaviorElement getResumableDescription() {
        return this.m_resumableDescription;
    }

    public void setResumableDescription(ResumableBehaviorElement rbe) {
        this.m_resumableDescription = rbe;
    }

    public void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        if (this.m_description != null) {
            throw new ServiceException("Reference already initialized");
        }
        if (this.m_resumableDescription != null) {
            this.m_resumableDescription.resume(sdesc, config);
            this.m_description = this.m_resumableDescription;
        } else if (this.m_descriptionId != null) {
            this.m_description = config.getSessionComponentResolver().getBehaviorElement(sdesc, this.m_descriptionId);
        }
        if (this.m_description != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resumed element '" + this.m_description + "'");
            }
        } else {
            throw new ServiceException("Failed to resume session for '" + sdesc + "': Unable to locate behavioural " + "description for id '" + this.m_descriptionId + "': " + this.m_description);
        }
    }

    public int hashCode() {
        return this.m_descriptionId.hashCode();
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof DescriptionReference && ((DescriptionReference)obj).getDescriptionId().equals(this.getDescriptionId())) {
            ret = true;
        }
        return ret;
    }
}

