/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.pi4soa.service.DefaultMessage;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.session.impl.MessageMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends DefaultMessage
implements Message,
Externalizable {
    private static final long serialVersionUID = -7583253152240305091L;
    private static final int SERIALIZATION_VERSION = 1;
    private boolean m_outbound = false;
    private boolean m_responseExpected = false;

    public MessageImpl() {
    }

    public MessageImpl(String opName, String faultName, boolean isRequest, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        super(opName, faultName, null, isRequest, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public MessageImpl(String opName, String faultName, String type, boolean isRequest, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        super(opName, faultName, type, isRequest, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public MessageImpl(String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        super(type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public MessageImpl(Message mesg) {
        super(mesg.getOperationName(), mesg.getFaultName(), mesg.getType(), mesg.isRequest(), mesg.getServiceType(), mesg.getServiceEndpoint(), mesg.getValue(), mesg.getSessionIdentity(), mesg.getChannelIdentity());
        this.setMessageIdentities(mesg.getMessageIdentities());
        this.setRPCStyle(mesg.isRPCStyle());
        this.setOutbound(mesg.isOutbound());
    }

    public void setOutbound(boolean outbound) {
        this.m_outbound = outbound;
    }

    @Override
    public boolean isOutbound() {
        return this.m_outbound;
    }

    public void clearFaultName() {
        this.setFaultName(null);
    }

    public void setResponseExpected(boolean responseExpected) {
        this.m_responseExpected = responseExpected;
    }

    public boolean isResponseExpected() {
        return this.m_responseExpected;
    }

    public List<Identity> getAllIdentities() {
        Vector<Identity> ret = new Vector<Identity>();
        if (this.getSessionIdentity() != null) {
            ret.add(this.getSessionIdentity());
        }
        if (this.getChannelIdentity() != null) {
            ret.add(this.getChannelIdentity());
        }
        if (this.getMessageIdentities() != null) {
            ret.addAll(this.getMessageIdentities());
        }
        return ret;
    }

    public MessageMemento createMemento() {
        MessageMemento ret = new MessageMemento();
        ret.setBehaviorIdentities(this.getMessageIdentities());
        return ret;
    }

    public void restore(MessageMemento memento) {
        if (memento != null) {
            this.setMessageIdentities(memento.getBehaviorIdentities());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(1);
        out.writeBoolean(this.m_outbound);
        out.writeBoolean(this.m_responseExpected);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short version = in.readShort();
        if (version == 1) {
            this.m_outbound = in.readBoolean();
            this.m_responseExpected = in.readBoolean();
        }
    }
}

