/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.session.impl.DescriptionReference;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.SessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schedule
implements Externalizable {
    private static final long serialVersionUID = -226868962797429525L;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");
    private static final int SERIALIZATION_VERSION = 1;
    private Long m_internalId;
    private List<DescriptionReference<BehaviorElement>> m_pending = new Vector<DescriptionReference<BehaviorElement>>();
    private transient List<DescriptionReference<BehaviorElement>> m_processed = new Vector<DescriptionReference<BehaviorElement>>();
    private boolean m_disgard = false;
    private boolean m_finishProcessing = false;

    public Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    public synchronized void schedule(BehaviorElement behavior) {
        if (logger.isLoggable(Level.FINE)) {
            logger.finer(this + ": Schedule: " + behavior);
        }
        if (!this.m_disgard) {
            this.m_pending.add(new DescriptionReference<BehaviorElement>(behavior));
        } else {
            logger.finer(this + ": Schedule has disgarded " + behavior);
        }
        if (this.alreadyProcessed(behavior)) {
            logger.finer(this + ": Already processed " + behavior + ", so finishing");
            this.setFinishProcessing(true);
        }
    }

    public synchronized void unschedule(BehaviorElement behavior) {
        if (logger.isLoggable(Level.FINE)) {
            logger.finer(this + ": Unschedule: " + behavior);
        }
        if (this.m_pending.remove(new DescriptionReference<BehaviorElement>(behavior))) {
            this.m_processed.add(new DescriptionReference<BehaviorElement>(behavior));
        }
    }

    public synchronized BehaviorElement get(int index) {
        BehaviorElement ret = null;
        if (index < this.size()) {
            ret = this.m_pending.get(index).getDescription();
        }
        return ret;
    }

    public synchronized int size() {
        return this.m_pending.size();
    }

    public synchronized void clear() {
        this.m_pending.clear();
    }

    public void setDisgard(boolean disgard) {
        this.m_disgard = disgard;
    }

    public boolean getDisgard() {
        return this.m_disgard;
    }

    public synchronized void clearProcessedElements() {
        this.m_processed.clear();
        this.setFinishProcessing(false);
    }

    public synchronized boolean alreadyProcessed(BehaviorElement mon) {
        boolean ret = false;
        ret = this.m_processed.contains(new DescriptionReference<BehaviorElement>(mon));
        return ret;
    }

    private void setFinishProcessing(boolean fin) {
        this.m_finishProcessing = fin;
    }

    public boolean getFinishProcessing() {
        return this.m_finishProcessing;
    }

    public void resetFinishProcessing() {
        this.setFinishProcessing(false);
    }

    public synchronized void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        DescriptionReference<BehaviorElement> ref;
        int i = this.m_pending.size() - 1;
        while (i >= 0) {
            ref = this.m_pending.get(i);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resume session for '" + sdesc + "': Locating behavior " + "element for '" + ref + "'");
            }
            if (ref == null) {
                throw new ServiceException("Failed to resume session for '" + sdesc + "': Unable to locate behavior " + "element ref '" + ref + "'");
            }
            ref.resume(sdesc, config);
            --i;
        }
        i = this.m_processed.size() - 1;
        while (i >= 0) {
            ref = this.m_processed.get(i);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resume (processed) session for '" + sdesc + "': Locating behavior " + "element for '" + ref + "'");
            }
            if (ref == null) {
                throw new ServiceException("Failed to resume (processed) session for '" + sdesc + "': Unable to locate behavior " + "element ref '" + ref + "'");
            }
            ref.resume(sdesc, config);
            --i;
        }
    }

    public List<DescriptionReference<BehaviorElement>> getProcessed() {
        return this.m_processed;
    }

    public List<DescriptionReference<BehaviorElement>> getPending() {
        return this.m_pending;
    }

    protected void setPending(List<DescriptionReference<BehaviorElement>> schedule) {
        this.m_pending = schedule;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeBoolean(this.m_disgard);
        out.writeBoolean(this.m_finishProcessing);
        out.writeInt(this.m_pending.size());
        int i = 0;
        while (i < this.m_pending.size()) {
            DescriptionReference<BehaviorElement> be = this.m_pending.get(i);
            out.writeObject(be);
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_disgard = in.readBoolean();
            this.m_finishProcessing = in.readBoolean();
            int num = in.readInt();
            int i = 0;
            while (i < num) {
                this.m_pending.add((DescriptionReference)in.readObject());
                ++i;
            }
        }
    }
}

