/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.BehaviorDescription;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.session.impl.DescriptionReference;
import org.pi4soa.service.session.impl.PrimaryIdentity;
import org.pi4soa.service.session.impl.SessionImpl;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.Predicate;
import org.pi4soa.service.session.internal.ServiceInstantiationEvent;
import org.pi4soa.service.session.internal.SessionConfiguration;
import org.pi4soa.service.session.internal.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionSessionImpl
extends SessionImpl
implements Externalizable {
    private static final long serialVersionUID = 1269579457329622731L;
    private static final int SERIALIZATION_VERSION = 1;
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");
    private transient ServiceDescription m_serviceDescription = null;
    private Set<PrimaryIdentity> m_primaryIds = new HashSet<PrimaryIdentity>();
    private Set<DescriptionReference<BehaviorDescriptionImpl>> m_rootBehaviors = new HashSet<DescriptionReference<BehaviorDescriptionImpl>>();

    public ServiceDescriptionSessionImpl() {
        super(null, null);
    }

    public ServiceDescriptionSessionImpl(ServiceDescription sdesc, String sid, Identity sessionIdentity) {
        super(new SessionId(sdesc.getFullyQualifiedName(), sdesc.getVersion(), sid), sessionIdentity);
        this.m_serviceDescription = sdesc;
        int i = 0;
        while (i < this.m_serviceDescription.getBehaviorDescriptions().size()) {
            BehaviorDescription bd = (BehaviorDescription)this.m_serviceDescription.getBehaviorDescriptions().get(i);
            if (bd.getRoot() == Boolean.TRUE && bd instanceof BehaviorDescriptionImpl && bd instanceof BehaviorElement) {
                this.m_rootBehaviors.add(new DescriptionReference<BehaviorDescriptionImpl>((BehaviorDescriptionImpl)bd));
            }
            ++i;
        }
    }

    @Override
    protected void handleOutOfSequenceMessage(ServiceEvent evt) throws ServiceException, OutOfSequenceMessageException {
        if (evt instanceof Message || evt instanceof ServiceEvent) {
            Map vars = null;
            BehaviorDescriptionImpl bd = null;
            if (evt instanceof Message) {
                Iterator<DescriptionReference<BehaviorDescriptionImpl>> roots = this.m_rootBehaviors.iterator();
                while (bd == null && roots.hasNext()) {
                    bd = roots.next().getDescription();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Checking root behavior description: " + bd);
                    }
                    Iterator iter = bd.getActivationConditions().iterator();
                    boolean f_activatable = false;
                    while (!f_activatable && iter.hasNext()) {
                        Predicate pred = (Predicate)iter.next();
                        try {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Checking predicate: " + pred);
                            }
                            if (!pred.isMessagePredicate() || !this.getConfiguration().isMonitoring() && !pred.isReceiveLookaheadPredicate() || !pred.isSatisfied(this, evt)) continue;
                            f_activatable = true;
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.finest("Activable predicate is: " + pred);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.finest("Predicate not satisfied: " + e);
                        }
                    }
                    if (f_activatable) continue;
                    bd = null;
                }
            } else if (evt instanceof ServiceInstantiationEvent) {
                String participant = ((ServiceInstantiationEvent)evt).getParticipant();
                vars = ((ServiceInstantiationEvent)evt).getVariables();
                bd = (BehaviorDescriptionImpl)this.m_serviceDescription.getInitialBehaviorDescription(participant);
                if (bd == null || !this.m_rootBehaviors.contains(new DescriptionReference<BehaviorDescriptionImpl>(bd))) {
                    bd = null;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Root behavior description already activated: " + bd);
                    }
                    throw new ServiceException("Unable to instantiate service behavior for participant '" + (participant == null ? "default" : participant) + "'");
                }
            }
            if (bd != null) {
                this.m_rootBehaviors.remove(new DescriptionReference<Object>(bd));
                InternalSession subsession = SessionFactory.getBehavioralSession(this, bd, null, false, null);
                if (vars != null) {
                    this.initializeVariables(subsession, vars);
                }
                subsession.schedule(bd);
                subsession.process(evt);
            } else {
                super.handleOutOfSequenceMessage(evt);
            }
        } else {
            super.handleOutOfSequenceMessage(evt);
        }
    }

    public void initializeVariables(InternalSession session, Map vars) throws ServiceException {
        for (Object key : vars.keySet()) {
            if (key instanceof String) {
                String name = (String)key;
                Object value = vars.get(key);
                if (!(value instanceof Serializable)) {
                    throw new ServiceException("Variable '" + key + "' has a non-serializable value");
                }
                try {
                    session.setVariable(name, (Serializable)value);
                }
                catch (Exception e) {
                    logger.severe("Failed to initialize variable '" + name + "': " + e);
                }
                continue;
            }
            logger.warning("Unable to initialize variable with non-string key '" + key + "'");
        }
    }

    @Override
    public void primaryIdentityAdded(InternalSession session, Identity identity, String serviceType, boolean ignoreDuplicates) throws ServiceException {
        super.primaryIdentityAdded(session, identity, serviceType, ignoreDuplicates);
        PrimaryIdentity pi = new PrimaryIdentity(identity.getId(), this.getId().getServiceDescriptionName(), this);
        if (!this.getPrimaryIds().contains(pi)) {
            this.getPrimaryIds().add(pi);
        }
    }

    @Override
    protected void identityDerived(SessionImpl session, Identity identity) throws ServiceException {
        super.identityDerived(session, identity);
        PrimaryIdentity pi = new PrimaryIdentity(identity.getId(), this.getId().getServiceDescriptionName(), this);
        if (!this.getPrimaryIds().contains(pi)) {
            this.getPrimaryIds().add(pi);
        }
    }

    public Set<PrimaryIdentity> getPrimaryIds() {
        return this.m_primaryIds;
    }

    protected void setPrimaryIds(Set<PrimaryIdentity> ids) {
        this.m_primaryIds = ids;
    }

    public Set<DescriptionReference<BehaviorDescriptionImpl>> getRootBehaviors() {
        return this.m_rootBehaviors;
    }

    protected void setRootBehaviors(Set<DescriptionReference<BehaviorDescriptionImpl>> behaviors) {
        this.m_rootBehaviors = behaviors;
    }

    @Override
    public boolean isCompleted() {
        boolean ret = false;
        if (this.getChildSessions().size() == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        if (this.m_serviceDescription != null) {
            throw new ServiceException("Session already initialized");
        }
        this.m_serviceDescription = sdesc;
        for (DescriptionReference<BehaviorDescriptionImpl> ref : this.m_rootBehaviors) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resume session for '" + sdesc + "': Locating behavior " + "description for ref id '" + ref.getDescriptionId() + "'");
            }
            ref.resume(sdesc, config);
        }
        super.resume(sdesc, config);
    }

    @Override
    public ServiceDescription getServiceDescription() throws ServiceException {
        if (this.m_serviceDescription == null) {
            logger.severe("Service description is not initialized");
            throw new ServiceException("Service description is not initialized in top level session");
        }
        return this.m_serviceDescription;
    }

    @Override
    public boolean isTopLevelSession() {
        return true;
    }

    @Override
    public boolean isBehavioralSession() {
        return true;
    }

    @Override
    protected boolean canDisgardOnTermination() {
        return false;
    }

    @Override
    public String toString() {
        return "ServiceDescription" + super.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(1);
        out.writeInt(this.m_rootBehaviors.size());
        Iterator<DescriptionReference<BehaviorDescriptionImpl>> iter = this.m_rootBehaviors.iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short version = in.readShort();
        if (version == 1) {
            int num = in.readInt();
            int i = 0;
            while (i < num) {
                this.m_rootBehaviors.add((DescriptionReference)in.readObject());
                ++i;
            }
        }
    }
}

