/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.SerializationUtil;
import org.pi4soa.service.Channel;
import org.pi4soa.service.DefaultChannel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.EndpointReferenceFactory;
import org.pi4soa.service.Identity;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.VariableMonitoringException;
import org.pi4soa.service.behavior.ActivityType;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.impl.BehaviorDescriptionImpl;
import org.pi4soa.service.extensions.DefaultExtensionContext;
import org.pi4soa.service.extensions.ExtensionContext;
import org.pi4soa.service.extensions.ExtensionException;
import org.pi4soa.service.extensions.SilentVariableExtension;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.session.SessionStatus;
import org.pi4soa.service.session.impl.DescriptionReference;
import org.pi4soa.service.session.impl.Schedule;
import org.pi4soa.service.session.impl.StateChangeEvent;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.Predicate;
import org.pi4soa.service.session.internal.SessionConfiguration;
import org.pi4soa.service.session.internal.SessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements InternalSession,
Externalizable {
    private static final long serialVersionUID = -1785580409547664651L;
    private static final int SERIALIZATION_VERSION = 1;
    private static final String SERVER_CHANNEL_SUFFIX = " [SERVER]";
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");
    private Long m_internalId = 0L;
    private SessionId m_sessionId = null;
    private Identity m_sessionIdentity = null;
    private String m_behaviorDescription = null;
    private Serializable m_behaviorInstanceId = null;
    private SessionImpl m_parent = null;
    private transient SessionImpl m_oldParent = null;
    private transient SessionConfiguration m_configuration = null;
    private int m_status = 1;
    private Schedule m_schedule = new Schedule();
    private transient DefaultExtensionContext m_extensionContext = null;
    private transient DefaultExtensionContext m_readOnlyExtensionContext = null;
    private Map<String, Serializable> m_variables = new Hashtable<String, Serializable>();
    private List<String> m_lockedVariables = new Vector<String>();
    private List<String> m_observableVariables = new Vector<String>();
    private List<String> m_silentVariables = new Vector<String>();
    private transient boolean m_childSessionsChanged = false;
    private Set<SessionImpl> m_activeChildSessions = new HashSet<SessionImpl>();
    private Set<SessionStatus> m_completedSessionStatus = new HashSet<SessionStatus>();
    private List<String> m_pendingTimeouts = new Vector<String>();
    private List<String> m_timeouts = new Vector<String>();
    private Map<String, Channel> m_channels = new Hashtable<String, Channel>();
    private transient InternalSessionListener m_internalSessionListener = null;
    private String m_sessionListenerId = null;
    private boolean m_terminated = false;
    private transient Predicate[] m_completionPredicates = null;
    private boolean m_completed = false;
    private boolean m_earlyCompletion = false;
    private boolean m_awaitingCompletion = false;
    private transient StateChangeEvent m_stateChangeEvent = null;
    private ExceptionEvent m_terminatingException = null;
    private int m_nextChildSessionId = 1;
    private Set<Identity> m_identities = new HashSet<Identity>();
    private transient Map<Identity, List<String>> m_identityMap = new Hashtable<Identity, List<String>>();
    private Set<Identity> m_derivedIdentities = new HashSet<Identity>();
    public static final String NULL = "#null#";

    public SessionImpl() {
        this(new SessionId("Test", "0.0", "Test"), null);
    }

    public SessionImpl(SessionId sid, Identity sessionIdentity) {
        this.m_sessionId = sid;
        this.m_sessionIdentity = sessionIdentity;
    }

    protected SessionImpl(String name, Serializable id, InternalSession parent) throws ServiceException {
        if (parent != null && !(parent instanceof SessionImpl)) {
            throw new ServiceException("Session is not an appropriate implementation");
        }
        this.m_behaviorDescription = name;
        this.m_behaviorInstanceId = id;
        this.m_parent = (SessionImpl)parent;
        if (this.m_parent != null) {
            if (parent.getId() != null) {
                this.m_sessionId = parent.getId().createSubSessionId(this.m_parent.allocateNextChildSessionId());
            }
            this.m_sessionIdentity = parent.getSessionIdentity();
            this.m_configuration = parent.getConfiguration();
            this.m_parent.addChildSession(this);
            if (this.getConfiguration() != null && this.getConfiguration().getServiceTracker() != null) {
                this.getConfiguration().getServiceTracker().subSessionStarted(parent, this);
            }
        }
    }

    @Override
    public void initialize(SessionConfiguration config) throws ServiceException {
        this.m_configuration = config;
        if (config != null && config.getServiceTracker() != null) {
            config.getServiceTracker().serviceStarted(this.getServiceDescription(), this);
        }
        if (this.m_sessionIdentity != null) {
            try {
                this.registerSessionIdentity(this.m_sessionIdentity);
            }
            catch (Exception e) {
                logger.severe("Failed to register session identity: " + e);
            }
        }
    }

    @Override
    public void resume(ServiceDescription sdesc, SessionConfiguration config) throws ServiceException {
        this.m_configuration = config;
        this.m_schedule.resume(sdesc, config);
        if (this.m_sessionListenerId != null) {
            this.setInternalSessionListener(config.getSessionComponentResolver().getInternalSessionListener(sdesc, this.m_sessionListenerId));
        }
        for (SessionImpl sess : this.getChildSessions()) {
            sess.resume(sdesc, config);
        }
    }

    @Override
    public boolean shouldResume() {
        boolean ret = false;
        if (this.getConfiguration() == null) {
            ret = true;
        }
        return ret;
    }

    public Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    @Override
    public SessionId getId() {
        return this.m_sessionId;
    }

    public void setId(SessionId id) {
        this.m_sessionId = id;
    }

    @Override
    public Identity getSessionIdentity() {
        return this.m_sessionIdentity;
    }

    protected void setSessionIdentity(Identity id) {
        this.m_sessionIdentity = id;
    }

    @Override
    public Set<Identity> getPrimaryIdentities() {
        HashSet<Identity> ret = new HashSet<Identity>();
        this.buildListOfPrimaryIdentities(ret);
        return ret;
    }

    @Override
    public void buildListOfPrimaryIdentities(Set<Identity> list) {
        for (Identity id : this.m_identities) {
            if (list.contains(id)) continue;
            list.add(id);
        }
        if (this.getBehavioralSessionParent() != null) {
            this.getBehavioralSessionParent().buildListOfPrimaryIdentities(list);
        }
    }

    public SessionImpl findActiveChildSession(SessionId id) {
        SessionImpl ret = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Session '" + this.getId() + "': Find active child session " + id);
        }
        if (id.equals(this.getId())) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Session '" + this.getId() + "': Returning current session");
            }
            ret = this;
        } else if (this.getId().isChildSession(id)) {
            Iterator<SessionImpl> iter = this.getChildSessions().iterator();
            while (iter.hasNext() && ret == null) {
                ret = iter.next().findActiveChildSession(id);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Session '" + this.getId() + "': Returning active child session: " + ret);
            }
        }
        return ret;
    }

    @Override
    public ServiceDescription getServiceDescription() throws ServiceException {
        ServiceDescription ret = null;
        if (this.getParent() instanceof SessionImpl) {
            ret = ((SessionImpl)this.getParent()).getServiceDescription();
        }
        return ret;
    }

    public String getBehaviorDescriptionName() {
        return this.m_behaviorDescription;
    }

    protected String getBehaviorDescriptionFullName() {
        String ret = null;
        if (this.getParent() instanceof SessionImpl) {
            ret = ((SessionImpl)this.getParent()).getBehaviorDescriptionFullName();
        }
        return ret;
    }

    public Serializable getBehaviorInstanceId() {
        return this.m_behaviorInstanceId;
    }

    public void setBehaviorInstanceId(Serializable bid) {
        this.m_behaviorInstanceId = bid;
    }

    @Override
    public SessionConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public synchronized ExtensionContext getExtensionContext() {
        if (this.m_extensionContext == null) {
            this.m_extensionContext = new DefaultExtensionContext();
            this.m_extensionContext.setSession(this);
        }
        return this.m_extensionContext;
    }

    @Override
    public ExtensionContext getReadOnlyExtensionContext() {
        if (this.m_readOnlyExtensionContext == null) {
            this.m_readOnlyExtensionContext = new DefaultExtensionContext();
            this.m_readOnlyExtensionContext.setSession(this);
            this.m_readOnlyExtensionContext.setReadOnly(true);
        }
        return this.m_readOnlyExtensionContext;
    }

    @Override
    public boolean isIdentifiedBy(Identity id) {
        boolean ret = false;
        if (this.getIdentities().contains(id)) {
            ret = true;
        } else if (this.getDerivedIdentities().contains(id)) {
            ret = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Session '" + this.getId() + "' - identified by '" + id.getId() + "'? " + ret);
        }
        return ret;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public synchronized boolean process(ServiceEvent evt) throws ServiceException, OutOfSequenceMessageException {
        boolean ret = false;
        if (this.getConfiguration() == null) {
            throw new ServiceException(SessionImpl.getMessage("_SESSION_NOT_INITIALIZED", null));
        }
        if (evt instanceof SessionEvent) {
            SessionImpl sess = this.findActiveChildSession(((SessionEvent)evt).getSessionId());
            if (sess != null) {
                sess.processSessionEvent((SessionEvent)evt);
                this.processChanges(null);
            } else {
                logger.fine("Could not find session for event '" + evt + "'");
            }
        } else {
            ret = this.processChanges(evt);
        }
        if (!ret && this.getParent() == null) {
            this.handleOutOfSequenceMessage(evt);
        }
        if (this.shouldComplete()) {
            this.sessionFinished();
            this.getSchedule().setDisgard(false);
        }
        return ret;
    }

    protected void handleOutOfSequenceMessage(ServiceEvent evt) throws ServiceException, OutOfSequenceMessageException {
        if (evt instanceof Message) {
            String text = SessionImpl.getMessage("_OUT_OF_BOUNDS", new Object[]{evt});
            ((Message)evt).processingFailed();
            if (this.getConfiguration().getServiceTracker() != null && !((Message)evt).shouldRetry()) {
                this.getConfiguration().getServiceTracker().unexpectedMessage(this.getServiceDescription(), this, (Message)evt, text);
            }
            throw new OutOfSequenceMessageException(text, (Message)evt);
        }
    }

    protected boolean shouldComplete() {
        boolean ret = false;
        if (this.getSchedule().size() == 0 && (this.m_activeChildSessions.size() == 0 || this.childSessionsAllAwaitingCompletion()) && !this.isPendingTermination()) {
            ret = true;
        }
        return ret;
    }

    protected boolean childSessionsAllAwaitingCompletion() {
        boolean ret = true;
        Iterator<SessionImpl> iter = this.getChildSessions().iterator();
        while (ret && iter.hasNext()) {
            SessionImpl child = iter.next();
            ret = child.shouldAwaitingCompletion();
        }
        return ret;
    }

    protected void processSessionEvent(SessionEvent evt) throws ServiceException, OutOfSequenceMessageException {
        evt.update(this);
        this.processChanges(evt);
        if (this.shouldComplete()) {
            this.sessionFinished();
            this.getSchedule().setDisgard(false);
        }
    }

    public boolean processChanges(ServiceEvent evt) throws ServiceException, OutOfSequenceMessageException {
        DescriptionReference<BehaviorElement> dr;
        boolean ret = false;
        boolean changed = false;
        if (!(evt instanceof SessionEvent) && this.processChildSessions(evt)) {
            ret = true;
            evt = null;
        }
        ActivityType ref = null;
        int i = 0;
        while (ref == null && i < this.getSchedule().size()) {
            if (this.getSchedule().get(i) instanceof ActivityType) {
                ref = (ActivityType)((Object)this.getSchedule().get(i));
            }
            ++i;
        }
        i = 0;
        while (ref == null && i < this.getSchedule().getPending().size()) {
            dr = this.getSchedule().getPending().get(i);
            if (dr.getDescription() instanceof ActivityType) {
                ref = (ActivityType)((Object)dr.getDescription());
            }
            ++i;
        }
        i = 0;
        while (ref == null && i < this.getSchedule().getProcessed().size()) {
            dr = this.getSchedule().getProcessed().get(i);
            if (dr.getDescription() instanceof ActivityType) {
                ref = (ActivityType)((Object)dr.getDescription());
            }
            ++i;
        }
        this.getSchedule().clearProcessedElements();
        BehaviorElement last = null;
        do {
            BehaviorDescriptionImpl bd;
            changed = false;
            if (this.m_schedule.size() > 0) {
                int size = this.m_schedule.size();
                last = this.getSchedule().get(size - 1);
                int i2 = size - 1;
                while (i2 >= 0) {
                    BehaviorElement behavior = this.getSchedule().get(i2);
                    if (behavior == null) {
                        logger.warning(this + ": Schedule did not return " + "a behavior element (possibly due to " + "exception event): size=" + this.getSchedule().size() + " position=" + i2);
                    } else if (behavior.process(this, evt)) {
                        ret = true;
                        evt = null;
                    }
                    --i2;
                }
                size = this.m_schedule.size();
                if (size > 0 && this.getSchedule().get(size - 1) != last) {
                    changed = true;
                }
            }
            if (changed && !this.getSchedule().getFinishProcessing()) continue;
            StateChangeEvent sce = this.resetStateChangeEvent();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": State change event is: " + sce);
            }
            if (sce != null && (changed = this.processChanges(sce))) {
                this.getSchedule().resetFinishProcessing();
            }
            if (changed || ref == null || !this.isBehavioralSession() || !(evt instanceof Message) || this.getStatus() == 3 || !(bd = (BehaviorDescriptionImpl)ref.getEnclosingBehaviorDescription()).canTriggerException(this, evt)) continue;
            this.sessionTerminated(null);
            bd.triggerException(this, evt);
            changed = true;
        } while (changed && !this.getSchedule().getFinishProcessing());
        if (evt == null || !ret) {
            this.checkForCompletion(evt);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processChildSessions(ServiceEvent evt) throws ServiceException, OutOfSequenceMessageException {
        boolean ret = false;
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            do {
                this.m_childSessionsChanged = false;
                Iterator<SessionImpl> iter = this.m_activeChildSessions.iterator();
                while (!this.m_childSessionsChanged && iter.hasNext()) {
                    SessionImpl child = iter.next();
                    if (child.shouldAwaitingCompletion() || !child.process(evt)) continue;
                    ret = true;
                    evt = null;
                }
            } while (this.m_childSessionsChanged);
        }
        return ret;
    }

    public Map<String, Serializable> getVariables() {
        return this.m_variables;
    }

    public void setVariables(Map<String, Serializable> variables) {
        this.m_variables = variables;
    }

    @Override
    public synchronized void setVariable(String variable, Serializable value) throws LockedInformationException, ServiceException {
        if (this.isLocked(variable)) {
            throw new LockedInformationException(variable);
        }
        if (this.isSilentVariable(variable)) {
            throw new ServiceException("Cannot set a silent variable '" + variable + "'");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Set variable '" + variable + "' to: " + value);
        }
        this.m_variables.put(variable, this.internalValue(value));
        this.recordStateChange(variable);
        this.checkForCompletion(null);
    }

    protected void recordStateChange(String variable) {
        if (this.m_stateChangeEvent == null) {
            this.m_stateChangeEvent = new StateChangeEvent();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Record state change '" + variable + "'");
        }
        this.m_stateChangeEvent.addChangedVariable(variable);
    }

    protected StateChangeEvent resetStateChangeEvent() {
        StateChangeEvent ret = this.m_stateChangeEvent;
        this.m_stateChangeEvent = null;
        return ret;
    }

    @Override
    public Serializable getVariable(String variable) throws UnresolvedConstraintException, VariableMonitoringException, LockedInformationException, ServiceException {
        Serializable ret = null;
        if (this.isLocked(variable)) {
            throw new LockedInformationException(variable);
        }
        if (this.isSilentVariable(variable)) {
            if (this.getConfiguration().isMonitoring()) {
                throw new VariableMonitoringException(variable);
            }
            String sdname = this.getServiceDescription().getFullyQualifiedName();
            String bdname = this.getBehaviorDescriptionFullName();
            SilentVariableExtension extension = this.getConfiguration().getExtensionResolver().resolveSilentVariableExtension(sdname, bdname, variable);
            if (extension == null) {
                throw new ExtensionException("Silent variable extension for variable '" + variable + "' could not be found");
            }
            ret = extension.getValue(this.getExtensionContext());
        } else {
            ret = this.externalValue(this.m_variables.get(variable));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Get variable '" + variable + "' is: " + ret);
        }
        if (ret == null) {
            throw new UnresolvedConstraintException(variable);
        }
        return ret;
    }

    @Override
    public Set<String> getVariableNames() throws ServiceException {
        return this.m_variables.keySet();
    }

    public void lockVariable(String variable) {
        this.m_lockedVariables.add(variable);
    }

    public void unlockVariable(String variable) {
        this.m_lockedVariables.remove(variable);
    }

    @Override
    public boolean isLocked(String variable) {
        return this.m_lockedVariables.contains(variable);
    }

    @Override
    public boolean isObservableVariable(String variable) {
        return this.m_observableVariables.contains(variable);
    }

    @Override
    public void observableVariable(String variable) {
        this.m_observableVariables.add(variable);
    }

    @Override
    public void silentVariable(String variable) {
        this.m_silentVariables.add(variable);
    }

    @Override
    public boolean isSilentVariable(String variable) {
        return this.m_silentVariables.contains(variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel(String name, String type, String serviceRefType, String serviceType) {
        Channel ret = null;
        Map<String, Channel> map = this.m_channels;
        synchronized (map) {
            ret = this.m_channels.get(name);
            if (ret == null && type != null) {
                ret = new DefaultChannel(name, type, serviceRefType, serviceType);
                this.m_channels.put(name, ret);
                try {
                    Serializable val = this.getVariable(name);
                    if (val instanceof String) {
                        EndpointReference ref = EndpointReferenceFactory.getEndpointReference((String)((Object)val), serviceRefType);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Initializing channel '" + name + "' with service endpoint reference: " + ref);
                        }
                        ((DefaultChannel)ret).setServiceReference(ref);
                    }
                }
                catch (Exception exception) {}
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": Channel '" + name + "' created");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void relinquishChannel(String name) {
        Map<String, Channel> map = this.m_channels;
        synchronized (map) {
            if (this.m_channels.remove(name) != null && logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": Channel '" + name + "' relinquished");
            }
        }
    }

    @Override
    public void setServiceReference(Channel channel, EndpointReference reference) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Set channel '" + channel.getName() + "' service reference '" + reference + "'");
        }
        if (channel instanceof DefaultChannel) {
            ((DefaultChannel)channel).setServiceReference(reference);
        }
    }

    @Override
    public void registerSessionIdentity(Identity sessionId) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Register session identity '" + sessionId + "'");
        }
        this.primaryIdentityAdded(this, sessionId, null, true);
    }

    @Override
    public void registerChannelIdentity(Channel channel, Identity primaryId, boolean server) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Register channel identity '" + primaryId + "' on channel: " + channel.getName());
        }
        if (channel instanceof DefaultChannel) {
            if (((DefaultChannel)channel).addPrimaryIdentity(primaryId)) {
                String servType = channel.getServiceType();
                if (server) {
                    servType = String.valueOf(servType) + SERVER_CHANNEL_SUFFIX;
                }
                this.primaryIdentityAdded(this, primaryId, servType, false);
            }
        } else {
            throw new ServiceException(SessionImpl.getMessage("_INVALID_CHANNEL_IMPL", new Object[0]));
        }
    }

    @Override
    public void registerDerivedIdentity(Identity primaryId) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Register derived identity '" + primaryId + "'");
        }
        this.identityDerived(this, primaryId);
    }

    @Override
    public synchronized void schedule(BehaviorElement behavior) {
        this.getSchedule().schedule(behavior);
        if (this.m_awaitingCompletion) {
            this.m_awaitingCompletion = false;
        }
        behavior.scheduled(this);
    }

    @Override
    public synchronized void unschedule(BehaviorElement behavior) {
        this.getSchedule().unschedule(behavior);
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    protected void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildSession(SessionImpl session) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Add child " + session);
        }
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            this.m_activeChildSessions.add(session);
            this.m_childSessionsChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChildSession(SessionImpl session) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Remove child " + session + " from active child sessions and place " + "in completed sessions list");
        }
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            this.m_activeChildSessions.remove(session);
            session.setParentSession(null);
            this.m_childSessionsChanged = true;
        }
    }

    public Set<SessionImpl> getChildSessions() {
        return this.m_activeChildSessions;
    }

    public void setChildSessions(Set<SessionImpl> sessions) {
        this.m_activeChildSessions = sessions;
    }

    public Set<SessionStatus> getCompletedSessionStatus() {
        return this.m_completedSessionStatus;
    }

    public void setCompletedSessionStatus(Set<SessionStatus> list) {
        this.m_completedSessionStatus = list;
    }

    @Override
    public InternalSession getSession(String name, Object id) {
        SessionImpl ret = null;
        if (name != null) {
            Vector<InternalSession> list = new Vector<InternalSession>();
            SessionImpl session = this;
            if (!this.isBehavioralSession()) {
                session = (SessionImpl)this.getBehavioralSessionParent();
            }
            if (session == null) {
                this.buildSessionList(name, list);
            } else {
                session.buildSessionList(name, list);
            }
            int i = 0;
            while (ret == null && i < list.size()) {
                SessionImpl child = (SessionImpl)list.get(i);
                if (child.getBehaviorDescriptionName() != null && child.getBehaviorDescriptionName().equals(name)) {
                    if (id == null) {
                        if (child.getBehaviorInstanceId() == null) {
                            ret = child;
                        }
                    } else if (child.getBehaviorInstanceId() != null && child.getBehaviorInstanceId().equals(id)) {
                        ret = child;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    @Override
    public SessionStatus getSessionStatus(String name, Object id) {
        SessionStatus ret = null;
        if (name != null) {
            Vector<SessionStatus> list = new Vector<SessionStatus>();
            this.buildSessionStatusList(name, list);
            int i = 0;
            while (ret == null && i < list.size()) {
                SessionStatus child = (SessionStatus)list.get(i);
                if (child.getBehaviorDescriptionName() != null && child.getBehaviorDescriptionName().equals(name)) {
                    if (id == null) {
                        if (child.getBehaviorInstanceId() == null) {
                            ret = child;
                        }
                    } else if (child.getBehaviorInstanceId() != null && child.getBehaviorInstanceId().equals(id)) {
                        ret = child;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    @Override
    public List<SessionStatus> getSessionStatuses(String name) {
        Vector<SessionStatus> ret = new Vector<SessionStatus>();
        if (name != null) {
            this.buildSessionStatusList(name, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSessionList(String name, List<InternalSession> list) {
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            for (SessionImpl child : this.m_activeChildSessions) {
                child.addSessionToList(name, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSessionStatusList(String name, List<SessionStatus> list) {
        Set<Object> set = this.m_completedSessionStatus;
        synchronized (set) {
            for (SessionStatus status : this.m_completedSessionStatus) {
                if (!status.getBehaviorDescriptionName().equals(name)) continue;
                list.add(status);
            }
        }
        set = this.m_activeChildSessions;
        synchronized (set) {
            for (SessionImpl child : this.m_activeChildSessions) {
                child.addSessionStatusToList(name, list);
            }
        }
    }

    protected void addSessionToList(String name, List<InternalSession> list) {
        this.buildSessionList(name, list);
    }

    protected void addSessionStatusToList(String name, List<SessionStatus> list) {
        this.buildSessionStatusList(name, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pendingTimeout(String acturi, String expr) {
        boolean ret = false;
        List<String> list = this.m_pendingTimeouts;
        synchronized (list) {
            String key = this.getTimeoutKey(acturi, expr);
            ret = this.m_pendingTimeouts.contains(key);
            if (!ret) {
                this.m_pendingTimeouts.add(key);
            }
        }
        return ret;
    }

    protected String getTimeoutKey(String acturi, String expr) {
        return String.valueOf(acturi) + ":" + expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timedOut(String acturi, String expr) {
        List<String> list = this.m_pendingTimeouts;
        synchronized (list) {
            String key = this.getTimeoutKey(acturi, expr);
            this.m_timeouts.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTimedOut(String acturi, String expr) {
        boolean ret = false;
        List<String> list = this.m_pendingTimeouts;
        synchronized (list) {
            String key = this.getTimeoutKey(acturi, expr);
            ret = this.m_timeouts.contains(key);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTimeouts(String acturi) {
        List<String> list = this.m_pendingTimeouts;
        synchronized (list) {
            String val;
            String key = this.getTimeoutKey(acturi, "");
            int i = this.m_pendingTimeouts.size() - 1;
            while (i >= 0) {
                val = this.m_pendingTimeouts.get(i);
                if (val.startsWith(key)) {
                    this.m_pendingTimeouts.remove(i);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Unregistering timeout for " + this.getId() + " behavior element=" + acturi);
                    }
                    try {
                        this.getConfiguration().getTimeoutManager().unregister(this.getPrimaryIdentities(), this.getId(), acturi);
                    }
                    catch (Exception e) {
                        logger.severe("Failed to unregister timeout: " + e);
                    }
                }
                --i;
            }
            i = this.m_timeouts.size() - 1;
            while (i >= 0) {
                val = this.m_timeouts.get(i);
                if (val.startsWith(key)) {
                    this.m_timeouts.remove(i);
                }
                --i;
            }
        }
    }

    @Override
    public void sessionFinished() throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Session finished");
        }
        if (this.isCompleted()) {
            this.disgard();
        } else {
            this.m_awaitingCompletion = true;
        }
        if (this.m_pendingTimeouts.size() > 0) {
            this.getConfiguration().getTimeoutManager().unregister(this.getPrimaryIdentities(), this.getId(), null);
        }
        if (this.getConfiguration().getServiceTracker() != null) {
            if (this.isTopLevelSession()) {
                this.getConfiguration().getServiceTracker().serviceFinished(this.getServiceDescription(), this);
            } else {
                this.getConfiguration().getServiceTracker().subSessionFinished(this.getParent(), this);
            }
        }
        if (this.m_internalSessionListener != null) {
            this.m_internalSessionListener.sessionFinished(this);
        }
    }

    public boolean isTopLevelSession() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disgard() {
        this.recordCompletedStatus();
        if (this.m_parent != null) {
            this.m_parent.removeChildSession(this);
        }
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            for (SessionImpl child : this.m_activeChildSessions) {
                child.disgard();
            }
            this.m_activeChildSessions.clear();
            this.m_childSessionsChanged = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Session disgarded");
        }
    }

    protected void recordCompletedStatus() {
        if (this.getParentSession() != null && this.getCompletedSessionStatus().size() > 0) {
            this.getParentSession().getCompletedSessionStatus().addAll(this.getCompletedSessionStatus());
        }
    }

    @Override
    public void sessionTerminated(ExceptionEvent exception) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Session terminated");
        }
        this.m_terminated = true;
        this.m_terminatingException = exception;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Session " + this.hashCode() + " id=" + this.getId() + " terminated, so setting status to completed-unsuccessfully");
        }
        this.setStatus(3);
        this.getSchedule().clear();
        this.haltChildSessions();
        if (this.canDisgardOnTermination()) {
            this.disgard();
        }
    }

    protected void haltChildSessions() {
        for (SessionImpl child : new HashSet<SessionImpl>(this.getChildSessions())) {
            if (child.shouldAwaitingCompletion()) continue;
            child.haltChildSessions();
            if (child.getChildSessions().size() != 0) continue;
            child.disgard();
        }
    }

    protected boolean canDisgardOnTermination() {
        boolean ret = false;
        if (this.getChildSessions().size() == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public ExceptionEvent getTerminatingException() {
        return this.m_terminatingException;
    }

    @Override
    public void terminatingExceptionHandled() {
        this.m_terminatingException = null;
    }

    public boolean isTerminated() {
        return this.m_terminated;
    }

    public void setTerminated(boolean b) {
        this.m_terminated = b;
    }

    protected boolean isPendingTermination() {
        return this.isTerminated() && this.getTerminatingException() == null;
    }

    @Override
    public boolean isCompleted() {
        return this.m_completed;
    }

    public void setCompleted(boolean completed) {
        this.m_completed = completed;
    }

    @Override
    public boolean isEarlyCompletion() {
        return this.m_earlyCompletion;
    }

    public void setEarlyCompletion(boolean b) {
        this.m_earlyCompletion = b;
    }

    protected boolean shouldAwaitingCompletion() {
        boolean awaitingCompletion = this.m_awaitingCompletion;
        if (!this.isBehavioralSession()) {
            Iterator<SessionImpl> iter = this.m_activeChildSessions.iterator();
            while (awaitingCompletion && iter.hasNext()) {
                SessionImpl is = iter.next();
                awaitingCompletion = is.shouldAwaitingCompletion();
            }
        }
        return awaitingCompletion && !this.m_completed;
    }

    public boolean isAwaitingCompletion() {
        return this.m_awaitingCompletion;
    }

    public void setAwaitingCompletion(boolean b) {
        this.m_awaitingCompletion = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionCompleted() {
        this.m_completed = true;
        Set<SessionImpl> set = this.m_activeChildSessions;
        synchronized (set) {
            for (SessionImpl child : this.m_activeChildSessions) {
                child.sessionCompleted();
            }
            this.m_activeChildSessions.clear();
            this.m_childSessionsChanged = true;
        }
    }

    protected void checkForCompletion(ServiceEvent event) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            int size = 0;
            if (this.getCompletionPredicates() != null) {
                size = this.getCompletionPredicates().length;
            }
            logger.fine("Session '" + this.getId().toString() + "': Check for completion (" + event + "): no. of completion predicates=" + size + " schedule size=" + this.m_schedule.size());
        }
        if (!(this.isEarlyCompletion() || this.getCompletionPredicates() == null || this.getCompletionPredicates().length <= 0 || this.m_schedule.size() <= 0 && this.getChildSessions().size() <= 0)) {
            boolean complete = false;
            boolean nonRelevantComplete = false;
            int relevantCount = 0;
            int i = 0;
            while (!complete && i < this.getCompletionPredicates().length) {
                boolean relevant = this.getCompletionPredicates()[i].isRelevant(this, event);
                if (relevant || event != null && this.getCompletionPredicates()[i].isMessagePredicate()) {
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Evaluating completion predicate: " + this.getCompletionPredicates()[i]);
                        }
                        boolean result = this.getCompletionPredicates()[i].isSatisfied(this, event);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Evaluating result: " + result);
                        }
                        if (relevant) {
                            complete = result;
                            ++relevantCount;
                        } else if (result) {
                            nonRelevantComplete = result;
                        }
                    }
                    catch (UnresolvedConstraintException unresolvedConstraintException) {
                    }
                    catch (LockedInformationException lockedInformationException) {}
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Completion predicate not relevant: " + this.getCompletionPredicates()[i]);
                }
                ++i;
            }
            if (relevantCount == 0) {
                complete = nonRelevantComplete;
            }
            if (complete) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Completing session");
                }
                this.m_earlyCompletion = true;
                this.getSchedule().clear();
                this.getSchedule().setDisgard(true);
                this.haltChildSessions();
                this.setCompletionPredicates(null);
            }
        }
    }

    @Override
    public void setCompletionPredicates(Predicate[] predicates) {
        this.m_completionPredicates = predicates;
    }

    @Override
    public Predicate[] getCompletionPredicates() {
        return this.m_completionPredicates;
    }

    @Override
    public void setPostConditions(Predicate[] predicates) {
        logger.severe("Attempt to set post condition predicates is invalid");
    }

    @Override
    public Predicate[] getPostConditions() {
        if (this.getParent() != null) {
            return this.getParent().getPostConditions();
        }
        return null;
    }

    @Override
    public void setExceptionPropagationConditions(Predicate[] predicates) {
        logger.severe("Attempt to set exception propagation predicates is invalid");
    }

    @Override
    public Predicate[] getExceptionPropagationConditions() {
        if (this.getParent() != null) {
            return this.getParent().getExceptionPropagationConditions();
        }
        return null;
    }

    public void primaryIdentityAdded(InternalSession session, Identity identity, String serviceType, boolean ignoreDuplicates) throws ServiceException {
        boolean added = false;
        boolean duplicate = false;
        if (serviceType == null) {
            serviceType = "";
        }
        if (this.m_identityMap.containsKey(identity)) {
            List<String> list = this.m_identityMap.get(identity);
            if (list.contains(serviceType)) {
                if (!ignoreDuplicates) {
                    duplicate = true;
                }
            } else {
                list.add(serviceType);
            }
            if (duplicate) {
                String mesg = SessionImpl.getMessage("_DUPLICATE_PRIMARY_IDENTITY", new Object[]{identity.getId(), serviceType});
                logger.warning(mesg);
            }
        } else {
            Vector<String> entry = new Vector<String>();
            entry.add(serviceType);
            this.m_identityMap.put(identity, entry);
        }
        if (!this.m_identities.contains(identity)) {
            this.m_identities.add(new Identity(identity));
            added = true;
        }
        if (added) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": Primary identity '" + identity + "' added for session: " + session);
            }
            this.m_derivedIdentities.remove(identity);
            if (this.getParent() instanceof SessionImpl) {
                ((SessionImpl)this.getParent()).primaryIdentityAdded(session, identity, serviceType, ignoreDuplicates);
            }
        }
    }

    protected void primaryIdentityRemoved(InternalSession session, Identity identity) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Primary identity '" + identity + "' removed for session: " + session);
        }
        this.m_identityMap.remove(identity);
        this.m_identities.remove(identity);
        if (this.getParent() instanceof SessionImpl) {
            ((SessionImpl)this.getParent()).primaryIdentityRemoved(session, identity);
        }
    }

    public Set<Identity> getIdentities() {
        return this.m_identities;
    }

    public void setIdentities(Set<Identity> list) {
        this.m_identities = list;
    }

    protected void identityDerived(SessionImpl session, Identity identity) throws ServiceException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Derived identity '" + identity + "' for session: " + session);
        }
        this.m_derivedIdentities.add(new Identity(identity));
        if (this.getParent() instanceof SessionImpl) {
            ((SessionImpl)this.getParent()).identityDerived(session, identity);
        }
    }

    public Set<Identity> getDerivedIdentities() {
        return this.m_derivedIdentities;
    }

    public void setDerivedIdentities(Set<Identity> ids) {
        this.m_derivedIdentities = ids;
    }

    @Override
    public void setInternalSessionListener(InternalSessionListener l) {
        this.m_internalSessionListener = l;
        if (this.m_internalSessionListener != null) {
            this.m_sessionListenerId = this.m_internalSessionListener.getId();
            this.m_internalSessionListener.sessionListenerRegistered(this);
        } else {
            this.m_sessionListenerId = null;
        }
    }

    protected Serializable internalValue(Serializable val) {
        if (val == null) {
            val = NULL;
        }
        return val;
    }

    protected Serializable externalValue(Serializable val) {
        if (val == NULL) {
            val = null;
        }
        return val;
    }

    protected int allocateNextChildSessionId() {
        return this.m_nextChildSessionId++;
    }

    public int getNextChildSessionId() {
        return this.m_nextChildSessionId;
    }

    public void setNextChildSessionId(int id) {
        this.m_nextChildSessionId = id;
    }

    @Override
    public InternalSession getParent() {
        SessionImpl ret = this.m_parent;
        if (ret == null) {
            ret = this.m_oldParent;
        }
        return ret;
    }

    public SessionImpl getParentSession() {
        return this.m_parent;
    }

    public void setParentSession(SessionImpl parent) {
        if (parent == null) {
            this.m_oldParent = this.m_parent;
        }
        this.m_parent = parent;
    }

    @Override
    public boolean isBehavioralSession() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public InternalSession getBehavioralSessionParent() {
        InternalSession ret = null;
        if (this.getParent() != null) {
            ret = ((SessionImpl)this.getParent()).isBehavioralSession() ? this.getParent() : this.getParent().getBehavioralSessionParent();
        }
        return ret;
    }

    @Override
    public void information(String details) {
        this.getConfiguration().getServiceTracker().information(this, details);
    }

    @Override
    public void warning(String details, Throwable exc) {
        this.getConfiguration().getServiceTracker().warning(this, details, exc);
    }

    @Override
    public void error(String details, Throwable exc) {
        this.getConfiguration().getServiceTracker().error(this, details, exc);
    }

    public String toString() {
        String id = "";
        if (this.getId() != null) {
            id = " id=" + this.getId().toString();
        }
        String ret = "Session{" + this.hashCode() + id + "}";
        return ret;
    }

    protected static String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)"session", (String)key, (Object[])params);
    }

    public String getBehaviorDescription() {
        return this.m_behaviorDescription;
    }

    public void setBehaviorDescription(String bd) {
        this.m_behaviorDescription = bd;
    }

    public List<String> getLockedVariables() {
        return this.m_lockedVariables;
    }

    public void setLockedVariables(List<String> lockedVars) {
        this.m_lockedVariables = lockedVars;
    }

    public List<String> getObservableVariables() {
        return this.m_observableVariables;
    }

    public void setObservableVariables(List<String> observableVars) {
        this.m_observableVariables = observableVars;
    }

    public List<String> getSilentVariables() {
        return this.m_silentVariables;
    }

    public void setSilentVariables(List<String> silentVars) {
        this.m_silentVariables = silentVars;
    }

    public List<String> getTimeouts() {
        return this.m_timeouts;
    }

    public void setTimeouts(List<String> timeouts) {
        this.m_timeouts = timeouts;
    }

    public List<String> getPendingTimeouts() {
        return this.m_pendingTimeouts;
    }

    public void setPendingTimeouts(List<String> timeouts) {
        this.m_pendingTimeouts = timeouts;
    }

    public Map<String, Channel> getChannels() {
        return this.m_channels;
    }

    public void setChannels(Map<String, Channel> channels) {
        this.m_channels = channels;
    }

    public String getSessionListenerId() {
        return this.m_sessionListenerId;
    }

    public void setSessionListenerId(String id) {
        this.m_sessionListenerId = id;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(1);
        out.writeObject(this.m_sessionId);
        out.writeObject(this.m_sessionIdentity);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_behaviorDescription));
        out.writeObject(this.m_behaviorInstanceId);
        out.writeObject(this.m_parent);
        out.writeInt(this.m_status);
        out.writeObject(this.m_schedule);
        out.writeObject(this.m_variables);
        out.writeObject(this.m_lockedVariables);
        out.writeObject(this.m_observableVariables);
        out.writeObject(this.m_silentVariables);
        out.writeObject(this.m_pendingTimeouts);
        out.writeObject(this.m_timeouts);
        out.writeObject(this.m_channels);
        out.writeObject(this.m_stateChangeEvent);
        out.writeObject(this.m_activeChildSessions);
        out.writeUTF(SerializationUtil.encodeUTF((String)this.m_sessionListenerId));
        out.writeBoolean(this.m_terminated);
        out.writeBoolean(this.m_completed);
        out.writeBoolean(this.m_earlyCompletion);
        out.writeBoolean(this.m_awaitingCompletion);
        out.writeObject(this.m_terminatingException);
        out.writeInt(this.m_nextChildSessionId);
        out.writeObject(this.m_identities);
        out.writeObject(this.m_derivedIdentities);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version == 1) {
            this.m_sessionId = (SessionId)in.readObject();
            this.m_sessionIdentity = (Identity)in.readObject();
            this.m_behaviorDescription = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_behaviorInstanceId = (Serializable)in.readObject();
            this.m_parent = (SessionImpl)in.readObject();
            this.m_status = in.readInt();
            this.m_schedule = (Schedule)in.readObject();
            this.m_variables = (Map)in.readObject();
            this.m_lockedVariables = (List)in.readObject();
            this.m_observableVariables = (List)in.readObject();
            this.m_silentVariables = (List)in.readObject();
            this.m_pendingTimeouts = (List)in.readObject();
            this.m_timeouts = (List)in.readObject();
            this.m_channels = (Map)in.readObject();
            this.m_stateChangeEvent = (StateChangeEvent)in.readObject();
            this.m_activeChildSessions = (Set)in.readObject();
            this.m_sessionListenerId = SerializationUtil.decodeUTF((String)in.readUTF());
            this.m_terminated = in.readBoolean();
            this.m_completed = in.readBoolean();
            this.m_earlyCompletion = in.readBoolean();
            this.m_awaitingCompletion = in.readBoolean();
            this.m_terminatingException = (ExceptionEvent)in.readObject();
            this.m_nextChildSessionId = in.readInt();
            this.m_identities = (Set)in.readObject();
            this.m_derivedIdentities = (Set)in.readObject();
        }
    }
}

