/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.service.DefaultMessage;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.FaultMessage;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnexpectedMessageException;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.extensions.SynchronousInvokeExtension;
import org.pi4soa.service.repository.ServiceRepositoryListener;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.session.SessionManager;
import org.pi4soa.service.session.SessionManagerException;
import org.pi4soa.service.session.impl.MessageImpl;
import org.pi4soa.service.session.impl.MessageMemento;
import org.pi4soa.service.session.impl.SessionImpl;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSession;
import org.pi4soa.service.session.internal.MessageUtil;
import org.pi4soa.service.session.internal.SessionConfiguration;
import org.pi4soa.service.session.internal.SessionFactory;
import org.pi4soa.service.session.internal.TimeoutEvent;
import org.pi4soa.service.timer.TimeoutHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProcessor {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.monitor.impl");
    private SessionConfiguration m_configuration = null;
    private TimeoutHandler m_timeoutHandler = null;

    public SessionProcessor(SessionConfiguration config) throws ServiceException {
        this.m_configuration = config;
        if (config.getServiceRegistry() != null) {
            config.getServiceRegistry().initialize();
        }
        if (config.getServiceRepository() != null) {
            config.getServiceRepository().initialize();
        }
        config.getServiceRepository().addServiceRepositoryListener(new ServiceRepositoryListener(){

            public void serviceDescriptionAdded(ServiceDescription sdesc) throws ServiceException {
                SessionProcessor.this.initializeServiceDescription(sdesc);
            }

            public void serviceDescriptionUpdated(ServiceDescription oldsdesc, ServiceDescription newsdesc) throws ServiceException {
                SessionProcessor.this.initializeServiceDescription(newsdesc);
            }

            public void serviceDescriptionRemove(ServiceDescription sdesc) throws ServiceException {
            }
        });
        if (config.getSessionManager() != null) {
            config.getSessionManager().initialize(config.getServiceRepository());
        }
        if (config.getTimeoutManager() != null) {
            config.getTimeoutManager().initialize(config.getServiceRepository());
            this.m_timeoutHandler = new TimeoutHandler(){

                @Override
                public void timeoutExpired(Set<Identity> identities, SessionId subSessionId, String behaviorElementId, String expression) {
                    SessionProcessor.this.handleTimeout(identities, subSessionId, behaviorElementId, expression);
                }
            };
            config.getTimeoutManager().addTimeoutHandler(this.m_timeoutHandler);
        }
        if (config.getServiceTracker() != null) {
            config.getServiceTracker().initialize();
        }
    }

    protected void initializeServiceDescription(ServiceDescription sdesc) throws ServiceException {
        BehaviorElement be = this.getBehaviorElement(sdesc);
        if (be != null) {
            try {
                be.initialize(this.getConfiguration().getExtensionResolver());
            }
            catch (ServiceException ex) {
                logger.severe("Failed to initialize extensions for service description '" + sdesc.getName() + "': " + ex);
                throw ex;
            }
        }
    }

    public Message createMessage(String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(type, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createRequest(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(opName, faultName, type, true, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public Message createResponse(String opName, String faultName, String type, String serviceType, EndpointReference serviceEndpoint, Serializable value, Identity sessionId, Identity channelIdentity) {
        return new MessageImpl(opName, faultName, type, false, serviceType, serviceEndpoint, value, sessionId, channelIdentity);
    }

    public static MessageImpl getMessageImpl(Message message) {
        MessageImpl ret = null;
        ret = message instanceof MessageImpl ? (MessageImpl)message : new MessageImpl(message);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageImpl message) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        Session session = null;
        ServiceDescription[] sdescs = this.getConfiguration().getServiceRepository().getServiceDescriptions(message.getServiceType());
        boolean deriveIdentities = true;
        boolean cannotInitiateSession = false;
        if (sdescs.length == 1 && sdescs[0] != null && !message.isRPCStyle()) {
            SessionProcessor sessionProcessor = this;
            synchronized (sessionProcessor) {
                if (message.getMessageIdentities() != null && message.getMessageIdentities().size() > 0) {
                    logger.finer("Not deriving identities as message already has content based identities");
                    deriveIdentities = false;
                } else {
                    this.deriveSessionIdentity(sdescs[0], message);
                }
                session = this.findSession(sdescs[0], message.getAllIdentities());
                if (session == null) {
                    if (MessageUtil.canInitiateSession(sdescs[0], message, this.getConfiguration())) {
                        session = this.createSession(sdescs[0], message.getSessionIdentity(), message.getMessageIdentities());
                    } else {
                        cannotInitiateSession = true;
                    }
                }
            }
            this.handleMessageEvent(message, sdescs[0], session, deriveIdentities, cannotInitiateSession);
        } else {
            ServiceDescription servDesc = null;
            MessageDefinition mdefn = null;
            boolean statelessService = false;
            MessageMemento memento = null;
            SessionProcessor sessionProcessor = this;
            synchronized (sessionProcessor) {
                if (message.getMessageIdentities() != null && message.getMessageIdentities().size() > 0) {
                    logger.finer("Not deriving identities as message already has content based identities");
                    deriveIdentities = false;
                }
                int i = 0;
                while (session == null && sdescs != null && i < sdescs.length) {
                    ServiceType st;
                    mdefn = MessageUtil.getMessageDefinition(sdescs[i], message, this.getConfiguration());
                    if (mdefn != null && ((st = sdescs[i].getServiceType(message.getServiceType())) == null || this.m_configuration.isMonitoring() || st.isServiceProvider() && message.isRequest() || st.isServiceClient() && !message.isRequest())) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Found appropriate service type on service description '" + sdescs[i].getName() + "'");
                        }
                        if (deriveIdentities) {
                            this.deriveSessionIdentity(sdescs[i], message);
                        }
                        if ((session = this.findSession(sdescs[i], message.getAllIdentities())) == null) {
                            if (MessageUtil.canInitiateSession(sdescs[i], message, this.getConfiguration())) {
                                if (servDesc != null && logger.isLoggable(Level.WARNING)) {
                                    logger.warning("Multiple service descriptions can be initiated by message: " + message);
                                }
                                servDesc = sdescs[i];
                                memento = message.createMemento();
                            } else {
                                cannotInitiateSession = true;
                            }
                        } else {
                            servDesc = sdescs[i];
                        }
                    }
                    ++i;
                }
                if (mdefn != null) {
                    if (servDesc != null && servDesc.getStateless() == Boolean.TRUE) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Stateless service detected: " + servDesc);
                        }
                        statelessService = true;
                    }
                    if (session == null && servDesc != null) {
                        if (memento == null && logger.isLoggable(Level.SEVERE)) {
                            logger.severe("Found service description '" + servDesc.getName() + "' to create, but unable to restore message");
                        }
                        message.restore(memento);
                        if (!statelessService) {
                            session = this.createSession(servDesc, message.getSessionIdentity(), message.getMessageIdentities());
                        }
                    }
                }
            }
            if (servDesc == null && sdescs.length == 1) {
                servDesc = sdescs[0];
            }
            this.handleRPCEvent(message, servDesc, mdefn, session, deriveIdentities, cannotInitiateSession, statelessService);
        }
    }

    protected void handleRPCEvent(MessageImpl message, ServiceDescription servDesc, MessageDefinition mdefn, Session session, boolean deriveIdentities, boolean cannotInitiateSession, boolean statelessService) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        if (mdefn != null && (session != null || statelessService)) {
            if (message.getServiceType() == null) {
                message.setServiceType(mdefn.getOperationDefinition().getServiceType().getFullyQualifiedName());
                logger.fine("Setting the service type: " + message.getServiceType());
            }
            if (message.isRequest() && mdefn.getOperationDefinition() != null && mdefn.getOperationDefinition().isResponseExpected()) {
                message.setResponseExpected(true);
            }
            if (session != null) {
                Externalizable evt = message;
                if (!deriveIdentities && NamesUtil.isSet((String)message.getFaultName()) && MessageUtil.getMessageDefinition(servDesc, message, this.getConfiguration()) == null) {
                    evt = new ExceptionEvent(message.getFaultName(), message);
                    message.clearFaultName();
                }
                this.processEvent((ServiceEvent)((Object)evt), session, servDesc);
            } else if (statelessService) {
                this.processStatelessMessage(message, servDesc, mdefn);
            }
        } else {
            if (cannotInitiateSession) {
                String text = SessionImpl.getMessage("_CANNOT_INITIATE_SESSION", new Object[]{message});
                message.processingFailed();
                if (!message.shouldRetry()) {
                    this.m_configuration.getServiceTracker().unexpectedMessage(servDesc, null, message, text);
                }
                throw new OutOfSequenceMessageException(text, message);
            }
            if (this.m_configuration != null && this.m_configuration.getReportUnknownMessages()) {
                String text = SessionImpl.getMessage("_UNKNOWN_MESSAGE", new Object[]{message});
                this.m_configuration.getServiceTracker().unexpectedMessage(servDesc, null, message, text);
                throw new UnexpectedMessageException(text, message);
            }
        }
    }

    protected void handleMessageEvent(MessageImpl message, ServiceDescription servDesc, Session session, boolean deriveIdentities, boolean cannotInitiateSession) throws ServiceException, OutOfSequenceMessageException, UnexpectedMessageException {
        if (session != null) {
            this.processEvent(message, session, servDesc);
        } else {
            if (cannotInitiateSession) {
                String text = SessionImpl.getMessage("_CANNOT_INITIATE_SESSION", new Object[]{message});
                message.processingFailed();
                if (!message.shouldRetry()) {
                    this.m_configuration.getServiceTracker().unexpectedMessage(servDesc, null, message, text);
                }
                throw new OutOfSequenceMessageException(text, message);
            }
            if (this.m_configuration != null && this.m_configuration.getReportUnknownMessages()) {
                String text = SessionImpl.getMessage("_UNKNOWN_MESSAGE", new Object[]{message});
                this.m_configuration.getServiceTracker().unexpectedMessage(servDesc, null, message, text);
                throw new UnexpectedMessageException(text, message);
            }
        }
    }

    protected void processEvent(ServiceEvent evt, Session sess, ServiceDescription sdesc) throws ServiceException, OutOfSequenceMessageException {
        InternalSession session = null;
        if (sess instanceof InternalSession) {
            session = (InternalSession)sess;
            this.getConfiguration().getSessionManager().processingStarted(session);
        } else {
            logger.severe("Session returned from SessionManager.processingStarted was not an InternalSession: " + sess);
        }
        try {
            if (session.shouldResume()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Session is being resumed: " + session);
                }
                session.resume(sdesc, this.getConfiguration());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Session has been resumed: " + session);
                }
            }
            session.process(evt);
            if (session.isCompleted()) {
                this.removeSession(session);
            }
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingCompleted(session);
            }
        }
        catch (OutOfSequenceMessageException oose) {
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingFailed(session);
            }
            throw oose;
        }
        catch (ServiceException se) {
            if (this.getConfiguration().getSessionManager() != null) {
                this.getConfiguration().getSessionManager().processingFailed(session);
            }
            throw se;
        }
    }

    protected void processStatelessMessage(Message message, ServiceDescription sdesc, MessageDefinition mdefn) throws ServiceException, UnexpectedMessageException {
        if (mdefn == null) {
            String text = SessionImpl.getMessage("_UNKNOWN_MESSAGE", new Object[]{message});
            this.m_configuration.getServiceTracker().unexpectedMessage(sdesc, null, message, text);
            throw new UnexpectedMessageException(text, message);
        }
        if (this.getConfiguration().isMonitoring()) {
            if (message.isOutbound()) {
                if (this.getConfiguration().getServiceTracker() != null) {
                    this.getConfiguration().getServiceTracker().sentMessage(mdefn, message);
                }
            } else if (this.getConfiguration().getServiceTracker() != null) {
                this.getConfiguration().getServiceTracker().receivedMessage(mdefn, message);
            }
        } else {
            String localpart = NameSpaceUtil.getLocalPart((String)message.getServiceType());
            SynchronousInvokeExtension ext = this.getConfiguration().getExtensionResolver().resolveSynchronousInvokeExtension(sdesc.getFullyQualifiedName(), localpart, message.getOperationName());
            if (ext == null) {
                throw new ServiceException("Extension for synchronous invocation could not be found");
            }
            Message returnMessage = null;
            try {
                Serializable result = ext.invoke(null, message);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response has been returned from synchronous invoke: " + result);
                }
                if (result != null) {
                    if (this.getConfiguration().getServiceTracker() != null) {
                        this.getConfiguration().getServiceTracker().receivedMessage(mdefn, message);
                    }
                    returnMessage = this.getConfiguration().getMessageHandler().createResponse(message.getOperationName(), null, null, message.getServiceType(), message.getServiceEndpoint(), result, message.getSessionIdentity(), message.getChannelIdentity());
                }
            }
            catch (FaultMessage fault) {
                logger.info("Fault has been returned from synchronous invoke: " + fault);
                returnMessage = this.getConfiguration().getMessageHandler().createResponse(message.getOperationName(), fault.getFaultType(), null, message.getServiceType(), message.getServiceEndpoint(), fault.getFaultMessage(), message.getSessionIdentity(), message.getChannelIdentity());
            }
            if (returnMessage != null) {
                if (returnMessage instanceof DefaultMessage && message instanceof DefaultMessage) {
                    ((DefaultMessage)returnMessage).getProperties().putAll(((DefaultMessage)message).getProperties());
                } else {
                    logger.warning("Unable to copy properties from stateless request to response: " + message);
                }
                List<Identity> ids = MessageUtil.deriveIdentity(sdesc, returnMessage, this.getConfiguration());
                returnMessage.setMessageIdentities(ids);
                this.getConfiguration().getMessageHandler().dispatch(null, returnMessage, mdefn.getOperationDefinition());
                if (this.getConfiguration().getServiceTracker() != null) {
                    this.getConfiguration().getServiceTracker().sentMessage(mdefn, returnMessage);
                }
            }
        }
    }

    protected void handleTimeout(Set<Identity> identities, SessionId subSessionId, String behaviorElementId, String expression) {
        try {
            ServiceDescription sdesc = this.getConfiguration().getServiceRepository().getServiceDescription(subSessionId.getServiceDescriptionName(), null);
            if (sdesc == null) {
                logger.warning("Unable to find service description associated with timeout: subSessionId=" + subSessionId + " activity=" + behaviorElementId + " expression=" + expression);
            } else {
                Session session = this.findSession(sdesc, identities);
                if (session != null) {
                    TimeoutEvent te = new TimeoutEvent(subSessionId, behaviorElementId, expression);
                    this.processEvent(te, session, sdesc);
                } else {
                    logger.warning("Unable to find session associated timeout: subSessionId=" + subSessionId + " activity=" + behaviorElementId + " expression=" + expression);
                }
            }
        }
        catch (Exception se) {
            logger.log(Level.SEVERE, "Failed to handle timeout for sub session id '" + subSessionId + "'", se);
        }
    }

    protected void deriveSessionIdentity(ServiceDescription sdesc, MessageImpl message) {
        if (message.getSessionIdentity() == null) {
            List<Identity> ids = MessageUtil.deriveIdentity(sdesc, message, this.getConfiguration());
            message.setMessageIdentities(ids);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Session identity found, so not deriving message identities");
        }
    }

    protected Session createSession(ServiceDescription sdesc, Identity sessionIdentity, List<Identity> messageIdentities) throws ServiceException {
        InternalSession ret = null;
        BehaviorElement be = this.getBehaviorElement(sdesc);
        if (be != null) {
            InternalSession session = SessionFactory.getSession(sdesc, this.getConfiguration().getIdentityManager().getStringIdentity(), sessionIdentity);
            session.initialize(this.getConfiguration());
            SessionManager sm = this.getConfiguration().getSessionManager();
            if (sm != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Adding new session '" + session + "', with session identity '" + sessionIdentity + "' to session manager");
                }
                sm.addSession(session);
                ret = session;
            } else if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Failed to create session manager for service description '" + sdesc.getName() + "'");
            }
        } else {
            throw new ServiceException("Service description '" + sdesc.getName() + "' does not have an associated " + "behavior element - so cannot create a session");
        }
        return ret;
    }

    protected BehaviorElement getBehaviorElement(ServiceDescription desc) throws ServiceException {
        BehaviorElement ret = null;
        if (this.getConfiguration().getSessionComponentResolver() != null) {
            ret = this.getConfiguration().getSessionComponentResolver().getBehaviorElement(desc);
        } else if (desc instanceof BehaviorElement) {
            ret = (BehaviorElement)((Object)desc);
        }
        return ret;
    }

    protected void removeSession(InternalSession session) {
        SessionManager sm = this.getConfiguration().getSessionManager();
        if (sm != null) {
            try {
                sm.removeSession(session);
            }
            catch (SessionManagerException e) {
                logger.log(Level.SEVERE, "Failed to remove session '" + session + "' from state manager: " + e, e);
            }
        }
    }

    protected Session findSession(ServiceDescription sdesc, Collection<Identity> identities) throws ServiceException {
        Session ret = null;
        SessionManager sm = this.getConfiguration().getSessionManager();
        if (sm != null) {
            ret = sm.getSession(sdesc, identities);
        }
        return ret;
    }

    protected SessionConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public void close() throws ServiceException {
        if (this.m_timeoutHandler != null && this.getConfiguration() != null && this.getConfiguration().getTimeoutManager() != null) {
            this.getConfiguration().getTimeoutManager().removeTimeoutHandler(this.m_timeoutHandler);
        }
    }
}

