/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.pi4soa.service.Channel;
import org.pi4soa.service.EndpointReference;
import org.pi4soa.service.Identity;
import org.pi4soa.service.LockedInformationException;
import org.pi4soa.service.OutOfSequenceMessageException;
import org.pi4soa.service.ServiceEvent;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.UnresolvedConstraintException;
import org.pi4soa.service.VariableMonitoringException;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.extensions.ExtensionContext;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.session.SessionStatus;
import org.pi4soa.service.session.internal.BehaviorElement;
import org.pi4soa.service.session.internal.ExceptionEvent;
import org.pi4soa.service.session.internal.InternalSessionListener;
import org.pi4soa.service.session.internal.Predicate;
import org.pi4soa.service.session.internal.SessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface InternalSession
extends Session {
    public static final int STATUS_INSTANCE_UNKNOWN = 0;
    public static final int STATUS_ENABLED = 1;
    public static final int STATUS_COMPLETED_SUCCESSFULLY = 2;
    public static final int STATUS_COMPLETED_UNSUCCESSFULLY = 3;
    public static final int STATUS_CLOSED = 4;
    public static final int STATUS_AMBIGUOUS = 5;
    public static final String STATUS_INSTANCE_UNKNOWN_TEXT = "instance-unknown";
    public static final String STATUS_ENABLED_TEXT = "enabled";
    public static final String STATUS_COMPLETED_SUCCESSFULLY_TEXT = "completed-successfully";
    public static final String STATUS_COMPLETED_UNSUCCESSFULLY_TEXT = "completed-unsuccessfully";
    public static final String STATUS_CLOSED_TEXT = "closed";
    public static final String STATUS_AMBIGUOUS_TEXT = "ambiguous";

    public void initialize(SessionConfiguration var1) throws ServiceException;

    public void resume(ServiceDescription var1, SessionConfiguration var2) throws ServiceException;

    public boolean shouldResume();

    public SessionConfiguration getConfiguration();

    public ExtensionContext getExtensionContext();

    public ExtensionContext getReadOnlyExtensionContext();

    public ServiceDescription getServiceDescription() throws ServiceException;

    public int getStatus();

    public void setStatus(int var1);

    public boolean process(ServiceEvent var1) throws ServiceException, OutOfSequenceMessageException;

    public void setVariable(String var1, Serializable var2) throws LockedInformationException, ServiceException;

    public Serializable getVariable(String var1) throws UnresolvedConstraintException, VariableMonitoringException, LockedInformationException, ServiceException;

    public Set<String> getVariableNames() throws ServiceException;

    public boolean isLocked(String var1);

    public boolean isObservableVariable(String var1);

    public void observableVariable(String var1);

    public void silentVariable(String var1);

    public boolean isSilentVariable(String var1);

    public Channel getChannel(String var1, String var2, String var3, String var4);

    public void relinquishChannel(String var1);

    public void setServiceReference(Channel var1, EndpointReference var2);

    public void buildListOfPrimaryIdentities(Set<Identity> var1);

    public void registerSessionIdentity(Identity var1) throws ServiceException;

    public void registerChannelIdentity(Channel var1, Identity var2, boolean var3) throws ServiceException;

    public void registerDerivedIdentity(Identity var1) throws ServiceException;

    public void schedule(BehaviorElement var1);

    public void unschedule(BehaviorElement var1);

    public InternalSession getSession(String var1, Object var2);

    public SessionStatus getSessionStatus(String var1, Object var2);

    public List<SessionStatus> getSessionStatuses(String var1);

    public boolean pendingTimeout(String var1, String var2);

    public void timedOut(String var1, String var2);

    public boolean hasTimedOut(String var1, String var2);

    public void clearTimeouts(String var1);

    public void setInternalSessionListener(InternalSessionListener var1);

    public InternalSession getParent();

    public boolean isRoot();

    public boolean isBehavioralSession();

    public InternalSession getBehavioralSessionParent();

    public void sessionFinished() throws ServiceException;

    public void sessionTerminated(ExceptionEvent var1) throws ServiceException;

    public ExceptionEvent getTerminatingException();

    public void terminatingExceptionHandled();

    public boolean isEarlyCompletion();

    public void sessionCompleted();

    public void setCompletionPredicates(Predicate[] var1);

    public Predicate[] getCompletionPredicates();

    public void setPostConditions(Predicate[] var1);

    public Predicate[] getPostConditions();

    public void setExceptionPropagationConditions(Predicate[] var1);

    public Predicate[] getExceptionPropagationConditions();

    public void information(String var1);

    public void warning(String var1, Throwable var2);

    public void error(String var1, Throwable var2);
}

