/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.session.internal;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xpath.XPathEvaluator;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.InformationType;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.OperationDefinition;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.behavior.ServiceType;
import org.pi4soa.service.behavior.TokenLocator;
import org.pi4soa.service.session.internal.SessionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.session.impl");

    public static ServiceType getServiceType(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        ServiceType ret = null;
        if (mesg.getServiceType() == null || mesg.getServiceType().trim().length() == 0) {
            String reqType = mesg.isRequest() ? mesg.getType() : null;
            String respType = mesg.isRequest() ? null : mesg.getType();
            Iterator iter = sd.getServiceTypes().iterator();
            int defns = 0;
            while (iter.hasNext()) {
                ServiceType stype = (ServiceType)iter.next();
                boolean f_process = true;
                if (!config.isMonitoring() || !mesg.isOutbound()) {
                    if (mesg.isRequest() && !stype.isServiceProvider()) {
                        f_process = false;
                    } else if (!mesg.isRequest() && !stype.isServiceClient()) {
                        f_process = false;
                    }
                } else if (mesg.isRequest() && !stype.isServiceClient()) {
                    f_process = false;
                } else if (!mesg.isRequest() && !stype.isServiceProvider()) {
                    f_process = false;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Process service type '" + stype.getFullyQualifiedName() + "' for message '" + mesg + "' = " + f_process);
                }
                if (!f_process) continue;
                List list = stype.getOperationDefinitions(mesg.getOperationName(), reqType, respType);
                if (list.size() == 0 && reqType == null && respType != null) {
                    list = stype.getNotificationDefinitions(mesg.getOperationName(), respType);
                }
                if (list.size() <= 0) continue;
                ret = stype;
                ++defns;
            }
            if (defns > 1) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Two many service types have the same operation");
                }
                ret = null;
            }
        } else {
            ret = sd.getServiceType(mesg.getServiceType());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Service type for '" + sd + "' and message '" + mesg + "' = " + ret);
        }
        return ret;
    }

    public static MessageDefinition getMessageDefinition(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        MessageDefinition ret = null;
        OperationDefinition op = MessageUtil.getOperationDefinition(sd, mesg, config);
        if (op != null) {
            if (!NamesUtil.isSet((String)mesg.getFaultName())) {
                if (mesg.isRequest()) {
                    ret = op.getRequest();
                } else {
                    ret = op.getResponse();
                    if (ret == null) {
                        ret = op.getNotification();
                    }
                }
            } else {
                ret = op.getFault(mesg.getFaultName());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Message definition for '" + sd + "' and message '" + mesg + "' = " + ret);
        }
        return ret;
    }

    public static InformationType getInformationType(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        InformationType ret = null;
        if (mesg.getType() == null) {
            MessageDefinition md = MessageUtil.getMessageDefinition(sd, mesg, config);
            if (md != null) {
                ret = md.getInformationType();
            }
        } else {
            Iterator iter = sd.getInformationTypes().iterator();
            while (ret == null && iter.hasNext()) {
                InformationType it = (InformationType)iter.next();
                if (it.getFullyQualifiedType() != null && it.getFullyQualifiedType().equals(mesg.getType())) {
                    ret = it;
                    continue;
                }
                if (it.getFullyQualifiedElement() == null || !it.getFullyQualifiedElement().equals(mesg.getType())) continue;
                ret = it;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Message definition for '" + sd + "' and message '" + mesg + "' = " + ret);
        }
        return ret;
    }

    public static OperationDefinition getOperationDefinition(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        OperationDefinition ret = null;
        ServiceType st = MessageUtil.getServiceType(sd, mesg, config);
        if (st != null) {
            String reqType = mesg.isRequest() ? mesg.getType() : null;
            String respType = mesg.isRequest() ? null : mesg.getType();
            List ops = st.getOperationDefinitions(mesg.getOperationName(), reqType, respType);
            if (ops.size() == 0 && reqType == null && respType != null) {
                ops = st.getNotificationDefinitions(mesg.getOperationName(), respType);
            }
            if (ops.size() == 1) {
                ret = (OperationDefinition)ops.get(0);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Single operation definition not found for '" + mesg + "' on service type '" + st + "': returned " + ops.size());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Operation definition for '" + sd + "' and message '" + mesg + "' = " + ret);
        }
        return ret;
    }

    public static boolean canInitiateSession(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        boolean ret = false;
        if (mesg.isRPCStyle()) {
            MessageDefinition md = MessageUtil.getMessageDefinition(sd, mesg, config);
            if (md != null && md.getCanInitiateSession()) {
                ret = true;
            } else if (sd.getStateless() == Boolean.TRUE) {
                ret = true;
            }
        } else {
            InformationType infoType = null;
            Iterator iter = sd.getInformationTypes().iterator();
            while (iter.hasNext() && infoType == null) {
                infoType = (InformationType)iter.next();
                String fqn = infoType.getFullyQualifiedElement();
                if (fqn != null && fqn.equals(mesg.getType()) || (fqn = infoType.getFullyQualifiedType()) != null && fqn.equals(mesg.getType())) continue;
                infoType = null;
            }
            if (infoType != null && infoType.getCanInitiateSession()) {
                ret = true;
            }
        }
        return ret;
    }

    public static List<Identity> deriveIdentity(ServiceDescription sd, Message mesg, SessionConfiguration config) {
        InformationType it = MessageUtil.getInformationType(sd, mesg, config);
        return MessageUtil.deriveIdentity(sd, mesg, it, config);
    }

    public static List<Identity> deriveIdentity(ServiceDescription sd, Message mesg, InformationType it, SessionConfiguration config) {
        Vector<Identity> ret = new Vector<Identity>();
        if (it != null) {
            List ids = it.getIdentityReferences();
            int i = 0;
            while (i < ids.size()) {
                org.pi4soa.service.behavior.Identity id = (org.pi4soa.service.behavior.Identity)ids.get(i);
                Identity identity = MessageUtil.deriveIdentity(id, it, mesg, config);
                if (identity != null && !ret.contains(identity)) {
                    ret.add(identity);
                }
                ++i;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Derived identitites for '" + sd + "' and message '" + mesg + "': number=" + (ret == null ? 0 : ret.size()));
        }
        return ret;
    }

    public static Identity deriveIdentity(org.pi4soa.service.behavior.Identity id, InformationType infoType, Message mesg, SessionConfiguration config) {
        Identity ret = null;
        int len = id.getTokens().size();
        String[] tokens = new String[len];
        Object[] values = new Object[len];
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Derive identity: " + id.getName() + " on info type " + infoType.getName());
        }
        int i = 0;
        while (i < len) {
            String tokenName = (String)id.getTokens().get(i);
            int j = 0;
            while (tokens[i] == null && j < infoType.getTokenLocators().size()) {
                TokenLocator locator = (TokenLocator)infoType.getTokenLocators().get(j);
                if (locator.getName().equals(tokenName)) {
                    Object value = MessageUtil.findTokenValue(locator, mesg, config);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Token(" + i + ") '" + tokenName + "' locator '" + locator.getQuery() + "' = value '" + value + "'");
                    }
                    if (value instanceof String) {
                        if (((String)value).trim().length() == 0) {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Clearing value due to empty string value");
                            }
                            value = null;
                        }
                    } else if (value instanceof List) {
                        List list = (List)value;
                        if (list.size() > 0) {
                            int k = 0;
                            while (value != null && k < list.size()) {
                                if (list.get(k) instanceof String && ((String)list.get(k)).trim().length() == 0) {
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.finest("Clearing value due to empty string value in list");
                                    }
                                    value = null;
                                }
                                ++k;
                            }
                        } else {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Clearing value due to empty list");
                            }
                            value = null;
                        }
                    }
                    if (value != null) {
                        tokens[i] = tokenName;
                        values[i] = value;
                    }
                }
                ++j;
            }
            ++i;
        }
        boolean f_allSet = true;
        int i2 = 0;
        while (i2 < values.length) {
            if (values[i2] == null) {
                f_allSet = false;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Token '" + tokens[i2] + "' has a NULL value");
                }
            }
            ++i2;
        }
        if (f_allSet) {
            ret = new Identity(id.getIdentityName(), tokens, values);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Derived identity for '" + id + "' and message '" + mesg + "' = " + ret);
        }
        return ret;
    }

    public static Object findTokenValue(TokenLocator locator, Message mesg, SessionConfiguration config) {
        Object ret = null;
        Serializable value = null;
        if (mesg.isMultiPart()) {
            if (locator.getPart() != null && locator.getPart().trim().length() > 0) {
                try {
                    value = mesg.getMultiPartValue(locator.getPart());
                }
                catch (ServiceException serviceException) {}
                if (value == null) {
                    logger.severe("Unknown part '" + locator.getPart() + "' in message");
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Using part '" + locator.getPart() + "': " + value);
                }
            } else {
                Map multipart = (Map)((Object)mesg.getValue());
                if (multipart.size() == 1) {
                    value = multipart.values().iterator().next();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Extracted single part: " + value);
                    }
                } else {
                    logger.severe("Part not specified for multipart message");
                }
            }
        } else {
            value = mesg.getValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Using value: " + value);
            }
        }
        if (value != null) {
            if (locator.getQuery() != null && locator.getQuery().trim().length() > 0 && !locator.getQuery().equals("/")) {
                XPathEvaluator evaluator = config.getXPathEvaluator();
                List list = evaluator.selectNodes((Object)value, locator.getQuery(), MessageUtil.getXMLPrefixResolver(locator));
                if (list != null) {
                    if (list.size() == 1) {
                        ret = MessageUtil.processValue(evaluator.asString(list.get(0)));
                    } else {
                        ret = new Vector();
                        int i = 0;
                        while (i < list.size()) {
                            ((Vector)ret).add(MessageUtil.processValue(evaluator.asString(list.get(i))));
                            ++i;
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Token query '" + locator.getQuery() + "' returned '" + ret + "'");
                }
            } else {
                ret = value.toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Token with no query returned '" + ret + "'");
                }
            }
        }
        return ret;
    }

    protected static String processValue(String val) {
        StringBuffer ret = new StringBuffer();
        boolean f_space = false;
        int i = 0;
        while (i < val.length()) {
            char ch = val.charAt(i);
            if (!Character.isWhitespace(ch)) {
                ret.append(ch);
                f_space = false;
            } else if (ch == ' ' && !f_space) {
                ret.append(ch);
                f_space = true;
            }
            ++i;
        }
        return ret.toString();
    }

    protected static XMLPrefixResolver getXMLPrefixResolver(Object obj) {
        XMLPrefixResolver ret = null;
        if (obj instanceof XMLPrefixResolver) {
            ret = (XMLPrefixResolver)obj;
        }
        return ret;
    }
}

