/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.timer;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.Identity;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.timer.TimeoutEntry;
import org.pi4soa.service.timer.TimeoutHandler;
import org.pi4soa.service.timer.TimeoutManager;
import org.pi4soa.service.timer.TimeoutManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTimeoutManager
implements TimeoutManager {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.timer");
    private List<TimeoutHandler> m_handlers = new Vector<TimeoutHandler>();
    private boolean m_closed = false;
    private ServiceRepository m_serviceRepository = null;
    public static final long DEFAULT_POLLING_CYCLE = 60000L;

    @Override
    public void initialize(ServiceRepository rep) {
        this.m_serviceRepository = rep;
    }

    public ServiceRepository getServiceRepository() {
        return this.m_serviceRepository;
    }

    @Override
    public void register(Set<Identity> ids, SessionId subSessionId, String behaviorElementId, String expr, long timeframe) throws TimeoutManagerException {
        TimeoutEntry te = new TimeoutEntry(ids, subSessionId, behaviorElementId, expr, timeframe);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registering timeout for sub-session '" + subSessionId + "' behaviorElement '" + behaviorElementId + "' expression '" + expr + "' timeframe=" + timeframe);
        }
        this.addToQueue(te);
    }

    @Override
    public void unregister(Set<Identity> ids, SessionId subSessionId, String behaviorElementId) throws TimeoutManagerException {
        boolean removed = false;
        TimeoutEntry te = new TimeoutEntry(ids, subSessionId, behaviorElementId, null, 0L);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unregistering timeout for sub-session '" + subSessionId + "' behaviorElement '" + behaviorElementId + "'");
        }
        do {
            removed = this.removeFromQueue(te);
        } while (behaviorElementId == null && removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeoutHandler(TimeoutHandler handler) {
        List<TimeoutHandler> list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeoutHandler(TimeoutHandler handler) {
        List<TimeoutHandler> list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExpiredEntry(TimeoutEntry te) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Dispatching timeout for sub-session '" + te.getSubSessionId() + "' behaviorElement '" + te.getBehaviorElementId() + "' expression '" + te.getExpression() + "'");
        }
        List<TimeoutHandler> list = this.m_handlers;
        synchronized (list) {
            int i = 0;
            while (i < this.m_handlers.size()) {
                TimeoutHandler handler = this.m_handlers.get(i);
                handler.timeoutExpired(te.getIdentities(), te.getSubSessionId(), te.getBehaviorElementId(), te.getExpression());
                ++i;
            }
        }
    }

    @Override
    public void close() throws TimeoutManagerException {
        this.m_closed = true;
        this.closeTimeoutQueue();
    }

    protected boolean isClosed() {
        return this.m_closed;
    }

    @Override
    public Date getCurrentDateTime() {
        return new Date();
    }

    @Override
    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected abstract void addToQueue(TimeoutEntry var1) throws TimeoutManagerException;

    protected abstract boolean removeFromQueue(TimeoutEntry var1) throws TimeoutManagerException;

    protected abstract void closeTimeoutQueue() throws TimeoutManagerException;
}

