/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.timer;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.timer.AbstractTimeoutManager;
import org.pi4soa.service.timer.TimeoutEntry;
import org.pi4soa.service.timer.TimeoutManager;
import org.pi4soa.service.timer.TimeoutManagerException;

public class DefaultTimeoutManager
extends AbstractTimeoutManager
implements TimeoutManager,
Runnable {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.timer");
    private List<TimeoutEntry> m_queue = new Vector<TimeoutEntry>();
    public static final long DEFAULT_POLLING_CYCLE = 60000L;

    public void initialize(ServiceRepository rep) {
        super.initialize(rep);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    public void run() {
        while (!this.isClosed()) {
            this.pollTimeoutQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPendingTimeouts() {
        int ret = 0;
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            ret = this.m_queue.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollTimeoutQueue() {
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            long timeToNextPoll = this.evaluateTimeoutEntries();
            if (timeToNextPoll > 0L) {
                try {
                    this.m_queue.wait(timeToNextPoll);
                }
                catch (Exception e) {
                    logger.warning("Failed to wait for queue polling cycle: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long evaluateTimeoutEntries() {
        long timeToNextPoll = 60000L;
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            if (this.m_queue.size() > 0) {
                long diff;
                TimeoutEntry te = this.m_queue.get(0);
                if (te.hasExpired()) {
                    this.m_queue.remove(0);
                    this.handleExpiredEntry(te);
                    te = null;
                    if (this.m_queue.size() > 0) {
                        te = this.m_queue.get(0);
                    }
                }
                if (te != null && (diff = te.getTimeRemaining()) < timeToNextPoll) {
                    timeToNextPoll = diff;
                }
            }
        }
        return timeToNextPoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToQueue(TimeoutEntry te) throws TimeoutManagerException {
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            int pos = -1;
            int i = 0;
            while (pos == -1 && i < this.m_queue.size()) {
                TimeoutEntry queued = this.m_queue.get(i);
                if (!te.isAfter(queued)) {
                    pos = i;
                }
                ++i;
            }
            if (pos == -1) {
                pos = this.m_queue.size();
            }
            this.m_queue.add(pos, te);
            if (pos == 0) {
                this.m_queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromQueue(TimeoutEntry te) throws TimeoutManagerException {
        boolean ret = false;
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            int pos = this.m_queue.indexOf(te);
            logger.info("Remove timeout entry (pos=" + pos + "): " + te);
            if (pos != -1) {
                this.m_queue.remove(pos);
                ret = true;
                if (pos == 0) {
                    this.m_queue.notifyAll();
                }
            }
        }
        return ret;
    }

    protected void closeTimeoutQueue() throws TimeoutManagerException {
        this.m_queue.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceTime(long milliseconds) throws TimeoutManagerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Advancing timer by " + milliseconds + " ms");
        }
        List<TimeoutEntry> list = this.m_queue;
        synchronized (list) {
            int i = 0;
            while (i < this.m_queue.size()) {
                TimeoutEntry te = this.m_queue.get(i);
                te.advanceTime(milliseconds);
                ++i;
            }
            this.evaluateTimeoutEntries();
        }
    }
}

