/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.timer;

import java.io.Serializable;
import java.util.Set;
import org.pi4soa.service.Identity;
import org.pi4soa.service.session.SessionId;
import org.pi4soa.service.util.IdentityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutEntry
implements Serializable {
    private static final long serialVersionUID = -3276123996702120858L;
    private Long m_internalId;
    private Set<Identity> m_ids = null;
    private SessionId m_subSessionId = null;
    private String m_behaviorElementId = null;
    private String m_expression = null;
    private long m_timeout = 0L;
    private Serializable m_data = null;
    public static final long MAX_DURATION_TIMEFRAME = 63072000000L;

    protected TimeoutEntry() {
    }

    public TimeoutEntry(Set<Identity> ids, SessionId subSessionId, String behaviorElementId, String expr, long timeframe) {
        this.m_ids = ids;
        this.m_subSessionId = new SessionId(subSessionId);
        this.m_behaviorElementId = behaviorElementId;
        this.m_expression = expr;
        this.m_timeout = timeframe;
        if (this.m_timeout <= 63072000000L) {
            this.m_timeout += System.currentTimeMillis();
        }
    }

    protected Long getInternalId() {
        return this.m_internalId;
    }

    protected void setInternalId(Long id) {
        this.m_internalId = id;
    }

    public Set<Identity> getIdentities() {
        return this.m_ids;
    }

    protected void setIdentities(Set<Identity> ids) {
        this.m_ids = ids;
    }

    public SessionId getSubSessionId() {
        return this.m_subSessionId;
    }

    protected void setSubSessionId(SessionId id) {
        this.m_subSessionId = id;
    }

    public String getBehaviorElementId() {
        return this.m_behaviorElementId;
    }

    protected void setBehaviorElementId(String id) {
        this.m_behaviorElementId = id;
    }

    public String getExpression() {
        return this.m_expression;
    }

    protected void setExpression(String expr) {
        this.m_expression = expr;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    protected void setTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public void setData(Serializable data) {
        this.m_data = data;
    }

    public Serializable getData() {
        return this.m_data;
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.m_timeout;
    }

    public long getTimeRemaining() {
        return this.m_timeout - System.currentTimeMillis();
    }

    public boolean isAfter(TimeoutEntry te) {
        boolean ret = false;
        if (te != null && this.getTimeout() > te.getTimeout()) {
            ret = true;
        }
        return ret;
    }

    public void advanceTime(long milliseconds) {
        this.m_timeout -= milliseconds;
    }

    public int hashCode() {
        int ret = 0;
        ret = this.m_behaviorElementId.hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof TimeoutEntry) {
            TimeoutEntry te = (TimeoutEntry)obj;
            boolean f_exprMatch = true;
            if (this.m_expression != null && te.getExpression() != null) {
                f_exprMatch = this.m_expression.equals(te.getExpression());
            }
            if (f_exprMatch && this.m_subSessionId.equals(te.getSubSessionId()) && (this.m_behaviorElementId == null || te.getBehaviorElementId() == null || this.m_behaviorElementId.equals(te.getBehaviorElementId())) && IdentityUtil.isSameSession(this.getIdentities(), te.getIdentities())) {
                ret = true;
            }
        }
        return ret;
    }

    public String toString() {
        return "timeout[session=" + this.m_subSessionId + " behaviorElement=" + this.m_behaviorElementId + " expression=" + this.m_expression + " timeout=" + this.m_timeout + " remaining=" + this.getTimeRemaining() + "]";
    }
}

