/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.timer.hibernate;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.pi4soa.service.repository.ServiceRepository;
import org.pi4soa.service.session.hibernate.HibernateUtil;
import org.pi4soa.service.timer.AbstractTimeoutManager;
import org.pi4soa.service.timer.TimeoutEntry;
import org.pi4soa.service.timer.TimeoutManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTimeoutManager
extends AbstractTimeoutManager
implements Runnable {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.timer.hibernate");
    public static final long DEFAULT_POLLING_CYCLE = 60000L;

    @Override
    public void initialize(ServiceRepository rep) {
        super.initialize(rep);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void run() {
        while (!this.isClosed()) {
            try {
                this.pollTimeoutQueue();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to poll timeout queue", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollTimeoutQueue() throws TimeoutManagerException {
        try {
            Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            if (!hibernate.getTransaction().isActive()) {
                hibernate.beginTransaction();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Begin txn: " + hibernate.getTransaction());
                }
            }
            HibernateTimeoutManager hibernateTimeoutManager = this;
            synchronized (hibernateTimeoutManager) {
                long timeToNextPoll = this.evaluateTimeoutEntries();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Commit txn: " + hibernate.getTransaction());
                }
                hibernate.getTransaction().commit();
                if (timeToNextPoll > 0L) {
                    try {
                        this.wait(timeToNextPoll);
                    }
                    catch (Exception e) {
                        logger.warning("Failed to wait for queue polling cycle: " + e);
                    }
                }
            }
        }
        catch (HibernateException he) {
            throw new TimeoutManagerException("Failed poll timeout queue", he);
        }
    }

    protected long evaluateTimeoutEntries() throws TimeoutManagerException {
        long timeToNextPoll = 60000L;
        try {
            TimeoutEntry cur;
            Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            List entries = hibernate.createQuery("from " + TimeoutEntry.class.getName() + " te order by te.timeout asc").list();
            TimeoutEntry te = null;
            int pos = 0;
            while (te == null && pos < entries.size()) {
                cur = (TimeoutEntry)entries.get(pos);
                if (cur.getSubSessionId() != null && cur.getSubSessionId().getServiceDescriptionName() != null && this.getServiceRepository().getServiceDescription(cur.getSubSessionId().getServiceDescriptionName(), null) != null) {
                    te = cur;
                }
                ++pos;
            }
            if (te != null) {
                long diff;
                if (te.hasExpired()) {
                    hibernate.delete((Object)te);
                    this.handleExpiredEntry(te);
                    te = null;
                    while (te == null && pos < entries.size()) {
                        cur = (TimeoutEntry)entries.get(pos);
                        if (cur.getSubSessionId() != null && cur.getSubSessionId().getServiceDescriptionName() != null && this.getServiceRepository().getServiceDescription(cur.getSubSessionId().getServiceDescriptionName(), null) != null) {
                            te = cur;
                        }
                        ++pos;
                    }
                }
                if (te != null && (diff = te.getTimeRemaining()) < timeToNextPoll) {
                    timeToNextPoll = diff;
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                this.dbDiagnostics();
            }
        }
        catch (HibernateException he) {
            throw new TimeoutManagerException("Failed to evaluate timeout entries", he);
        }
        return timeToNextPoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addToQueue(TimeoutEntry te) throws TimeoutManagerException {
        try {
            Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            hibernate.save((Object)te);
        }
        catch (HibernateException he) {
            throw new TimeoutManagerException("Failed to add queue entry '" + te + "'", he);
        }
        HibernateTimeoutManager hibernateTimeoutManager = this;
        synchronized (hibernateTimeoutManager) {
            this.notifyAll();
        }
    }

    @Override
    protected boolean removeFromQueue(TimeoutEntry te) throws TimeoutManagerException {
        boolean ret = false;
        try {
            Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            List entries = hibernate.createQuery("from " + TimeoutEntry.class.getName()).list();
            boolean f_end = false;
            int i = 0;
            while (!f_end && i < entries.size()) {
                TimeoutEntry entry = (TimeoutEntry)entries.get(i);
                if (entry.equals(te)) {
                    hibernate.delete((Object)entry);
                    if (te.getBehaviorElementId() != null) {
                        f_end = true;
                    }
                }
                ++i;
            }
        }
        catch (HibernateException he) {
            throw new TimeoutManagerException("Failed to remove queue entry '" + te + "'", he);
        }
        return ret;
    }

    @Override
    protected void closeTimeoutQueue() throws TimeoutManagerException {
    }

    @Override
    public void advanceTime(long milliseconds) throws TimeoutManagerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Advancing timer by " + milliseconds + " ms");
        }
        try {
            Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
            boolean localtxn = false;
            if (!hibernate.getTransaction().isActive()) {
                hibernate.beginTransaction();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Begin txn: " + hibernate.getTransaction());
                }
                localtxn = true;
            }
            List entries = hibernate.createQuery("from " + TimeoutEntry.class.getName()).list();
            int pos = 0;
            while (pos < entries.size()) {
                TimeoutEntry te = (TimeoutEntry)entries.get(pos);
                if (this.getServiceRepository().getServiceDescription(te.getSubSessionId().getServiceDescriptionName(), null) != null) {
                    te.advanceTime(milliseconds);
                }
                ++pos;
            }
            this.evaluateTimeoutEntries();
            if (localtxn && (hibernate = HibernateUtil.getSessionFactory().getCurrentSession()).getTransaction().isActive()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(Thread.currentThread() + ": Commit txn: " + hibernate.getTransaction());
                }
                hibernate.getTransaction().commit();
            }
        }
        catch (HibernateException he) {
            throw new TimeoutManagerException("Failed to evaluate timeout entries", he);
        }
    }

    private void dbDiagnostics() {
        logger.finest(Thread.currentThread() + ": ------------------ Timer DB Diagnostics Started ---------------------");
        Session hibernate = HibernateUtil.getSessionFactory().getCurrentSession();
        boolean localTxn = false;
        if (!hibernate.getTransaction().isActive()) {
            hibernate.beginTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(Thread.currentThread() + ": Begin txn: " + hibernate.getTransaction());
            }
            localTxn = true;
        }
        this.countEntries((org.hibernate.Session)hibernate, TimeoutEntry.class);
        if (localTxn) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(Thread.currentThread() + ": Rollback txn: " + hibernate.getTransaction());
            }
            hibernate.getTransaction().rollback();
        }
        logger.finest(Thread.currentThread() + ": ------------------ Timer DB Diagnostics Finished ---------------------");
    }

    private void countEntries(org.hibernate.Session session, Class<?> cls) {
        List<?> list = this.getInstances(session, cls);
        logger.finest("Number of entries of type " + cls.getName() + ": " + list.size());
    }

    private List<?> getInstances(org.hibernate.Session session, Class<?> cls) {
        return session.createQuery("from " + cls.getName()).list();
    }
}

