/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.service.tracker;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.pi4soa.service.Channel;
import org.pi4soa.service.Identity;
import org.pi4soa.service.Message;
import org.pi4soa.service.ServiceException;
import org.pi4soa.service.behavior.MessageClassification;
import org.pi4soa.service.behavior.MessageDefinition;
import org.pi4soa.service.behavior.Receive;
import org.pi4soa.service.behavior.Send;
import org.pi4soa.service.behavior.ServiceDescription;
import org.pi4soa.service.session.Session;
import org.pi4soa.service.tracker.ServiceTracker;
import org.w3c.dom.Node;

public abstract class AbstractServiceTracker
implements ServiceTracker {
    private static Logger logger = Logger.getLogger("org.pi4soa.service.tracker");
    private boolean m_recordMessagePayload = false;
    public static final String RECORD_MESSAGE_PAYLOAD = "pi4soa.tracker.messagePayload";
    public static final String INFO = "info";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String MESSAGE_NODE = "message";
    public static final String DETAILS_NODE = "details";
    public static final String OPERATION_ATTR = "operation";
    public static final String FAULT_ATTR = "fault";
    public static final String NAME_ATTR = "name";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String TYPE_ATTR = "type";
    public static final String MESSAGE_TYPE_ATTR = "messageType";
    public static final String SERVICE_TYPE_ATTR = "serviceType";
    public static final String EXCEPTION_NODE = "exception";
    public static final String SERVICE_INSTANCE_ID_ATTR = "serviceInstanceId";
    public static final String SESSION_ID_ATTR = "sessionId";
    public static final String PARENT_SESSION_ID_ATTR = "parentSessionId";
    public static final String VERSION_ATTR = "version";
    public static final String FAULT_RPC_MESSAGE_TYPE = "fault";
    public static final String RESPONSE_RPC_MESSAGE_TYPE = "response";
    public static final String REQUEST_RPC_MESSAGE_TYPE = "request";
    public static final String MESSAGE_STYLE_MESSAGE_TYPE = "message";
    public static final String SESSION_IDENTITY_NODE = "sessionIdentity";
    public static final String CHANNEL_IDENTITY_NODE = "channelIdentity";
    public static final String IDENTITY_NODE = "identity";
    public static final String PRIMARY_IDENTITIES_NODE = "primaryIdentities";
    public static final String ENDPOINT_NODE = "endpoint";
    public static final String CHANNEL_NODE = "channel";
    public static final String VALUE_NODE = "value";

    public void initialize() throws ServiceException {
    }

    public void setRecordMessagePayload(Boolean val) {
        this.m_recordMessagePayload = val != null ? val : false;
    }

    public void serviceStarted(ServiceDescription service, Session session) {
        String version = "";
        if (service.getVersion() != null) {
            version = "version=\"" + service.getVersion() + "\" ";
        }
        String xml = "<sd:serviceStarted name=\"" + service.getFullyQualifiedName() + "\" " + version + SERVICE_INSTANCE_ID_ATTR + "=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" />";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void serviceFinished(ServiceDescription service, Session session) {
        String version = "";
        if (service.getVersion() != null) {
            version = "version=\"" + service.getVersion() + "\" ";
        }
        String xml = "<sd:serviceFinished name=\"" + service.getFullyQualifiedName() + "\" " + version + SERVICE_INSTANCE_ID_ATTR + "=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" />";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void subSessionStarted(Session parent, Session session) {
        String xml = "<sd:subSessionStarted serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + PARENT_SESSION_ID_ATTR + "=\"" + this.getSessionId(parent) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" />";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void subSessionFinished(Session parent, Session session) {
        String xml = "<sd:subSessionFinished serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + PARENT_SESSION_ID_ATTR + "=\"" + this.getSessionId(parent) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" />";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void sentMessage(Send activity, Session session, Channel channel, Message mesg) {
        String channelText = this.getChannelText(channel);
        String messageText = this.getMessageText(mesg, activity.getMessageDefinition());
        String xml = "<sd:sentMessage serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" >" + messageText + channelText + "</sd:" + "sentMessage" + ">";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void sentMessage(MessageDefinition defn, Message mesg) {
        String messageText = this.getMessageText(mesg, defn);
        String serviceName = this.getServiceName(defn);
        String xml = "<sd:sentMessage timestamp=\"" + System.currentTimeMillis() + "\" >" + messageText + "</sd:" + "sentMessage" + ">";
        this.record(serviceName, null, xml, INFO, null);
    }

    public void receivedMessage(Receive activity, Session session, Channel channel, Message mesg) {
        String channelText = this.getChannelText(channel);
        String messageText = this.getMessageText(mesg, activity.getMessageDefinition());
        String xml = "<sd:receivedMessage serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" >" + messageText + channelText + "</sd:" + "receivedMessage" + ">";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void receivedMessage(MessageDefinition defn, Message mesg) {
        String messageText = this.getMessageText(mesg, defn);
        String serviceName = this.getServiceName(defn);
        String xml = "<sd:receivedMessage timestamp=\"" + System.currentTimeMillis() + "\" >" + messageText + "</sd:" + "receivedMessage" + ">";
        this.record(serviceName, null, xml, INFO, null);
    }

    public void unexpectedMessage(ServiceDescription sdesc, Session session, Message mesg, String reason) {
        String messageText = this.getMessageText(mesg, null);
        reason = this.processAttributeContents(reason);
        String xml = "<sd:unexpectedMessage serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" ><sd:" + DETAILS_NODE + ">" + reason + "</sd:" + DETAILS_NODE + ">" + messageText + "</sd:" + "unexpectedMessage" + ">";
        String serviceName = null;
        serviceName = sdesc != null ? sdesc.getFullyQualifiedName() : this.getServiceName(session);
        String serviceVersion = null;
        if (sdesc != null) {
            serviceVersion = sdesc.getVersion();
        }
        this.record(serviceName, serviceVersion, session, mesg, xml, ERROR, null);
    }

    public void unhandledException(Session session, String excType) {
        String xml = "<sd:unhandledException serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" ><sd:" + DETAILS_NODE + ">" + excType + "</sd:" + DETAILS_NODE + "></sd:" + "unhandledException" + ">";
        this.record(this.getServiceName(session), session, xml, ERROR, null);
    }

    public void information(Session session, String details) {
        String xml = "<sd:information serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" ><sd:" + DETAILS_NODE + ">" + XMLUtils.encodeXMLString((String)details) + "</sd:" + DETAILS_NODE + "></sd:" + "information" + ">";
        this.record(this.getServiceName(session), session, xml, INFO, null);
    }

    public void warning(Session session, String details, Throwable exc) {
        String excText = "";
        if (exc != null) {
            try {
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter(s);
                exc.printStackTrace(p);
                p.close();
                s.close();
                excText = "<sd:exception>" + s.toString() + "</sd:" + EXCEPTION_NODE + ">";
            }
            catch (Exception e) {
                logger.severe("Failed to record exception stack trace: " + e);
                excText = "<sd:exception>" + exc.getLocalizedMessage() + "</sd:" + EXCEPTION_NODE + ">";
            }
        }
        String xml = "<sd:warning serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" ><sd:" + DETAILS_NODE + ">" + XMLUtils.encodeXMLString((String)details) + "</sd:" + DETAILS_NODE + ">" + excText + "</sd:" + WARNING + ">";
        this.record(this.getServiceName(session), session, xml, WARNING, exc);
    }

    public void error(Session session, String details, Throwable exc) {
        String excText = "";
        if (exc != null) {
            try {
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter(s);
                exc.printStackTrace(p);
                p.close();
                s.close();
                excText = "<sd:exception>" + s.toString() + "</sd:" + EXCEPTION_NODE + ">";
            }
            catch (Exception e) {
                logger.severe("Failed to record exception stack trace: " + e);
                excText = "<sd:exception>" + exc.getLocalizedMessage() + "</sd:" + EXCEPTION_NODE + ">";
            }
        }
        String xml = "<sd:error serviceInstanceId=\"" + this.getServiceInstanceId(session) + "\" " + SESSION_ID_ATTR + "=\"" + this.getSessionId(session) + "\" " + TIMESTAMP_ATTR + "=\"" + System.currentTimeMillis() + "\" ><sd:" + DETAILS_NODE + ">" + XMLUtils.encodeXMLString((String)details) + "</sd:" + DETAILS_NODE + ">" + excText + "</sd:" + ERROR + ">";
        this.record(this.getServiceName(session), session, xml, ERROR, exc);
    }

    public void close() throws ServiceException {
    }

    protected String getSessionId(Session session) {
        String ret = null;
        if (session != null) {
            ret = session.getId().getSessionId();
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    protected boolean isIdExpanded() {
        return true;
    }

    protected String getServiceInstanceId(Session session) {
        String ret = null;
        if (session != null) {
            ret = this.isIdExpanded() ? String.valueOf(session.getId().getServiceDescriptionName()) + "/" + session.getId().getServiceInstanceId() : session.getId().getServiceInstanceId();
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    protected String getServiceName(Session session) {
        String ret = "";
        if (session != null && session.getId() != null) {
            ret = session.getId().getServiceDescriptionName();
        }
        return ret;
    }

    protected String getServiceName(MessageDefinition defn) {
        String ret = "";
        if (defn != null && defn.getServiceDescription() != null) {
            ret = defn.getServiceDescription().getFullyQualifiedName();
        }
        return ret;
    }

    protected String getSessionIdentityText(Session session) {
        return this.getSessionIdentityText(session, null);
    }

    public String getSessionIdentityText(Session session, Message mesg) {
        StringBuffer identities = new StringBuffer();
        if (session != null && session.getSessionIdentity() != null) {
            identities.append("<sd:sessionIdentity><sd:identity name=\"" + session.getSessionIdentity().getName() + "\" >" + XMLUtils.encodeXMLString((String)session.getSessionIdentity().getFullId()) + "</sd:" + IDENTITY_NODE + ">" + "</sd:" + SESSION_IDENTITY_NODE + ">");
        }
        Iterator<Identity> ids = null;
        if (session != null) {
            ids = session.getPrimaryIdentities().iterator();
        }
        if (!(ids != null && ids.hasNext() || mesg == null || mesg.getMessageIdentities() == null)) {
            ids = mesg.getMessageIdentities().iterator();
        }
        if (ids != null && ids.hasNext()) {
            identities.append("<sd:primaryIdentities>");
            while (ids.hasNext()) {
                Identity cur = ids.next();
                identities.append("<sd:identity name=\"" + cur.getName() + "\" >");
                identities.append(XMLUtils.encodeXMLString((String)cur.getFullId()));
                identities.append("</sd:identity>");
            }
            identities.append("</sd:primaryIdentities>");
        }
        return identities.toString();
    }

    public String getMessageText(Message mesg, MessageDefinition defn) {
        String type = null;
        if (defn == null) {
            String string = type = mesg.isRequest() ? REQUEST_RPC_MESSAGE_TYPE : RESPONSE_RPC_MESSAGE_TYPE;
            if (!mesg.isRPCStyle()) {
                type = "message";
            }
        } else {
            String string = type = defn.getClassification() == MessageClassification.REQUEST ? REQUEST_RPC_MESSAGE_TYPE : RESPONSE_RPC_MESSAGE_TYPE;
        }
        if (NamesUtil.isSet((String)mesg.getFaultName())) {
            type = "fault";
        }
        return this.getMessageTextForType(mesg, type);
    }

    protected String getMessageTextForType(Message mesg, String type) {
        String serviceType;
        String ret = null;
        String fault = "";
        String messageType = "";
        String identities = "";
        String valueText = this.getMessagePayload(mesg);
        String endpoint = "";
        if (NamesUtil.isSet((String)mesg.getFaultName())) {
            fault = "fault=\"" + mesg.getFaultName() + "\" ";
        }
        if (NamesUtil.isSet((String)mesg.getType())) {
            messageType = "messageType=\"" + mesg.getType() + "\" ";
        }
        if (mesg.getSessionIdentity() != null) {
            identities = "<sd:sessionIdentity><sd:identity name=\"" + mesg.getSessionIdentity().getName() + "\" >" + mesg.getSessionIdentity().getFullId() + "</sd:" + IDENTITY_NODE + ">" + "</sd:" + SESSION_IDENTITY_NODE + ">";
            if (mesg.getChannelIdentity() != null) {
                identities = String.valueOf(identities) + "<sd:channelIdentity><sd:identity name=\"" + mesg.getChannelIdentity().getName() + "\" >" + mesg.getChannelIdentity().getFullId() + "</sd:" + IDENTITY_NODE + ">" + "</sd:" + CHANNEL_IDENTITY_NODE + ">";
            }
        } else if (mesg.getMessageIdentities() != null && mesg.getMessageIdentities().size() > 0) {
            identities = String.valueOf(identities) + "<sd:primaryIdentities>";
            int i = 0;
            while (i < mesg.getMessageIdentities().size()) {
                Identity id = mesg.getMessageIdentities().get(i);
                identities = String.valueOf(identities) + "<sd:identity name=\"" + id.getName() + "\" >";
                identities = String.valueOf(identities) + id.getFullId();
                identities = String.valueOf(identities) + "</sd:identity>";
                ++i;
            }
            identities = String.valueOf(identities) + "</sd:primaryIdentities>";
        }
        if (mesg.getServiceEndpoint() != null) {
            endpoint = mesg.getServiceEndpoint().toText(null);
        }
        if ((serviceType = mesg.getServiceType()) == null) {
            serviceType = "";
        }
        ret = "<sd:message operation=\"" + (mesg.getOperationName() == null ? "" : mesg.getOperationName()) + "\" " + TYPE_ATTR + "=\"" + type + "\" " + fault + messageType + SERVICE_TYPE_ATTR + "=\"" + serviceType + "\" ><sd:" + ENDPOINT_NODE + ">" + endpoint + "</sd:" + ENDPOINT_NODE + ">" + identities + valueText + "</sd:" + "message" + ">";
        return ret;
    }

    protected String getMessagePayload(Message mesg) {
        String ret = "";
        if (this.m_recordMessagePayload) {
            Object value = mesg.getValue();
            if (mesg.isMultiPart() && ((Map)value).size() == 1) {
                value = ((Map)value).values().iterator().next();
            }
            if (value instanceof Node) {
                try {
                    value = XMLUtils.getText((Node)((Node)value));
                }
                catch (Exception e) {
                    logger.severe("Failed to convert message DOM valueto string: " + e);
                    value = "";
                }
            }
            if (value != null) {
                ret = "<sd:value>" + value.toString() + "</sd:" + VALUE_NODE + ">";
            }
        }
        return ret;
    }

    protected String getChannelText(Channel channel) {
        if (channel == null) {
            return "";
        }
        StringBuffer identities = new StringBuffer();
        Set<Identity> ids = channel.getPrimaryIdentities();
        if (ids != null && ids.size() > 0) {
            identities.append("<sd:primaryIdentities>");
            for (Identity id : ids) {
                identities.append("<sd:identity name=\"" + id.getName() + "\" >");
                identities.append(XMLUtils.encodeXMLString((String)id.getFullId()));
                identities.append("</sd:identity>");
            }
            identities.append("</sd:primaryIdentities>");
        }
        return "<sd:channel name=\"" + channel.getName() + "\" " + TYPE_ATTR + "=\"" + channel.getType() + "\" >" + identities.toString() + "</sd:" + CHANNEL_NODE + ">";
    }

    protected String processAttributeContents(String value) {
        String ret = value;
        ret = ret.replaceAll("\"", "");
        return ret;
    }

    protected void record(String serviceName, String serviceVersion, Session session, Message mesg, String xml, String type, Throwable exc) {
        this.record(serviceName, session, xml, type, exc);
    }

    protected abstract void record(String var1, Session var2, String var3, String var4, Throwable var5);

    public void setRecordMessagePayload(String bool) {
        logger.info("Record message payload: " + bool);
        this.m_recordMessagePayload = bool != null && bool.equalsIgnoreCase("true");
    }
}

